package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 预算基本信息
 *
 * @author xiexb
 * @date 2023-04-24
 */
@Entity
@Table(name = "pms_budget", indexes = {
        @Index(name = "project_index", columnList = "project_id"),
        @Index(name = "wbs_index", columnList = "wbs_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_budget", comment = "预算基本信息")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsBudgetDO extends BaseModel implements Serializable  {
    /** 项目id */
    @Comment("项目id")
    @Column(name = "project_id")
    private Long projectId;

    /** wbsId */
    @Comment("wbsId")
    @Column(name = "wbs_id")
    private Long wbsId;

    /** 预算控制：刚性控制、柔性控制、不控制 */
    @Comment("预算控制：刚性控制、柔性控制、不控制")
    @Column()
    private String budgetControl;

    /** 概算金额 */
    @Comment("概算金额")
    @Column()
    private BigDecimal probablyMoney;

    /** 费用总预算 */
    @Comment("费用总预算")
    @Column()
    private BigDecimal totalMoney;

    @Column()
    @Comment("已使用预算金额")
    private BigDecimal usedMoney;

    @Column()
    @Comment("使用占比")
    private BigDecimal proportion;

    /** 预算状态：新建、审批中、激活（已审批）、关闭 */
    @Comment("预算状态：新建、审批中、激活（已审批）、关闭")
    @Column()
    private String budgetStatus;
    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Column()
    @Comment("审批时间")
    private LocalDateTime approvedTime;


    /** 预算名称 */
    @Comment("预算名称")
    @Column()
    private String budgetName;
    /** 预算编号 */
    @Comment("预算编号")
    @Column()
    private String budgetCode;
    /** 预算模板id */
    @Comment("预算模板id")
    @Column()
    private Long templateId;
    /** 开始时间 */
    @Comment("开始时间")
    @Column()
    private LocalDate startTime;
    /** 结束时间 */
    @Comment("结束时间")
    @Column()
    private LocalDate endTime;
    /** 预算附件 */
    @Comment("预算附件")
    @Column()
    private String budgetFiles;

    @Comment("币种")
    @Column()
    private String currCode;
    @Column()
    @Comment("已完成拨付的金额")
    private BigDecimal paidMoney;
    @Column()
    @Comment("可使用金额")
    private BigDecimal residueMoney;
    @Column()
    @Comment("拨付占比")
    private BigDecimal appropriationProportion;

    public void copy(PmsBudgetDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
