package com.elitesland.tw.tw5.server.prd.pms.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 项目活动 审批流程
 *
 * @author xxb
 * @date 2023-08-17
 */
@Entity
@Table(name = "pms_project_activity_process", indexes = {
        @Index(name = "proj_index", columnList = "proj_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_activity_process", comment = "项目活动 审批流程")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectActivityProcessDO extends BaseModel implements Serializable {

    /** 项目id */
    @Comment("项目id")
    @Column(name = "proj_id")
    private Long projId;

    @Comment("版本")
    @Column()
    private Integer dataVersion;

    /** 流程定义的KEY */
    @Comment("流程定义的KEY")
    @Column()
    private String procDefKey;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    @Comment("活动状态")
    @Column()
    private String activityStatus;

    @Comment("变更前活动")
    @Column(columnDefinition = "json")
    private String preChangeContent;

    @Comment("变更活动")
    @Column(columnDefinition = "json")
    private String changeContent;
}
