package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 项目集管理
 *
 * @author carl
 * @date 2023-07-03
 */
@Entity
@Table(name = "pms_project_set", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_set", comment = "项目集管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectSetDO extends BaseModel implements Serializable  {
    /** 父主键 */
    @Comment("父主键")
    @Column()
    private Long parentId;
    /** 项目集名称 */
    @Comment("项目集名称")
    @Column()
    private String setName;
    /** 项目集信息码 */
    @Comment("项目集信息码")
    @Column()
    private String setCode;
    /** 项目集信息父节点码 */
    @Comment("项目集信息父节点码")
    @Column()
    private String parentSetCode;
    /** node码 */
    @Comment("node码")
    @Column()
    private String nodeCode;
    /** 负责人id */
    @Comment("负责人id")
    @Column()
    private Long managerUserId;

    public void copy(PmsProjectSetDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
