package com.elitesland.tw.tw5.server.prd.pms.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;


/**
 * @author : WWW
 * @date : 2024-2-26
 * @desc : 项目wbs验收标准
 */
@Entity
@Table(name = "pms_project_wbs_accept")
@org.hibernate.annotations.Table(appliesTo = "pms_project_wbs_accept", comment = "项目wbs验收标准")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PmsProjectWbsAcceptDO extends BaseModel {


    /**
     * wbs主键
     */
    @Column(name = "wbs_id", columnDefinition = "bigint(20) comment 'wbs主键'")
    private Long wbsId;

    /**
     * 项目id
     */
    @Column(name = "project_id", columnDefinition = "bigint(20) comment '项目id'")
    private Long projectId;

    /**
     * 验收项类型0交付项1自定义
     */
    @Column(name = "type", columnDefinition = "int(11) comment '验收项类型0交付项1自定义'")
    private Integer type;

    /**
     * 验收内容
     */
    @Column(name = "content", columnDefinition = "varchar(255) comment '验收内容'")
    private String content;

    /**
     * 负责人id
     */
    @Column(name = "manager_user_id", columnDefinition = "bigint(20) comment '负责人id'")
    private Long managerUserId;


    /**
     * 提醒计划前n天
     */
    @Column(name = "remind_day", columnDefinition = "varchar(255) comment '提醒计划前n天'")
    private String remindDay;

    /**
     * 提醒途径0企微1站内
     */
    @Column(name = "remind_channel", columnDefinition = "int(11) comment '提醒途径0企微1站内2邮箱'")
    private Integer remindChannel;


    /**
     * 版本id
     */
    @Column(name = "version_id", columnDefinition = "bigint(20) comment '版本id'")
    private Long versionId;

    /**
     * 版本号
     */
    @Column(name = "version_no", columnDefinition = "int(11) comment '版本号'")
    private Integer versionNo;


    /**
     * 有效版本关联id
     */
    @Column(name = "eff_relate_id", columnDefinition = "bigint(20) comment '有效版本关联id'")
    private Long effRelateId;


    /**
     * wbs编码
     */
    @Column(name = "wbs_code", columnDefinition = "varchar(255) comment 'wbs编码'")
    private String wbsCode;

    @Comment("完成情况")
    @Column
    private String completeContent;

    @Comment("验收结果 0未通过 1已通过")
    @Column
    private Integer acceptanceStatus;

    @Comment("验收说明")
    @Column
    private String acceptanceInstructions;
}

