package com.elitesland.tw.tw5.server.prd.pms.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;


/**
 * 项目wbs前置依赖关系DO
 * @author wangxl
 * @date 2024-1-18
 */
@Entity
@Table(name = "pms_project_wbs_rely_temp")
@org.hibernate.annotations.Table(appliesTo = "pms_project_wbs_rely_temp", comment = "项目wbs前置依赖关系")
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PmsProjectWbsRelyTempDO extends BaseModel {

    /**
     *项目主键
     */
    @Comment("项目主键")
    @Column
    private Long projectId;

    /**
     *wbs主键(依赖建立着，后置任务)
     */
    @Comment("wbs主键(依赖建立着，后置任务)")
    @Column
    private Long wbsId;

    /**
     *wbs名称(依赖建立着，后置任务，冗余字段)
     */
    @Comment("wbs名称(依赖建立着，后置任务，冗余字段)")
    @Column
    private String wbsName;

    /**
     *wbs主键(依赖前置任务)
     */
    @Comment("wbs主键(依赖前置任务)")
    @Column
    private Long wbsRelyId;

    /**
     *wbs名称(前置依赖名称，冗余字段）
     */
    @Comment("wbs名称(前置依赖名称，冗余字段）")
    @Column
    private String wbsRelyName;

    /**
     *前置类型（FS）
     */
    @Comment("前置类型（FS）")
    @Column
    private String relyType;

    /**
     *关系类型
     */
    @Comment("关系类型")
    @Column
    private String relationType;

    /**
     *版本
     */
    @Comment("版本")
    @Column
    private Long versionId;

    /**
     *版本号
     */
    @Comment("版本号")
    @Column
    private Integer versionNo;

    /**
     *有效关联id
     */
    @Comment("有效关联id")
    @Column
    private Long effRelateId;

    /**
     *wbs编码
     */
    @Comment("wbs编码")
    @Column
    private String wbsCode;

}