package com.elitesland.tw.tw5.server.prd.pms.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * 项目wbs表DO
 *
 * @author wangxl
 * @date 2024-1-18
 */
@Entity
@Table(name = "pms_project_wbs_temp")
@org.hibernate.annotations.Table(appliesTo = "pms_project_wbs_temp", comment = "项目wbs表")
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PmsProjectWbsTempDO extends BaseModel {

    /**
     * 项目模板主键
     */
    @Comment("项目模板主键")
    @Column
    private Long tempId;

    /**
     * 父主键
     */
    @Comment("父主键")
    @Column
    private Long parentId;

    /**
     * wbs描述（名称）
     */
    @Comment("wbs描述（名称）")
    @Column
    private String wbsName;

    /**
     * wbs类型(WBS,NET,ACT,MS)
     */
    @Comment("wbs类型(WBS,NET,ACT,MS)")
    @Column
    private String wbsType;

    /**
     * wbs编码
     */
    @Comment("wbs编码")
    @Column
    private String wbsCode;

    /**
     * 父节点
     */
    @Comment("父节点")
    @Column
    private String parentWbsCode;

    /**
     * node码
     */
    @Comment("node码")
    @Column
    private String nodeCode;

    /**
     * 节点负责人
     */
    @Comment("节点负责人")
    @Column
    private Long managerUserId;

    /**
     * 成本对象，勾选为1
     */
    @Comment("成本对象，勾选为1")
    @Column
    private Boolean subjectDist;

    /**
     * 成本类型
     */
    @Comment("成本类型")
    @Column
    private String costType;

    /**
     * 预计开始时间
     */
    @Comment("预计开始时间")
    @Column
    private LocalDate preStartDate;

    /**
     * 预计结束时间
     */
    @Comment("预计结束时间")
    @Column
    private LocalDate preEndDate;

    /**
     * 预计持续时间（天）
     */
    @Comment("预计持续时间（天）")
    @Column
    private BigDecimal preDurationDay;

    /**
     * 进度(%)
     */
    @Comment("进度(%)")
    @Column
    private BigDecimal wbsProgress;

    /**
     * 实际开始时间
     */
    @Comment("实际开始时间")
    @Column
    private LocalDate startDate;

    /**
     * 实际结束时间
     */
    @Comment("实际结束时间")
    @Column
    private LocalDate endDate;

    /**
     * 实际持续时间（天）
     */
    @Comment("实际持续时间（天）")
    @Column
    private BigDecimal durationDay;

    /**
     * 最早开始时间
     */
    @Comment("最早开始时间")
    @Column
    private LocalDate earlyStartDate;

    /**
     * 最早结束时间
     */
    @Comment("最早结束时间")
    @Column
    private LocalDate earlyEndDate;

    /**
     * 最晚开始时间
     */
    @Comment("最晚开始时间")
    @Column
    private LocalDate lateStartDate;

    /**
     * 最晚结束日期
     */
    @Comment("最晚结束日期")
    @Column
    private LocalDate lateEndDate;

    /**
     * 总浮时
     */
    @Comment("总浮时")
    @Column
    private BigDecimal totalFloat;

    /**
     * 自由浮时
     */
    @Comment("自由浮时")
    @Column
    private BigDecimal freeFloat;

    /**
     * 延时
     */
    @Comment("延时")
    @Column
    private BigDecimal delayLag;

    /**
     * 是否是关键节点0:否，1：是
     */
    @Comment("是否是关键节点0:否，1：是")
    @Column
    private Boolean isKeyNode;

    /**
     * 是否自动排期0：未进行，1：已排期，2：已过期
     */
    @Comment("是否自动排期0：未进行，1：已排期，2：已过期")
    @Column
    private Boolean autoScheduling;

    /**
     * 状态
     */
    @Comment("状态")
    @Column
    private String wbsStatus;

    /**
     * 已开始状态的数据 当取消的时候 显示标志改为 true
     */
    @Comment("已开始状态的数据 当取消的时候 显示标志改为 true")
    @Column
    private Boolean cancelShowFlag;

    /**
     * 成本计划，勾选为1
     */
    @Comment("成本计划，勾选为1")
    @Column
    private Boolean costPlan;

    /**
     * 开票属性，勾选为1
     */
    @Comment("开票属性，勾选为1")
    @Column
    private Boolean invoiceAttr;

    /**
     * wbs权重
     */
    @Comment("wbs权重")
    @Column
    private BigDecimal wbsWeight;

    /**
     * wbs权重设置方式：1为手动设置  0为系统设置
     */
    @Comment("wbs权重设置方式：1为手动设置  0为系统设置")
    @Column
    private Integer manualSettingWeight;

    /**
     * 状态 0草稿 1提交
     */
    @Comment("状态 0草稿 1提交")
    @Column
    private String state;

    /**
     * 版本
     */
    @Comment("版本")
    @Column
    private Long versionId;

    /**
     * 版本号
     */
    @Comment("版本号")
    @Column
    private Integer versionNo;

    /**
     * 有效关联id
     */
    @Comment("有效关联id")
    @Column
    private Long effRelateId;

    /**
     * 预算释放标记 true 已释放  false 未释放（default）
     */
    @Comment("预算释放标记 true 已释放  false 未释放（default）")
    @Column
    private Boolean releaseFlag;

    /**
     * 收款计划ID
     */
    @Comment("收款计划ID")
    @Column
    private Long receivePlanId;

    /**
     * 拨付状态
     */
    @Comment("拨付状态")
    @Column
    private String allocateStatus;

    /**
     * 当量系数
     */
    @Comment("当量系数")
    @Column
    private BigDecimal eqvaRate;

    /**
     * 规划当量
     */
    @Comment("规划当量")
    @Column
    private BigDecimal planEqva;

    /**
     * 原始规划当量
     */
    @Comment("原始规划当量")
    @Column
    private BigDecimal originalPlanEqva;

    /**
     * 已派发当量
     */
    @Comment("已派发当量")
    @Column
    private BigDecimal distedEqva;

    /**
     * 拨付当量
     */
    @Comment("拨付当量")
    @Column
    private BigDecimal allocateEqva;

    /**
     * 拨付费用
     */
    @Comment("拨付费用")
    @Column
    private BigDecimal allocateCost;

    /**
     * 明细控制
     */
    @Comment("明细控制")
    @Column
    private Boolean detailControlFlag;

    /**
     * 占用当量数
     */
    @Comment("占用当量数")
    @Column
    private BigDecimal occupyEqva;

    /**
     * 已使用当量数
     */
    @Comment("已使用当量数")
    @Column
    private BigDecimal usedEqva;

    /**
     * 使用当量占比
     */
    @Comment("使用当量占比")
    @Column
    private BigDecimal usedEqvaProportion;

    /**
     * 使用费用占比
     */
    @Comment("使用费用占比")
    @Column
    private BigDecimal usedAmtProportion;

}