package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * wbs活动交付物
 *
 * @author carl
 * @date 2023-04-06
 */
@Entity
@Table(name = "pms_wbs_act_pay", indexes = {
        @Index(name = "project_index", columnList = "project_id"),
        @Index(name = "wbs_index", columnList = "wbs_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_wbs_act_pay", comment = "wbs活动交付物")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsWbsActPayDO extends BaseModel implements Serializable {
    /**
     * 项目主键
     */
    @Comment("项目主键")
    @Column(name = "project_id")
    private Long projectId;
    /**
     * wbs主键(仅活动类型)
     */
    @Comment("wbs主键(仅活动类型)")
    @Column(name = "wbs_id")
    private Long wbsId;
    /**
     * wbs描述（名称）
     */
    @Comment("wbs描述（名称）")
    @Column()
    private String wbsName;
    /**
     * 交付物名称
     */
    @Comment("交付物名称")
    @Column()
    private String payName;
    /**
     * 交付物类型
     */
    @Comment("交付物类型")
    @Column()
    private String payType;

    /**
     * 交付物类型
     */
    @Comment("交付物类型名称")
    @Column()
    private String payTypeName;

    public void copy(PmsWbsActPayDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
