package com.elitesland.tw.tw5.server.prd.pms.repo;

import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectCalendarDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 项目工作日历
 * @date 2023-06-21
 */
@Transactional
public interface PmsProjectCalendarRepo extends JpaRepository<PmsProjectCalendarDO, Long>, JpaSpecificationExecutor<PmsProjectCalendarDO> {

    /**
     * 根据 关联主键、关联类型查询
     * @param sourceId
     * @param sourceType
     * @return
     */
    @Query(value = "select * from pms_project_calendar where delete_flag = 0 and source_id = ?1 and source_type = ?2", nativeQuery = true)
    PmsProjectCalendarDO findBySource(Long sourceId, String sourceType);

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @Query(value = "update pms_project_calendar set delete_flag = 1  where id in (?1)", nativeQuery = true)
    @Modifying
    int deleteByKey(List<Long> ids);

    /**
     * 批量删除
     * @param sourceIds  关联主键集合
     * @param sourceType 关联类型
     * @return
     */
    @Query(value = "update pms_project_calendar set delete_flag = 1  where source_id in (?1) and source_type = ?2", nativeQuery = true)
    @Modifying
    int deleteSoftBySource(List<Long> sourceIds,String sourceType);

    /**
     * 根据主键查询个数
     * @param ids
     * @return
     */
    @Query(value = "select count(1) from pms_project_calendar where delete_flag = 0 and id in (?1)", nativeQuery = true)
    long findCountByKey(List<Long> ids);

    /**
     * 根据主键查询个数
     * @param ids
     * @return
     */
    @Query(value = "select * from pms_project_calendar where delete_flag = 0 and id in (?1)", nativeQuery = true)
    List<PmsProjectCalendarDO> findByKey(List<Long> ids);


    /**
     * 根据 关联主键、关联类型查询
     * @param sourceIds
     * @param sourceType
     * @return
     */
    @Query(value = "select * from pms_project_calendar where delete_flag = 0 and source_id in ?1 and source_type = ?2", nativeQuery = true)
    List<PmsProjectCalendarDO> findBySources(List<Long> sourceIds, String sourceType);
}
