package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.BuProjectMembersPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.BuProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectMembersService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectMembersVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.BuProjectMembersConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.BuProjectMembersDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.BuProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.BuProjectMembersRepo;
import com.elitesland.tw.tw5.server.prd.system.constant.SystemSettingsItemEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * BU项目成员管理
 *
 * @author carl
 * @date 2023-11-29
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BuProjectMembersServiceImpl extends BaseServiceImpl implements BuProjectMembersService {

    private final BuProjectMembersRepo buProjectMembersRepo;
    private final BuProjectMembersDAO buProjectMembersDAO;
    private final TaskCommonService taskCommonService;
    private final CacheUtil cacheUtil;

    @Override
    public PagingVO<BuProjectMembersVO> queryPaging(BuProjectMembersQuery query) {
        return buProjectMembersDAO.queryPaging(query);
    }

    @Override
    public List<BuProjectMembersVO> queryListDynamic(BuProjectMembersQuery query) {
        List<BuProjectMembersVO> membersVOS = buProjectMembersDAO.queryListDynamic(query);
        if (membersVOS.size() > 0) {
            //获取任务包数量，为了功能解耦暂不关联查
            List<Long> resIds = membersVOS.stream().map(BuProjectMembersVO::getResId).distinct().collect(Collectors.toList());
            TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
            taskPackageQuery.setReasonType(PmsReasonTypeEnum.PROJ_BU.getCode());
            taskPackageQuery.setReasonId(query.getProjId());
            taskPackageQuery.setReceiverResIds(resIds);
            List<TaskPackageVO> taskPackageVOS = taskCommonService.queryTaskPackageList(taskPackageQuery);
            Map<Long, List<TaskPackageVO>> mapList = taskPackageVOS.stream().collect(Collectors.groupingBy(TaskPackageVO::getReceiverResId));
            membersVOS.forEach(membersVO -> {
                membersVO.setTaskPackageCount(0);
                List<TaskPackageVO> taskPackageVOS1 = mapList.get(membersVO.getResId());
                if (!ObjectUtils.isEmpty(taskPackageVOS1)) {
                    membersVO.setTaskPackageCount(taskPackageVOS1.size());
                }
            });
        }

        return membersVOS;
    }

    @Override
    public BuProjectMembersVO queryByKey(Long key) {
        BuProjectMembersDO entity = buProjectMembersRepo.findById(key).orElseGet(BuProjectMembersDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BuProjectMembersVO vo = BuProjectMembersConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BuProjectMembersVO insert(BuProjectMembersPayload payload) {
        // 一个项目下，资源id需唯一
        if (!ObjectUtils.isEmpty(payload.getResId())) {
            BuProjectMembersVO vo = buProjectMembersDAO.queryByProjAndRes(payload.getProjId(), payload.getResId());
            if (!ObjectUtils.isEmpty(vo)) {
                if (payload.getId() == null || !vo.getId().equals(payload.getId())) {
                    throw TwException.error("", "项目成员已经存在！");
                }
            }
        }

        BuProjectMembersDO entityDo = BuProjectMembersConvert.INSTANCE.toDo(payload);
        //判断是否创建初始化任务包
        PrdSystemSettingVO settingVO = cacheUtil.getSystemSetting(SystemSettingsItemEnum.prj_member_init_task.getCode());
        if (settingVO != null && StringUtils.hasText(settingVO.getSettingValue()) && "true".equals(settingVO.getSettingValue())) {
            taskCommonService.batchCreatTaskPackage(PmsReasonTypeEnum.PROJ_BU.getCode(), payload.getProjId(), Arrays.asList(payload.getResId()), null);
        }

        return BuProjectMembersConvert.INSTANCE.toVo(buProjectMembersRepo.save(entityDo));
    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public BuProjectMembersVO update(BuProjectMembersPayload payload) {
//        BuProjectMembersDO entity = buProjectMembersRepo.findById(payload.getId()).orElseGet(BuProjectMembersDO::new);
//        Assert.notNull(entity.getId(), "不存在");
//        BuProjectMembersDO entityDo = BuProjectMembersConvert.INSTANCE.toDo(payload);
//        entity.copy(entityDo);
//        return BuProjectMembersConvert.INSTANCE.toVo(buProjectMembersRepo.save(entity));
//    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BuProjectMembersPayload payload) {
        BuProjectMembersDO entity = buProjectMembersRepo.findById(payload.getId()).orElseGet(BuProjectMembersDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = buProjectMembersDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<BuProjectMembersVO> pmsProjectMembersVOS = buProjectMembersDAO.queryByKeys(keys);
            if (pmsProjectMembersVOS.size() > 0) {
                List<Long> collect = pmsProjectMembersVOS.stream().map(BuProjectMembersVO::getProjId).distinct().collect(Collectors.toList());
                if (collect.size() > 1) {
                    throw TwException.error("", "不可同时删除多项目下的成员");
                }
                List<Long> resIds = pmsProjectMembersVOS.stream().map(BuProjectMembersVO::getResId).distinct().collect(Collectors.toList());
                List<TimesheetVO> timesheetVOS = taskCommonService.queryTimeSheets(PmsReasonTypeEnum.PROJ_BU.getCode(), collect.get(0), resIds);
                if (!ObjectUtils.isEmpty(timesheetVOS)) {
                    throw TwException.error("", "已提交工时，不可删除成员");
                }
                buProjectMembersDAO.deleteSoft(keys);
            }
            buProjectMembersDAO.deleteSoft(keys);
        }
    }

}
