package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.cal.query.CalResourcePriceQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalResourceService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeCommonService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPackagePayload;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.DistributeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistBroadcastDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistributeDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistributeRespondDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskInfoDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskPackageDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 派发相关 通用接口
 *
 * @author xxb
 * @date 2023-10-23
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsDistributeCommonServiceImpl implements PmsDistributeCommonService {

    private final PmsDistributeDAO pmsDistributeDAO;

    private final PmsDistBroadcastDAO pmsDistBroadcastDAO;

    private final PmsDistributeRespondDAO pmsDistributeRespondDAO;

    private final PmsProjectService pmsProjectService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;
    private final TaskInfoDAO taskInfoDAO;

    private final TaskPackageDAO taskPackageDAO;

    private final CacheUtil cacheUtil;

    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;

    private final CalResourceService calResourceService;
    private final BudgetCommonService budgetCommonService;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByReason(String reasonType, List<Long> reasonIds) {
        if (ObjectUtils.isEmpty(reasonType)) {
            throw TwException.error("", "派发类型 不可为空，请核验！");
        }
        if (ObjectUtils.isEmpty(reasonIds)) {
            throw TwException.error("", "派发事由ID 不可为空，请核验！");
        }
        deleteSoftByList(pmsDistributeDAO.queryByReasons(reasonIds, reasonType));
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByList(List<PmsDistributeVO> list) {
        if (!ObjectUtils.isEmpty(list)) {
            // 检查所选数据行的「派发状态」和「审批状态」，若存在派发状态 != 新建 或 审批状态 != 未提交 的数据行，toast提示：“仅派发状态为新建且审批状态未提交的数据可以删除”
            long count = list.stream().filter(v -> !DistributeEnum.distStatus.CREATE.getCode().equals(v.getDistStatus())).count();
            if (count > 0) {
                throw TwException.error("", "仅派发状态为新建且审批状态未提交的数据可以删除，请核验！");
            }
            List<Long> keys = list.stream().map(PmsDistributeVO::getId).collect(Collectors.toList());
            // 删除派发表
            pmsDistributeDAO.deleteSoft(keys);
            // 删除广播表 、 响应表
            keys = list.stream().filter(v -> DistributeEnum.distMethod.BROADCASTING.getCode().equals(v.getDistMethod())).map(v -> v.getId()).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(keys)) {
                pmsDistBroadcastDAO.deleteByDistIds(keys);
                pmsDistributeRespondDAO.deleteByDistIds(keys);
            }
        }
    }

    @Override
    public void updateReasonStatus(PmsDistributeVO distributeVO) {
        //更改项目状态   当接受资源通过派发后，会修改原项目的项目经理id（只有合同项目涉及派发）
        if (DistributeEnum.distType.PROJECT.getCode().equals(distributeVO.getReasonType())) {
            // DISTRIBUTING 派发中  DISTRIBUTED 已派发
            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.DISTRIBUTING.getCode())) {
                pmsProjectService.updateProjStatus(distributeVO.getReasonId(), ProjectStatusEnum.APPROVING.getCode(), distributeVO.getReceiverResId());
            }
            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.DISTRIBUTED.getCode())) {
                pmsProjectService.updateProjStatus(distributeVO.getReasonId(), ProjectStatusEnum.ACTIVE.getCode(), distributeVO.getReceiverResId());
            }
            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.CREATE.getCode())) {
                pmsProjectService.updateProjStatus(distributeVO.getReasonId(), ProjectStatusEnum.CREATE.getCode(), null);
            }
        }
        //更改任务状态
        if (DistributeEnum.distType.TASK.getCode().equals(distributeVO.getReasonType()) || DistributeEnum.distType.TASK_PACKAGE.getCode().equals(distributeVO.getReasonType())) {
            String status = "";
            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.DISTRIBUTING.getCode())) {
                status = TaskStatusEnum.DISPATCH.getCode();
            }
            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.DISTRIBUTED.getCode())) {
                status = TaskStatusEnum.INPROCESS.getCode();
            }
            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.CREATE.getCode())) {
                status = TaskStatusEnum.CREATE.getCode();
            }
            updateFromDistribute(distributeVO, status);
        }
    }

    /**
     * 校验预算数据
     *
     * @param taskInfoVOs
     */
    void checkBudget(List<TaskInfoVO> taskInfoVOs) {
        Map<String, List<TaskInfoVO>> projMap = new HashMap<>();
        taskInfoVOs.forEach(taskInfoPayload -> {
            //拆分任务不用校验预算
            if (taskInfoPayload.getTaskParentId() == null) {
                String reasonType = taskInfoPayload.getReasonType();
                Long reasonId = taskInfoPayload.getReasonId();
                String key = reasonType + "-" + reasonId;
                List<TaskInfoVO> taskInfoPayloads1 = projMap.get(key);
                if (taskInfoPayloads1 == null) {
                    taskInfoPayloads1 = new ArrayList<>();
                }
                taskInfoPayloads1.add(taskInfoPayload);
                projMap.put(key, taskInfoPayloads1);
            }
        });
        //校验项目总预算
        projMap.forEach((key, value) -> {
            String[] split = key.split("-");
            String reasonType = split[0];
            Long reasonId = Long.valueOf(split[1]);
            //总的计划当量
            BigDecimal planAllEqva = value.stream()
                    .map(TaskInfoVO::getPlanEqva)
                    .filter(Objects::nonNull)
                    .reduce(BigDecimal::add)
                    .orElse(BigDecimal.ZERO);
            budgetCommonService.checkBudgetEqva(reasonId, reasonType, null, planAllEqva);
            //校验预算活动
            Map<Long, List<TaskInfoVO>> collect = value.stream().filter(pay -> pay.getRelatedActId() != null).collect(Collectors.groupingBy(TaskInfoVO::getRelatedActId));
            collect.forEach((key0, value0) -> {
                //总的计划当量
                BigDecimal planAllEqva0 = value.stream()
                        .map(TaskInfoVO::getPlanEqva)
                        .filter(Objects::nonNull)
                        .reduce(BigDecimal::add)
                        .orElse(BigDecimal.ZERO);
                budgetCommonService.checkBudgetEqva(reasonId, reasonType, key0, planAllEqva0);
            });
        });
    }

    @Override
    public void checkDistribute(PmsDistributeVO distributeVO) {
        if (DistributeEnum.distType.PROJECT.getCode().equals(distributeVO.getReasonType())) {
            //校验项目派发
            PmsProjectVO pmsProjectVO = pmsProjectService.queryByKey(distributeVO.getReasonId());
            if (pmsProjectVO == null) {
                throw TwException.error("", "派发项目存在");
            }
            if (!pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.CREATE.getCode())) {
                throw TwException.error("", "仅支持新建状态派发");
            }
            CalAccountVO calAccountVO = calResourceService.queryAccount(CalAccTypeEnum.BU.getCode(), pmsProjectVO.getDeliBuId());
            //可用当量
            BigDecimal avalQty = calAccountVO.getAvalQty() == null ? BigDecimal.ZERO : calAccountVO.getAvalQty();
            //可用金额
            BigDecimal avalAmt = calAccountVO.getAvalAmt() == null ? BigDecimal.ZERO : calAccountVO.getAvalAmt();
            //项目总当量
            BigDecimal totalEqva = pmsProjectVO.getTotalEqva() == null ? BigDecimal.ZERO : pmsProjectVO.getTotalEqva();
            //费用总成本
            BigDecimal totalCost = pmsProjectVO.getTotalCost() == null ? BigDecimal.ZERO : pmsProjectVO.getTotalCost();

            calAccountVO.setAvalQty(avalQty.subtract(totalEqva));
            calAccountVO.setAvalAmt(avalAmt.subtract(totalCost));
            //核验账户余额
            calResourceService.checkAccount(calAccountVO);
        }
        if (DistributeEnum.distType.TASK.getCode().equals(distributeVO.getReasonType()) || DistributeEnum.distType.TASK_PACKAGE.getCode().equals(distributeVO.getReasonType())) {
            //事由类型
            String reasonType = "";
            //事由id
            Long reasonId = 0L;
//            //总的计划当量
//            BigDecimal planAllEqva = BigDecimal.ZERO;
//            //任务包结算单间
//            BigDecimal settlePrice = BigDecimal.ZERO;
            List<TaskInfoVO> taskInfoVOs = new ArrayList<>();
            if (DistributeEnum.distType.TASK.getCode().equals(distributeVO.getReasonType())) {
                TaskInfoVO taskInfoVO = taskInfoDAO.queryByKey(distributeVO.getReasonId());
                if (taskInfoVO == null) {
                    throw TwException.error("", "派发任务存在");
                }
                if (!taskInfoVO.getTaskStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                    throw TwException.error("", "仅支持新建状态下的任务派发");
                }

                reasonType = taskInfoVO.getReasonType();
                reasonId = taskInfoVO.getReasonId();

                taskInfoVOs.add(taskInfoVO);

//                planAllEqva = taskInfoVO.getPlanEqva();
//                settlePrice = taskInfoVO.getSettlePrice();
            } else {
                //任务包要汇总所有任务的计划当量和
                TaskPackageVO taskPackageVO = taskPackageDAO.queryByKey(distributeVO.getReasonId());
                reasonType = taskPackageVO.getReasonType();
                reasonId = taskPackageVO.getReasonId();
//                settlePrice = taskPackageVO.getSettlePrice();
                if (taskPackageVO == null) {
                    throw TwException.error("", "派发任务包存在");
                }
                if (!taskPackageVO.getTaskPackageStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                    throw TwException.error("", "仅支持新建状态下的任务包派发");
                }
                List<TaskInfoVO> taskInfoVOS = taskInfoDAO.queryByTaskPackageId(distributeVO.getReasonId());
                taskInfoVOs.addAll(taskInfoVOS);
                //                if (!ObjectUtils.isEmpty(taskInfoVOS)) {
//                    planAllEqva = taskInfoVOS.stream()
//                            .map(TaskInfoVO::getPlanEqva)
//                            .filter(Objects::nonNull)
//                            .reduce(BigDecimal::add)
//                            .orElse(BigDecimal.ZERO);
//                }
            }
            if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
                PmsProjectVO pmsProjectVO = pmsProjectService.queryByKey(reasonId);
                if (pmsProjectVO == null) {
                    throw TwException.error("", "派发项目存在");
                }
                if (!pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                    throw TwException.error("", "仅支持项目激活状态派发");
                }
            }
            if (reasonType.equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
                BuProjectVO buProjectVO = buProjectService.queryByKey(reasonId);
                if (buProjectVO == null) {
                    throw TwException.error("", "派发项目存在");
                }
                if (!buProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                    throw TwException.error("", "仅支持项目激活状态派发");
                }
            }
            if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                CrmOpportunityQuery query = new CrmOpportunityQuery();
                query.setProjectId(reasonId);
                List<CrmOpportunityListVO> crmOpportunityListVOS = opportunityService.queryListDynamic(query);
                if (ObjectUtils.isEmpty(crmOpportunityListVOS)) {
                    throw TwException.error("", "事由不存在");
                }
                CrmOpportunityListVO crmOpportunityVO = crmOpportunityListVOS.get(0);

                if (!crmOpportunityVO.getProjectStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                    throw TwException.error("", "仅支持项目激活状态派发");
                }
            }
            //派发时校验预算
            checkBudget(taskInfoVOs);
            //校验派发资源
            checkUserStatus(taskInfoVOs);
            //任务派发不应和核算体系挂钩
//            String auType = reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) ? CalAccTypeEnum.PROJ.getCode() : reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode()) ? CalAccTypeEnum.OPP.getCode() : CalAccTypeEnum.BU_PROJ.getCode();
//            CalAccountVO calAccountVO = calResourceService.queryAccount(auType, reasonId);
//            //可用当量
//            BigDecimal avalQty = calAccountVO.getAvalQty() == null ? BigDecimal.ZERO : calAccountVO.getAvalQty();
//            //可用金额
//            BigDecimal avalAmt = calAccountVO.getAvalAmt() == null ? BigDecimal.ZERO : calAccountVO.getAvalAmt();
//
//            calAccountVO.setAvalQty(avalQty.subtract(planAllEqva));
//            calAccountVO.setAvalAmt(avalAmt.subtract(planAllEqva.multiply(settlePrice)));
//            //核验账户余额
//            calResourceService.checkAccount(calAccountVO);
        }
    }

    /**
     * 校验派发资源
     *
     * @param taskInfoVOs
     */
    void checkUserStatus(List<TaskInfoVO> taskInfoVOs) {
        taskInfoVOs.forEach(vo -> {
            PrdOrgEmployeeVO employee = cacheUtil.getEmployee(vo.getTaskResId());
            if (!employee.getResourceStatus().equals(SystemDefaultEnum.DefaultResourceStatus.getCode()) && !employee.getResourceStatus().equals(SystemDefaultEnum.LeaveIngResourceStatus.getCode())) {
                throw TwException.error("", "接包资源状态暂不可接收任务派发");
            }
            if (!employee.getHrStatus().equals(SystemDefaultEnum.DefaultHrStatus.getCode())) {
                throw TwException.error("", "接包资源状态暂不可接收任务派发");
            }
        });

    }

    /**
     * 更新任务或任务包数据
     *
     * @param distributeVO
     * @param status
     */
    void updateFromDistribute(PmsDistributeVO distributeVO, String status) {
        String reasonType = distributeVO.getReasonType();
        Long reasonId = distributeVO.getReasonId();
        Long receiverResId = distributeVO.getReceiverResId();

        if (DistributeEnum.distType.TASK_PACKAGE.getCode().equals(reasonType)) {
            TaskPackageVO taskPackageVO = taskPackageDAO.queryByKey(reasonId);
            if (taskPackageVO != null) {

                // 更新任务包状态
                TaskPackagePayload taskPackagePayload = new TaskPackagePayload();
                taskPackagePayload.setId(reasonId);
                taskPackagePayload.setTaskPackageStatus(status);
                if (!taskPackageVO.getReceiverResId().equals(receiverResId)) {
                    //接包资源改变
                    String taskPackageName = taskPackageVO.getReasonName() + "任务包-" + cacheUtil.getUserName(receiverResId) + "-" + taskPackageVO.getStartDate().toString() + "~" + taskPackageVO.getEndDate().toString();
                    taskPackagePayload.setReceiverResId(receiverResId);
                    taskPackagePayload.setTaskPackageName(taskPackageName);
                    //获取资源收入价格
                    CalResourcePriceQuery query = new CalResourcePriceQuery();
                    query.setResId(receiverResId);
                    if (taskPackageVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
                        query.setProjId(taskPackageVO.getReasonId());
                    }
                    BigDecimal bigDecimal = calResourceService.queryIncomePrice(query);
                    taskPackagePayload.setIncomePrice(bigDecimal);

                    taskPackagePayload.setReceiverBuId(cacheUtil.getDefaultOrgIdByUserId(receiverResId));
                    taskPackagePayload.setEqvaRatio(prdOrgEmployeeEqvaRatioService.getEqvaRatio(receiverResId, null));

                }
                taskPackageDAO.updateByKeyDynamic(taskPackagePayload);

                //更新任务状态
                taskInfoDAO.updateStatusByTaskPackageId(reasonId, status, receiverResId);
            } else {
                throw TwException.error("", "修改数据不存在");
            }
        } else {
            Boolean isUp = true;
            if (status.equals(TaskStatusEnum.CREATE.getCode())) {
                /**
                 * 状态为新建,判断是不是拆分任务包
                 * 拆分任务包要退回拆分当量到上级任务中
                 * 删除拆分的任务
                 */
                TaskInfoVO infoVO = taskInfoDAO.queryByKey0(reasonId);
                if (infoVO.getTaskParentId() != null) {
                    TaskInfoVO infoVO1 = taskInfoDAO.queryByKey0(infoVO.getTaskParentId());
                    BigDecimal totalEqva = infoVO1.getTotalEqva().add(infoVO.getPlanEqva());
                    BigDecimal splitEqva = infoVO1.getSplitEqva().subtract(infoVO.getPlanEqva());
                    // 更新上级任务总当量和拆分当量
                    TaskInfoPayload taskParentPayload = new TaskInfoPayload();
                    taskParentPayload.setId(infoVO.getTaskParentId());
                    taskParentPayload.setTotalEqva(totalEqva);
                    taskParentPayload.setSplitEqva(splitEqva);
                    taskInfoDAO.updateByKeyDynamic(taskParentPayload);

                    taskInfoDAO.deleteSoft(List.of(reasonId));
                    isUp = false;
                    //删除流程 (工作流服务会出现事务问题，不能直接删除，先注释掉）
//                    workflowUtil.deleteProcess(DeleteProcessPayload.of(distributeVO.getProcInstId(), "拆分任务驳回后删除"));
                }
            }
            if (isUp) {
                taskInfoDAO.updateStatus(reasonId, status, receiverResId);
            }

        }
//
//        if (TaskStatusEnum.INPROCESS.getCode().equals(status)) {
//            // 如果任务被激活,添加项目成员
//            pmsProjectMembersService.insertFromTask(reasonId, receiverResId);
//        }
    }

}
