package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.query.ComLogQuery;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.*;
import com.elitesland.tw.tw5.api.prd.pms.query.*;
import com.elitesland.tw.tw5.api.prd.pms.service.*;
import com.elitesland.tw.tw5.api.prd.pms.vo.*;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.task.service.PmsWbsTaskService;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsWbsTaskVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.ComChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.ComLogTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5.server.common.util.AutoScheduling;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.personplan.dao.ProRelatedPartiesDao;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjWbsAllocateStateEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectWbsTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.*;
import com.elitesland.tw.tw5.server.prd.pms.dao.*;
import com.elitesland.tw.tw5.server.prd.pms.entity.*;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsAcceptRepo;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsResourceRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.sf.mpxj.*;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mspdi.MSPDIWriter;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目wbs表
 *
 * @author carl
 * @date 2023-04-06
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectWbsServiceImpl extends BaseServiceImpl implements PmsProjectWbsService {
    private final CacheUtil cacheUtil;
    private final PmsProjectWbsDAO pmsProjectWbsDAO;
    private final PmsWbsActCostDAO pmsWbsActCostDAO;
    private final PmsWbsActPayDAO pmsWbsActPayDAO;
    private final ComLogService logService;
    private final ComChangeService changeService;
    private final PmsProjectDAO pmsProjectDAO;
    private final ChangeFieldUtil changeFieldUtil;
    private final PmsProjectWbsSnapshotService planSnapshotService;
    private final PmsProjectCalendarService calendarService;
    private final PmsProjectWbsRelyDAO pmsProjectWbsRelyDAO;
    private final PmsBudgetDetailService budgetDetailService;
    private final ConReceivablePlanService conReceivablePlanService;
    private final ProRelatedPartiesDao proRelatedPartiesDao;
    private final PmsProjectWbsAcceptService pmsProjectWbsAcceptService;

    @Autowired
    @Lazy
    private PmsProjectWbsResourceService pmsProjectWbsResourceService;

    @Autowired
    @Lazy
    private PmsProjectWbsRelyService pmsProjectWbsRelyService;
    @Autowired
    @Lazy
    private ProRelatedPartiesService proRelatedPartiesService;

    private final PmsWbsVersionService pmsWbsVersionService;

    private final PmsProjectWbsResourceDao pmsProjectWbsResourceDao;
    private final PmsProjectWbsResourceRepo pmsProjectWbsResourceRepo;

    private final PmsProjectWbsAcceptDao pmsProjectWbsAcceptDao;
    private final PmsProjectWbsAcceptRepo pmsProjectWbsAcceptRepo;

    // @Autowired
    // @Lazy
    // private TaskProService taskProService;
    // @Resource
    // @Lazy
    // private PmsWbsBudgetDetailsService pmsWbsBudgetDetailsService;

    public PmsWbsTaskService getPmsWbsTaskService() {
        return SpringUtil.getBean(PmsWbsTaskService.class);
    }


    /**
     * 节点  的  进度 和状态缓存
     */
    private static Map<Long, Map<String, Object>> progressAndStatusCache = new HashMap<>();

    /**
     * 核验操作
     */
//    void checkOperate(PmsProjectWbsDataPayload payload, List<PmsProjectWbsVO> wbsVOS, PmsProjectVO pmsProjectVO) {
//        Long loginUserId = GlobalUtil.getLoginUserId();
//        List<Long> userIds = Arrays.asList(pmsProjectVO.getManagerUserId(), pmsProjectVO.getCreateUserId());
//        //如果是项目经理或者项目创建人直接通过
//        if (!userIds.contains(loginUserId)) {
//            //判断删除权限
//            if (!ObjectUtils.isEmpty(payload.getDelWbsIds())) {
//                List<PmsProjectWbsVO> projectWbsVOs = wbsVOS.stream().filter(wbsVO -> payload.getDelWbsIds().contains(wbsVO.getId())).collect(Collectors.toList());
//                projectWbsVOs.forEach(projectWbsVO -> {
//                    if (StringUtils.hasText(projectWbsVO.getParentWbsCode())) {
//                        List<Long> parentUserIds = new ArrayList<>();
//                        getParentUserIds(parentUserIds, projectWbsVO.getParentWbsCode(), wbsVOS);
//                        if (!parentUserIds.contains(loginUserId)) {
//                            //无操作权限
//                            throw TwException.error("", "无[" + projectWbsVO.getWbsName() + "]删除权限，请核验！");
//                        }
//                    } else {
//                        //如果是顶层节点则本人无操作权限
//                        throw TwException.error("", "无[" + projectWbsVO.getWbsName() + "]删除权限，请核验！");
//                    }
//                });
//            }
//            /**
//             *   判断新增或编辑权限
//             *   1.新增，只有上级节点负责人
//             *   2.编辑，上级负责人和本级负责人
//             *   3.编辑--修改节点上下级关系， 只有上级负责人
//             *   3.编辑--修改节点负责人， 只有上级负责人
//             */
//            if (!ObjectUtils.isEmpty(payload.getWbsPayloads())) {
//                List<String> collect0 = payload.getWbsPayloads().stream().map(PmsProjectWbsPayload::getWbsCode).distinct().collect(Collectors.toList());
//                if (payload.getWbsPayloads().size() != collect0.size()) {
//                    throw TwException.error("", "wbs编码不可重复，请核验！");
//                }
//                payload.getWbsPayloads().forEach(wbsPayload -> {
//                    if (ObjectUtils.isEmpty(wbsPayload.getWbsCode())) {
//                        throw TwException.error("", "编码不存在，请核验！");
//                    }
//                    if (ObjectUtils.isEmpty(wbsPayload.getWbsType())) {
//                        throw TwException.error("", "类型不存在，请核验！");
//                    }
//                    if (ObjectUtils.isEmpty(wbsPayload.getParentWbsCode())) {
//                        if (!wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode()) && !wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.NET.getCode())) {
//                            throw TwException.error("", "一级节点只可新建“WBS元素”和“网络”，请核验！");
//                        }
//                    } else {
//                        Optional<PmsProjectWbsPayload> first = payload.getWbsPayloads().stream().filter(wbsPayload0 -> wbsPayload0.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
//                        String parentWbsType = "";
//
//                        if (first.isPresent()) {
//                            PmsProjectWbsPayload parentWbsPayload = first.get();
//                            parentWbsType = parentWbsPayload.getWbsType();
//                            //判断时间是否合理
//                            if (wbsPayload.getPreStartDate() != null) {
//                                if (parentWbsPayload.getPreStartDate() != null && parentWbsPayload.getPreStartDate().isAfter(wbsPayload.getPreStartDate())) {
//                                    throw TwException.error("", "[" + wbsPayload.getWbsName() + "]开始时间不在上级节点范围内，请核验！");
//                                }
//                            }
//                            if (wbsPayload.getPreEndDate() != null) {
//                                if (parentWbsPayload.getPreEndDate() != null && parentWbsPayload.getPreEndDate().isBefore(wbsPayload.getPreEndDate())) {
//                                    throw TwException.error("", "[" + wbsPayload.getWbsName() + "]结束时间不在上级节点范围内，请核验！");
//                                }
//                            }
//                        } else {
//                            //判断时间是否合理
//                            Optional<PmsProjectWbsVO> first0 = wbsVOS.stream().filter(wbsVO -> wbsVO.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
//                            if (first0.isPresent()) {
//                                PmsProjectWbsVO parentWbsVO = first0.get();
//                                parentWbsType = parentWbsVO.getWbsType();
//                                if (wbsPayload.getPreStartDate() != null) {
//                                    if (parentWbsVO.getPreStartDate() != null && parentWbsVO.getPreStartDate().isAfter(wbsPayload.getPreStartDate())) {
//                                        throw TwException.error("", "[" + wbsPayload.getWbsName() + "]开始时间不在上级节点范围内，请核验！");
//                                    }
//                                }
//                                if (wbsPayload.getPreEndDate() != null) {
//                                    if (parentWbsVO.getPreEndDate() != null && parentWbsVO.getPreEndDate().isBefore(wbsPayload.getPreEndDate())) {
//                                        throw TwException.error("", "[" + wbsPayload.getWbsName() + "]结束时间不在上级节点范围内，请核验！");
//                                    }
//                                }
//                            } else {
//                                throw TwException.error("", wbsPayload.getParentWbsCode() + "编码数据不存在，请核验！");
//                            }
//                        }
//                        if (wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode())) {
//                            if (!parentWbsType.equals(ProjectWbsTypeEnum.WBS.getCode())) {
//                                throw TwException.error("", "WBS元素上级只能是WBS元素，请核验！");
//                            }
//                        }
//                        if (wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.NET.getCode())) {
//                            if (!parentWbsType.equals(ProjectWbsTypeEnum.WBS.getCode())) {
//                                throw TwException.error("", "网络上级只能是WBS元素，请核验！");
//                            }
//                        }
//                        if (wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode())) {
//                            if (!parentWbsType.equals(ProjectWbsTypeEnum.WBS.getCode()) && !parentWbsType.equals(ProjectWbsTypeEnum.NET.getCode())) {
//                                throw TwException.error("", "活动上级只能是WBS元素或网络，请核验！");
//                            }
//                        }
//                        if (wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
//                            if (!parentWbsType.equals(ProjectWbsTypeEnum.WBS.getCode())) {
//                                throw TwException.error("", "里程碑上级只能是WBS元素，请核验！");
//                            }
//                        }
//                        BigDecimal wbsWeight = wbsPayload.getWbsWeight();
//                        if (!ObjectUtils.isEmpty(wbsWeight)) {
//                            if (new BigDecimal(wbsWeight.intValue()).compareTo(wbsWeight) != 0) {
//                                throw TwException.error("", "权重只能是整数，请核验！");
//                            }
//                            if (wbsWeight.intValue() < 0 || wbsWeight.intValue() > 100) {
//                                throw TwException.error("", "权重只能是0-100的整数，请核验！");
//                            }
//                        }
//                    }
//
//
//                    //赋值
//                    transferData(wbsPayload);
//
//                    if (StringUtils.hasText(wbsPayload.getParentWbsCode())) {
//                        //是否需要核验
//                        Boolean isCheck = true;
//                        //新增
//                        if (wbsPayload.getId() == null) {
//                            isCheck = false;
//                        } else {
//                            //变更操作分为节点上下级关系变更和数据变更
//                            Optional<PmsProjectWbsVO> first = wbsVOS.stream().filter(wbsVO -> wbsVO.getId().equals(wbsPayload.getId())).findFirst();
//                            if (first.isPresent()) {
//                                PmsProjectWbsVO pmsProjectWbsVO = first.get();
//
//                                if (!pmsProjectWbsVO.getParentWbsCode().equals(wbsPayload.getParentWbsCode())) {
//                                    isCheck = false;
//                                }
//                                if ((pmsProjectWbsVO.getManagerUserId() == null && wbsPayload.getManagerUserId() != null) || (wbsPayload.getManagerUserId() == null && pmsProjectWbsVO.getManagerUserId() != null)) {
//                                    isCheck = false;
//                                }
//                                if (pmsProjectWbsVO.getManagerUserId() != null && wbsPayload.getManagerUserId() != null && !pmsProjectWbsVO.getManagerUserId().equals(pmsProjectWbsVO.getManagerUserId())) {
//                                    isCheck = false;
//                                }
//                                if (isCheck) {
//                                    //表示仅基础数据变更，负责人可以直接操作
//                                    if (pmsProjectWbsVO.getManagerUserId() == null || !pmsProjectWbsVO.getManagerUserId().equals(loginUserId)) {
//                                        //说明不是节点负责人发起的内容变更，还要判断是否是上级
//                                        isCheck = false;
//                                    }
//                                }
//
//                            } else {
//                                throw TwException.error("", "[" + wbsPayload.getWbsName() + "]变更数据不存在，请核验！");
//                            }
//                        }
//                        if (!isCheck) {
//                            List<Long> parentUserIds = new ArrayList<>();
//                            getParentUserIds(parentUserIds, wbsPayload.getParentWbsCode(), wbsVOS);
//                            if (!parentUserIds.contains(loginUserId)) {
//                                //无操作权限
//                                throw TwException.error("", "无[" + wbsPayload.getWbsName() + "]该操作权限，请核验！");
//                            }
//                        }
//                    } else {
//                        //如果是顶层节点则本人无操作权限
//                        throw TwException.error("", "无[" + wbsPayload.getWbsName() + "]操作权限，请核验！");
//                    }
//                });
//            }
//        }
//    }

    /**
     * 翻译数据
     *
     * @param payload
     */
    void transferData(PmsProjectWbsPayload payload) {
        payload.setCostTypeName(cacheUtil.transferSystemSelection("PMS:WBS:ACT_COST:TYPE", payload.getCostType()));
        String wbsTypeName = payload.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode()) ? "WBS元素" : payload.getWbsType().equals(ProjectWbsTypeEnum.NET.getCode()) ? "网络" : payload.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) ? "活动" : "里程碑";
        payload.setWbsTypeName(wbsTypeName);

        if (payload.getInvoiceAttr() != null) {
            payload.setInvoiceAttrName(payload.getInvoiceAttr() == 0 ? "取消勾选" : "勾选");
        }
        if (payload.getCostPlan() != null) {
            payload.setCostPlanName(payload.getCostPlan() == 0 ? "取消勾选" : "勾选");
        }
        if (payload.getSubjectDist() != null) {
            payload.setSubjectDistName(payload.getSubjectDist() == 0 ? "取消勾选" : "勾选");
        }
    }

    /**
     * 获取节点所有上级负责人
     *
     * @param parentUserIds
     * @param parentWbsCode
     * @param projectWbsVOs
     */
    void getParentUserIds(List<Long> parentUserIds, String parentWbsCode, List<PmsProjectWbsVO> projectWbsVOs) {
        Optional<PmsProjectWbsVO> first = projectWbsVOs.stream().filter(wbsVO -> wbsVO.getWbsCode().equals(parentWbsCode)).findFirst();
        if (first.isPresent()) {
            PmsProjectWbsVO pmsProjectWbsVO = first.get();
            if (!ObjectUtils.isEmpty(pmsProjectWbsVO.getManagerUserId())) {
                parentUserIds.add(pmsProjectWbsVO.getManagerUserId());
            }
            if (StringUtils.hasText(pmsProjectWbsVO.getParentWbsCode())) {
                getParentUserIds(parentUserIds, pmsProjectWbsVO.getParentWbsCode(), projectWbsVOs);
            } else {
                return;
            }
        } else {
            return;
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectWbsVO batchInsertOrUpdate(PmsProjectWbsDataPayload payload) {
        //核验数据
        if (ObjectUtils.isEmpty(payload.getProjectId())) {
            throw TwException.error("", "归属项目不存在，请核验！");
        }
        /**批量处理wbs节点*/
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(payload.getProjectId());
        if (ObjectUtils.isEmpty(pmsProjectVO)) {
            throw TwException.error("", "关联项目不存在，请核验！");
        }

        List<PmsProjectWbsPayload> wbsPayloads = payload.getWbsPayloads();

        List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsDAO.queryByProjectId(payload.getProjectId());

        if (payload.getIsTempCreate() || payload.getIsImportCreate()) {
            //模板创建和导入全删
            if (!ObjectUtils.isEmpty(pmsProjectWbsVOS)) {
                List<Long> collect = pmsProjectWbsVOS.stream().map(PmsProjectWbsVO::getId).collect(Collectors.toList());
                payload.setDelWbsIds(collect);
            }
        }
        //删除和工期变更的wbs，处理排期用
        List<Long> updateAllIds = new ArrayList<>();
        //判断依赖关系中的wbs节点工期数据是否非法
        List<Long> checkDurationIds = new ArrayList<>();
        //数据操作验证
//        checkOperate(payload, pmsProjectWbsVOS, pmsProjectVO);
        //要保存的日志数据
        List<ComLogPayload> logPayloads = new ArrayList<>();
        //先处理删除的节点
        if (!ObjectUtils.isEmpty(payload.getDelWbsIds())) {
            updateAllIds.addAll(payload.getDelWbsIds());

            List<PmsProjectWbsVO> collect = pmsProjectWbsVOS.stream().filter(wbsVO -> payload.getDelWbsIds().contains(wbsVO.getId())).collect(Collectors.toList());
            //核验删除数据（挂载任务的活动不能删除）
            //  checkDelWbsDatas(collect);
            //创建删除日志
            createWbsDelLog(logPayloads, collect);
            //删除操作
            deleteSoft(payload.getDelWbsIds());
            pmsProjectWbsVOS.removeAll(collect);
        }
        if (!ObjectUtils.isEmpty(payload.getWbsPayloads())) {
            String lastFourDigits = String.format("%04d", System.currentTimeMillis() % 10000);
            wbsPayloads.forEach(wbsPayload -> {
                // 版本校验
                checkData(wbsPayload);
                if (ObjectUtils.isEmpty(wbsPayload.getWbsStatus())) {
                    // 元素节点去掉状态字段
                    if (ProjectWbsTypeEnum.WBS.getCode().equals(wbsPayload.getWbsType())) {
                        wbsPayload.setWbsStatus(null);
                    }
                    if (ProjectWbsTypeEnum.MS.getCode().equals(wbsPayload.getWbsType())) {
                        wbsPayload.setWbsStatus(ProjectWbsStatusEnum.UN_FINISHED.getCode());
                    }
                    if (ProjectWbsTypeEnum.ACT.getCode().equals(wbsPayload.getWbsType())) {
                        wbsPayload.setWbsStatus(ProjectWbsStatusEnum.NOSTART.getCode());
                    }
                }
                //权重设计需要
                if (!StringUtils.hasText(wbsPayload.getParentWbsCode())) {
                    wbsPayload.setParentWbsCode("");
                }
                wbsPayload.setProjectId(payload.getProjectId());
                if (wbsPayload.getId() == null) {

//                    Long res = pmsProjectWbsDAO.queryBykeyAndVersion(wbsPayload.getProjectId(), wbsPayload.getWbsCode(), wbsPayload.getWbsName(), 0);
//                    if (null != res) {
//                        wbsPayload.setEffRelateId(res);
//                    }
                    // 发号器
//                    String code = generateSeqNum(GenerateSeqNumConstants.WBS_CODE);
//                    wbsPayload.setWbsCode(code);

                    Random random = new Random();
                    int s = random.nextInt(99) % (90) + 10;
//                    wbsPayload.setNodeCode(pmsProjectVO.getProjectCode() + "-" + wbsPayload.getWbsType() + "-" + (lastFourDigits + s));
                    wbsPayload.setAutoScheduling(0);
                    wbsPayload.setIsKeyNode(0);
                } else {
                    //说明是变更，需判断是否影响排期和关键路径
                    Optional<PmsProjectWbsVO> vo1 = pmsProjectWbsVOS.stream().filter(vo -> vo.getId().equals(wbsPayload.getId())).findFirst();
                    if (vo1.isPresent()) {
                        BigDecimal preDurationDayPayload = wbsPayload.getPreDurationDay();
                        BigDecimal preDurationDayVO = vo1.get().getPreDurationDay();
                        if (!ObjectUtils.isEmpty(preDurationDayVO)) {
                            if (ObjectUtils.isEmpty(preDurationDayPayload)) {
                                updateAllIds.add(wbsPayload.getId());
                                checkDurationIds.add(wbsPayload.getId());
                            } else {
                                if (preDurationDayPayload.compareTo(preDurationDayVO) != 0) {
                                    updateAllIds.add(wbsPayload.getId());
                                }
                            }
                        }
                    }
                }
                if (StringUtils.hasText(wbsPayload.getParentWbsCode())) {
                    Optional<PmsProjectWbsPayload> payload1 = wbsPayloads.stream().filter(load -> load.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
                    if (payload1.isPresent()) {
                        wbsPayload.setParentWbsName(payload1.get().getWbsName());
                    } else {
                        Optional<PmsProjectWbsVO> vo1 = pmsProjectWbsVOS.stream().filter(vo -> vo.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
                        if (vo1.isPresent()) {
                            wbsPayload.setParentWbsName(vo1.get().getWbsName());
                        }
                    }
                }
            });

            // 设置权重
//            setWbsWeight(wbsPayloads, pmsProjectWbsVOS);

            //更新或者保存节点 数据
            List<PmsProjectWbsDO> entityDos = wbsPayloads.stream().map(e -> {
                PmsProjectWbsDO wbsDO = PmsProjectWbsConvert.INSTANCE.toDo(e);
                wbsDO.setState("0");
                e.setWbsDO(wbsDO);
                return wbsDO;
            }).collect(Collectors.toList());
            List<PmsProjectWbsDO> pmsProjectWbsDOS = pmsProjectWbsDAO.saveAll(entityDos);
            Map<String, PmsProjectWbsDO> collectMap = pmsProjectWbsDOS.stream().collect(Collectors.toMap(PmsProjectWbsDO::getWbsCode, Function.identity(), (t1, t2) -> t1));
            if (!ObjectUtils.isEmpty(payload.getWbsPayloads())) {
                wbsPayloads.forEach(wbsPayload -> {
                    // 对分配资源进行处理
                    List<PmsProjectWbsResourcePayload> pmsProjectWbsResourcePayloadList = wbsPayload.getPmsProjectWbsResourcePayloadList();
                    if (null != wbsPayload.getId()) {
                        pmsProjectWbsResourceDao.delByWbsIds(List.of(wbsPayload.getId()));
                    }
                    if (CollUtil.isNotEmpty(wbsPayload.getPmsProjectWbsResourcePayloadList())) {
                        // 设置wbsId
                        pmsProjectWbsResourcePayloadList.stream().forEach(x -> {
                            x.setWbsId(collectMap.get(wbsPayload.getWbsCode()).getId());
                            x.setProjectId(payload.getProjectId());
                            x.setVersionId(collectMap.get(wbsPayload.getWbsCode()).getVersionId());
                            x.setVersionNo(collectMap.get(wbsPayload.getWbsCode()).getVersionNo());
                            x.setWbsCode(collectMap.get(wbsPayload.getWbsCode()).getWbsCode());
                        });
                        pmsProjectWbsResourceService.saveAll(pmsProjectWbsResourcePayloadList);
                    }

                    // 对前置依赖进行处理
                    List<PmsProjectWbsRelyDataPayload> pmsProjectWbsRelyDataPayloadList = wbsPayload.getPmsProjectWbsRelyDataPayloadList();
                    if (null != wbsPayload.getId()) {
                        pmsProjectWbsRelyService.delByWbsId(wbsPayload.getId(), wbsPayload.getVersionNo());
                    }
                    if (CollUtil.isNotEmpty(pmsProjectWbsRelyDataPayloadList)) {
                        // 先对前置依赖进行删除
                        pmsProjectWbsRelyService.delByWbsId(collectMap.get(wbsPayload.getWbsCode()).getId(), collectMap.get(wbsPayload.getWbsCode()).getVersionNo());
                        pmsProjectWbsRelyDataPayloadList.stream().forEach(x -> {
                            Set<Long> addWbsRelyIds = new HashSet<>();
                            if (!ObjectUtils.isEmpty(x.getAddWbsRelyIds())) {
                                addWbsRelyIds.addAll(x.getAddWbsRelyIds());
                            }
                            if (!ObjectUtils.isEmpty(x.getAddWbsRelyCodes())) {
                                List<PmsProjectWbsDO> collect = x.getAddWbsRelyCodes().stream().map(collectMap::get)
                                        .filter(Objects::nonNull) // 过滤掉null值
                                        .collect(Collectors.toList());
                                addWbsRelyIds.addAll(collect.stream().map(PmsProjectWbsDO::getId).collect(Collectors.toList()));
                            }
                            x.setAddWbsRelyIds(new ArrayList<>(addWbsRelyIds));
                            x.setWbsId(collectMap.get(wbsPayload.getWbsCode()).getId());
                            x.setVersionId(collectMap.get(wbsPayload.getWbsCode()).getVersionId());
                            x.setVersionNo(collectMap.get(wbsPayload.getWbsCode()).getVersionNo());
                            x.setVersionNo(collectMap.get(wbsPayload.getWbsCode()).getVersionNo());
                            x.setWbsCode(collectMap.get(wbsPayload.getWbsCode()).getWbsCode());
                            pmsProjectWbsRelyService.batchInsert(x);
                        });

                    }

                });

            }

            //获取变更的节点
            List<PmsProjectWbsPayload> updatePayloads = wbsPayloads.stream().filter(wbsPayload -> wbsPayload.getId() != null).collect(Collectors.toList());
            //获取变更日志
            List<Long> updateIds = createWbsUpdateLog(logPayloads, pmsProjectWbsVOS, updatePayloads);

            //获取新增的节点
            List<PmsProjectWbsPayload> addPayloads = new ArrayList<>();
            wbsPayloads.forEach(wbsPayload -> {
                wbsPayload.setId(wbsPayload.getWbsDO().getId());
                if (!updateIds.contains(wbsPayload.getId())) {
                    addPayloads.add(wbsPayload);
                }
            });
            //处理日历
            operProjectCalendar(payload);
            //获取创建日志
            createWbsAddLog(logPayloads, addPayloads);
            //处理wbs活动成本预估和交付物
            List<PmsProjectWbsPayload> act = wbsPayloads.stream().filter(wbsPayload -> wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode())).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(act)) {
                //核验名称是否重复
                List<PmsWbsActCostVO> pmsWbsActCostVOS = pmsWbsActCostDAO.queryByProjectId(payload.getProjectId());
                List<PmsWbsActPayVO> pmsWbsActPayVOS = pmsWbsActPayDAO.queryByProjectId(payload.getProjectId());
                //要删除的活动成本预估
                List<Long> delActCostIds = new ArrayList<>();
                //要删除的活动交付物
                List<Long> delActPayIds = new ArrayList<>();
                for (PmsProjectWbsPayload wbsPayload : act) {


                    if (!ObjectUtils.isEmpty(wbsPayload.getDelActCostIds())) {
                        delActCostIds.addAll(wbsPayload.getDelActCostIds());
                    }
                    if (!ObjectUtils.isEmpty(wbsPayload.getDelActPayIds())) {
                        delActPayIds.addAll(wbsPayload.getDelActPayIds());
                    }
                    if (!ObjectUtils.isEmpty(wbsPayload.getDelActCostIds()) || !ObjectUtils.isEmpty(wbsPayload.getActCostPayloads())) {
                        //操作成本估计日志
                        operActCostLog(logPayloads, wbsPayload, pmsWbsActCostVOS);
                    }
                    if (!ObjectUtils.isEmpty(wbsPayload.getDelActPayIds()) || !ObjectUtils.isEmpty(wbsPayload.getActPayPayloads())) {
                        //操作交付物日志
                        operActPayLog(logPayloads, wbsPayload, pmsWbsActPayVOS);
                    }
                }
                //删除活动成本预估
                if (delActCostIds.size() > 0) {
                    pmsWbsActCostDAO.deleteSoft(delActCostIds);
                    pmsWbsActCostVOS = pmsWbsActCostVOS.stream().filter(costVO -> !delActCostIds.contains(costVO.getId())).collect(Collectors.toList());
                }
                //删除活动交付物
                if (delActPayIds.size() > 0) {
                    pmsWbsActPayDAO.deleteSoft(delActPayIds);
                    pmsWbsActPayVOS = pmsWbsActPayVOS.stream().filter(payVO -> !delActPayIds.contains(payVO.getId())).collect(Collectors.toList());
                }
                //要保存的活动成本预估
                List<PmsWbsActCostPayload> actCostPayloads = new ArrayList<>();
                //要保存的活动交付物
                List<PmsWbsActPayPayload> actPayPayloads = new ArrayList<>();
                // 核验活动下成本估算和交付物数据
                checkWbsAct(act, pmsProjectWbsDOS, actCostPayloads, actPayPayloads, payload.getProjectId(), pmsWbsActCostVOS, pmsWbsActPayVOS);

                //保存的活动成本预估
                if (actCostPayloads.size() > 0) {
                    List<PmsWbsActCostDO> pmsWbsActCostDOS = PmsWbsActCostConvert.INSTANCE.toDoList(actCostPayloads);
                    pmsWbsActCostDAO.saveAll(pmsWbsActCostDOS);
                }
                //保存的活动交付物
                if (actPayPayloads.size() > 0) {
                    List<PmsWbsActPayDO> pmsWbsActPayDOS = PmsWbsActPayConvert.INSTANCE.toDoList(actPayPayloads);
                    pmsWbsActPayDAO.saveAll(pmsWbsActPayDOS);
                }
            }
        }
        //保存操作日志
        if (logPayloads.size() > 0) {
            //版本数据处理
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setChangeContent("项目wbs变更");
            changePayload.setChangeDocId(payload.getProjectId() + "");
            changePayload.setChangeType(ComChangeTypeEnum.PMS_PROJECT_WBS.getCode());
            changePayload.setCreator(GlobalUtil.getLoginUserName());
            ComChangeVO insert = changeService.insert(changePayload);
            String vid = payload.getProjectId() + "-" + insert.getVersionNo();
            logPayloads.forEach(log -> log.setExtString1(vid));
            logService.insertBacth(logPayloads);
        }
        //处理排期
        if (updateAllIds.size() > 0) {
            List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS = pmsProjectWbsRelyDAO.queryByWbsIds(updateAllIds);
            if (!ObjectUtils.isEmpty(pmsProjectWbsRelyVOS)) {
                List<PmsProjectWbsRelyVO> collect = pmsProjectWbsRelyVOS.stream().filter(relyVO -> checkDurationIds.contains(relyVO.getWbsId()) || checkDurationIds.contains(relyVO.getWbsRelyId())).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty(collect)) {
                    throw TwException.error("", "存在依赖关系的wbs节点工期不可为空，请核验！");
                }
                //说明节点关系变动影响到排期，需更改排期状态
                updateSchedulingStatus(payload.getProjectId());
            }
        }
        return null;
    }

    private void checkData(PmsProjectWbsPayload wbsPayload) {
        if (ObjectUtils.isEmpty(wbsPayload.getVersionId())) {
            throw new BusinessException("版本id不能为空");
        }
        if (ObjectUtils.isEmpty(wbsPayload.getVersionNo())) {
            throw new BusinessException("版本号不能为空");
        }

    }


    /**
     * 处理工作日历
     */
    void operProjectCalendar(PmsProjectWbsDataPayload projectWbsDataPayload) {
        //删除日历
        if (!ObjectUtils.isEmpty(projectWbsDataPayload.getDelWbsIds())) {
            calendarService.deleteSoftBySource(projectWbsDataPayload.getDelWbsIds(), ProjectWbsTypeEnum.WBS.getCode());
        }
        //新增或编辑
        List<PmsProjectWbsPayload> wbsPayloads = projectWbsDataPayload.getWbsPayloads();
        if (!ObjectUtils.isEmpty(wbsPayloads)) {
            List<PmsProjectCalendarPayload> pmsProjectCalendarPayloads = new ArrayList<>();
            wbsPayloads.forEach(wbsPayload -> {
                PmsProjectCalendarPayload pmsProjectCalendarPayload = wbsPayload.getPmsProjectCalendarPayload();
                if (!ObjectUtils.isEmpty(pmsProjectCalendarPayload)) {
                    pmsProjectCalendarPayload.setSourceId(wbsPayload.getId());
                    pmsProjectCalendarPayload.setSourceType(ProjectWbsTypeEnum.WBS.getCode());
                    pmsProjectCalendarPayloads.add(pmsProjectCalendarPayload);
                }
            });
            calendarService.batchSave(pmsProjectCalendarPayloads);
        }
    }

    /**
     * 操作成本估计日志
     *
     * @param logPayloads
     * @param wbsPayload
     * @param pmsWbsActCostVOS
     */
    void operActCostLog(List<ComLogPayload> logPayloads, PmsProjectWbsPayload wbsPayload, List<PmsWbsActCostVO> pmsWbsActCostVOS) {
        Optional<ComLogPayload> first = logPayloads.stream().filter(log -> log.getObjectId().equals(wbsPayload.getId() + "")).findFirst();
        StringBuilder builder = new StringBuilder();
        ComLogPayload logPayload = new ComLogPayload();
        if (first.isPresent()) {
            logPayload = first.get();
            builder.append(logPayload.getLogContent());
        } else {
            // logPayload.setExtString1(vid);
            logPayload.setObjectId(wbsPayload.getId() + "");
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setExtString2(wbsPayload.getWbsType());
            logPayload.setExtString3("UPDATE");
            logPayloads.add(logPayload);
        }
        builder.append("\n");
        builder.append("成本估计:");
        builder.append("\n");
        //删除的成本估计
        List<String> dels = new ArrayList<>();
        if (!ObjectUtils.isEmpty(wbsPayload.getDelActCostIds())) {
            dels = pmsWbsActCostVOS.stream().filter(wbsVO -> wbsPayload.getDelActCostIds().contains(wbsVO.getId())).map(PmsWbsActCostVO::getCostName).collect(Collectors.toList());
        }
        if (dels.size() > 0) {
            builder.append("删除");
            for (int i = 0; i < dels.size(); i++) {
                if (i == 0) {
                    builder.append("【" + dels.get(i) + "】");
                } else {
                    builder.append(",【" + dels.get(i) + "】");
                }
            }
        }

        List<PmsWbsActCostPayload> actCostPayloads = wbsPayload.getActCostPayloads();
        //新加的成本估计
        List<PmsWbsActCostPayload> adds = new ArrayList<>();
        //变更的成本估计
        List<PmsWbsActCostPayload> updates = new ArrayList<>();
        if (!ObjectUtils.isEmpty(actCostPayloads)) {
            adds = actCostPayloads.stream().filter(actCost -> actCost.getId() == null).collect(Collectors.toList());
            updates = actCostPayloads.stream().filter(actCost -> actCost.getId() != null).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty(adds)) {
            builder.append("成本要素-成本估计 创建为");
            builder.append("\n");
            for (PmsWbsActCostPayload add : adds) {
                builder.append(add.getCostName() + "-" + add.getCostEstimate());
                builder.append("\n");
            }
        }
        if (!ObjectUtils.isEmpty(updates)) {
            builder.append("成本要素-成本估计");
            builder.append("\n");
            for (PmsWbsActCostPayload up : updates) {
                Optional<PmsWbsActCostVO> firstCost = pmsWbsActCostVOS.stream().filter(actCost -> actCost.getId().equals(up.getId())).findFirst();
                if (firstCost.isPresent()) {
                    PmsWbsActCostVO pmsWbsActCostVO = firstCost.get();
                    if (!pmsWbsActCostVO.getCostName().equals(up.getCostName()) || !pmsWbsActCostVO.getCostEstimate().equals(up.getCostEstimate())) {
                        String str = pmsWbsActCostVO.getCostName() + "-" + pmsWbsActCostVO.getCostEstimate() + "更新为" + up.getCostName() + "-" + up.getCostEstimate();
                        builder.append(str);
                        builder.append("\n");
                    }
                }
            }
        }
        logPayload.setLogContent(builder.toString());

    }

    /**
     * 交付物操作
     *
     * @param logPayloads
     * @param wbsPayload
     * @param pmsWbsActPayVOS
     */
    void operActPayLog(List<ComLogPayload> logPayloads, PmsProjectWbsPayload wbsPayload, List<PmsWbsActPayVO> pmsWbsActPayVOS) {
        Optional<ComLogPayload> first = logPayloads.stream().filter(log -> log.getObjectId().equals(wbsPayload.getId() + "")).findFirst();
        StringBuilder builder = new StringBuilder();
        ComLogPayload logPayload = new ComLogPayload();
        if (first.isPresent()) {
            logPayload = first.get();
            builder.append(logPayload.getLogContent());
        } else {
            // logPayload.setExtString1(vid);
            logPayload.setObjectId(wbsPayload.getId() + "");
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setExtString2(wbsPayload.getWbsType());
            logPayload.setExtString3("UPDATE");
            logPayloads.add(logPayload);
        }
        builder.append("\n");
        builder.append("交付物:");
        builder.append("\n");
        //删除的成本估计
        List<String> dels = new ArrayList<>();
        if (!ObjectUtils.isEmpty(wbsPayload.getDelActPayIds())) {
            dels = pmsWbsActPayVOS.stream().filter(wbsVO -> wbsPayload.getDelActPayIds().contains(wbsVO.getId())).map(PmsWbsActPayVO::getPayName).collect(Collectors.toList());
        }
        if (dels.size() > 0) {
            builder.append("删除");
            for (int i = 0; i < dels.size(); i++) {
                if (i == 0) {
                    builder.append("【" + dels.get(i) + "】");
                } else {
                    builder.append(",【" + dels.get(i) + "】");
                }
            }
        }

        List<PmsWbsActPayPayload> actPayPayloads = wbsPayload.getActPayPayloads();
        //新加的成本估计
        List<PmsWbsActPayPayload> adds = new ArrayList<>();
        //变更的成本估计
        List<PmsWbsActPayPayload> updates = new ArrayList<>();
        if (!ObjectUtils.isEmpty(actPayPayloads)) {
            adds = actPayPayloads.stream().filter(actPay -> actPay.getId() == null).collect(Collectors.toList());
            updates = actPayPayloads.stream().filter(actPay -> actPay.getId() != null).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty(adds)) {
            builder.append("交付物名称-交付物类型 创建为");
            builder.append("\n");
            for (PmsWbsActPayPayload add : adds) {
                builder.append(add.getPayName() + "-" + add.getPayTypeName());
                builder.append("\n");
            }
        }
        if (!ObjectUtils.isEmpty(updates)) {
            builder.append("交付物名称-交付物类型");
            builder.append("\n");
            for (PmsWbsActPayPayload up : updates) {
                Optional<PmsWbsActPayVO> firstPay = pmsWbsActPayVOS.stream().filter(actPay -> actPay.getId().equals(up.getId())).findFirst();
                if (firstPay.isPresent()) {
                    PmsWbsActPayVO pmsWbsActPayVO = firstPay.get();
                    if (!pmsWbsActPayVO.getPayName().equals(up.getPayName()) || !pmsWbsActPayVO.getPayTypeName().equals(up.getPayTypeName())) {
                        String str = pmsWbsActPayVO.getPayName() + "-" + pmsWbsActPayVO.getPayTypeName() + "更新为" + up.getPayName() + "-" + up.getPayTypeName();
                        builder.append(str);
                        builder.append("\n");
                    }
                }
            }
        }
        logPayload.setLogContent(builder.toString());

    }

    /**
     * 创建新加日志
     *
     * @param logPayloads
     * @param wbsPayloads
     */
    void createWbsAddLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsPayload> wbsPayloads) {
        if (!ObjectUtils.isEmpty(wbsPayloads)) {
            wbsPayloads.forEach(wbsPayload -> {
                String fieldsCreateLog = changeFieldUtil.getFieldsCreateLog(wbsPayload, null);
                ComLogPayload logPayload = new ComLogPayload();
                //  logPayload.setExtString1(vid);
                logPayload.setObjectId(wbsPayload.getId() + "");
                logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());

                logPayload.setExtString2(wbsPayload.getWbsType());
                logPayload.setExtString3("CREATE");
                logPayload.setLogContent(fieldsCreateLog);
                logPayloads.add(logPayload);
            });
        }
    }

    /**
     * 创建wbs节点变更日志
     *
     * @param logPayloads
     * @param wbsPayloads
     */
    List<Long> createWbsUpdateLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsVO> wbsVOS, List<PmsProjectWbsPayload> wbsPayloads) {
        List<Long> ids = new ArrayList<>();
        if (!ObjectUtils.isEmpty(wbsPayloads)) {
            wbsPayloads.forEach(wbsPayload -> {
                ids.add(wbsPayload.getId());
                if (!ObjectUtils.isEmpty(wbsVOS)) {
                    Optional<PmsProjectWbsVO> first = wbsVOS.stream().filter(wbsVO -> wbsVO.getId().equals(wbsPayload.getId())).findFirst();
                    if (first.isPresent()) {
                        PmsProjectWbsVO pmsProjectWbsVO = first.get();
                        PmsProjectWbsPayload pmsProjectWbsPayload = PmsProjectWbsConvert.INSTANCE.toPayload(pmsProjectWbsVO);
                        transferData(pmsProjectWbsPayload);
                        String fieldsUpdateLog = changeFieldUtil.getFieldsUpdateLog(wbsPayload, pmsProjectWbsPayload);
                        if (StringUtils.hasText(fieldsUpdateLog)) {
                            //    fieldsUpdateLog = "【" + wbsPayload.getWbsName() + "】:/n" + fieldsUpdateLog;
                            ComLogPayload logPayload = new ComLogPayload();
                            // logPayload.setExtString1(vid);
                            logPayload.setObjectId(wbsPayload.getId() + "");
                            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());

                            logPayload.setExtString2(wbsPayload.getWbsType());
                            logPayload.setExtString3("UPDATE");
                            logPayload.setLogContent(fieldsUpdateLog);
                            logPayloads.add(logPayload);
                        }
                    }
                }
            });
        }
        return ids;
    }

    /**
     * 创建删除wbs节点日志
     *
     * @param logPayloads
     * @param collect
     */
    void createWbsDelLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsVO> collect) {
        collect.forEach(wbsVO -> {
            ComLogPayload logPayload = new ComLogPayload();
            // logPayload.setExtString1(vid);
            logPayload.setObjectId(wbsVO.getId() + "");
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setLogContent("节点【" + wbsVO.getWbsName() + "】被删除");
            logPayload.setExtString2(wbsVO.getWbsType());
            logPayload.setExtString3("DEL");
            logPayloads.add(logPayload);
        });

    }

    @Override
    @Transactional
    public List<PmsProjectWbsVO> queryList(PmsProjectWbsQuery query) {
        if (ObjectUtils.isEmpty(query.getProjectId())) {
            throw TwException.error("", "归属项目不可为空，请核验！");
        }
        if (null == query.getVersionNo()) {
            query.setVersionNo(0);
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsDAO.queryListDynamic(query);
        pmsProjectWbsVOS.forEach(pmsProjectWbsVO -> transferData(pmsProjectWbsVO, null));
        pmsProjectWbsVOS.sort(Comparator.comparing(PmsProjectWbsVO::getWbsCode));
        // 计算节点的进度和状态
        countProgressAndStatus(pmsProjectWbsVOS);
        // 给活动节点 添加有没有任务标志
        List<Long> actIds = pmsProjectWbsVOS.stream().filter(v -> ProjectWbsTypeEnum.ACT.getCode().equals(v.getWbsType())).map(v -> v.getId()).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(actIds)) {
            List<PmsWbsTaskVO> taskVOS = getPmsWbsTaskService().findByWbsIds(actIds);
            if (!ObjectUtils.isEmpty(taskVOS)) {
                List<Long> hasTask = taskVOS.stream().map(v -> v.getWbsId()).collect(Collectors.toList());
                pmsProjectWbsVOS.stream()
                        .filter(v -> ProjectWbsTypeEnum.ACT.getCode().equals(v.getWbsType()) && hasTask.contains(v.getId()))
                        .forEach(v -> v.setHasTaskFlag(true));
            }
        }


        if(!CollectionUtils.isEmpty(pmsProjectWbsVOS)){
            List<Long> idList = pmsProjectWbsVOS.stream().map(v -> v.getId()).collect(Collectors.toList());
            // 查询分配资源
            PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
            pmsProjectWbsResourceQuery.setWbsIdList(idList);
            List<PmsProjectWbsResourceVO> resourceList = pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
            Map<Long, List<PmsProjectWbsResourceVO>> resourceMap = new HashMap<>();
            if(!CollectionUtils.isEmpty(resourceList)){
                resourceMap  = resourceList.stream().collect(Collectors.groupingBy(PmsProjectWbsResourceVO::getWbsId));
            }
            // 查询前置依赖
            PmsProjectWbsRelyQuery pmsProjectWbsRelyQuery = new PmsProjectWbsRelyQuery();
            pmsProjectWbsRelyQuery.setWbsIdList(idList);
            List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS = pmsProjectWbsRelyService.queryListDynamic(pmsProjectWbsRelyQuery);
            Map<Long, List<PmsProjectWbsRelyVO>> wbsRelyMap = new HashMap<>();
            if(!CollectionUtils.isEmpty(pmsProjectWbsRelyVOS)){
                wbsRelyMap  = pmsProjectWbsRelyVOS.stream().collect(Collectors.groupingBy(PmsProjectWbsRelyVO::getWbsId));
            }

            for (PmsProjectWbsVO pmsProjectWbsVO : pmsProjectWbsVOS) {
                // 分配资源
                if(resourceMap.containsKey(pmsProjectWbsVO.getId())){
                    pmsProjectWbsVO.setPmsProjectWbsResourceVOList(resourceMap.get(pmsProjectWbsVO.getId()));
                }
                // 前置依赖
                if(wbsRelyMap.containsKey(pmsProjectWbsVO.getId())){
                    pmsProjectWbsVO.setPmsProjectWbsRelyVOList(wbsRelyMap.get(pmsProjectWbsVO.getId()));
                }

                // // 进度汇总
                // BigDecimal wbsProgress = taskProService.summaryWbs(pmsProjectWbsVO.getId(), pmsProjectWbsVO.getWbsType());
                // pmsProjectWbsVO.setWbsProgress(wbsProgress);
            }
        }


        //2.2 若里程碑的验收项为空，那么到预计完成日期后，自动更为“已完成”并记录“实际完成”；
//        pmsProjectWbsVOS.stream()
//                .filter(pmsProjectWbsVO ->
//                        (StringUtils.hasText(pmsProjectWbsVO.getWbsType()) && pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode()))
//                                && (StringUtils.hasText(pmsProjectWbsVO.getState()) && "1".equals(pmsProjectWbsVO.getState()))
//                )
//                .forEach(pmsProjectWbsVO -> {
//                    updateMsWbsStatusByWbsAccept(pmsProjectWbsVO);
//                });
        return pmsProjectWbsVOS;
    }

    @Override
    public List<PmsProjectWbsVO> queryListSimple(PmsProjectWbsQuery query) {
        if (ObjectUtils.isEmpty(query.getProjectId())) {
            throw TwException.error("", "归属项目不可为空，请核验！");
        }
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(query.getProjectId());
        if (ObjectUtils.isEmpty(pmsProjectVO)) {
            throw TwException.error("", "关联项目不存在，请核验！");
        }
        if (null == query.getVersionNo()) {
            query.setVersionNo(0);
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsDAO.queryListDynamic(query);
        pmsProjectWbsVOS.forEach(pmsProjectWbsVO -> transferData(pmsProjectWbsVO, null));
        pmsProjectWbsVOS.sort(Comparator.comparing(PmsProjectWbsVO::getWbsCode));

        // 收款计划相关字段赋值
        addPlanData(pmsProjectVO.getContractId(), pmsProjectWbsVOS);
        // 翻译
        transferDataList(pmsProjectWbsVOS, null);
        // // 计算节点的进度和状态
        // countProgressAndStatus(pmsProjectWbsVOS);
        // // 给活动节点 添加有没有任务标志
        // List<Long> actIds = pmsProjectWbsVOS.stream().filter(v -> ProjectWbsTypeEnum.ACT.getCode().equals(v.getWbsType())).map(v -> v.getId()).collect(Collectors.toList());
        // if (!ObjectUtils.isEmpty(actIds)) {
        //     List<PmsWbsTaskVO> taskVOS = getPmsWbsTaskService().findByWbsIds(actIds);
        //     if (!ObjectUtils.isEmpty(taskVOS)) {
        //         List<Long> hasTask = taskVOS.stream().map(v -> v.getWbsId()).collect(Collectors.toList());
        //         pmsProjectWbsVOS.stream()
        //             .filter(v -> ProjectWbsTypeEnum.ACT.getCode().equals(v.getWbsType()) && hasTask.contains(v.getId()))
        //             .forEach(v -> v.setHasTaskFlag(true));
        //     }
        // }
        //
        // for (PmsProjectWbsVO pmsProjectWbsVO : pmsProjectWbsVOS) {
        //     // 查询分配资源
        //     PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
        //     pmsProjectWbsResourceQuery.setWbsId(pmsProjectWbsVO.getId());
        //     List<PmsProjectWbsResourceVO> list = pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
        //     pmsProjectWbsVO.setPmsProjectWbsResourceVOList(list);
        //
        //     // 查询前置依赖
        //     PmsProjectWbsRelyQuery pmsProjectWbsRelyQuery = new PmsProjectWbsRelyQuery();
        //     pmsProjectWbsRelyQuery.setWbsId(pmsProjectWbsVO.getId());
        //     List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS = pmsProjectWbsRelyService.queryListDynamic(pmsProjectWbsRelyQuery);
        //     pmsProjectWbsVO.setPmsProjectWbsRelyVOList(pmsProjectWbsRelyVOS);
        //
        //     // 进度汇总
        //     BigDecimal wbsProgress = taskProService.summaryWbs(pmsProjectWbsVO.getId(), pmsProjectWbsVO.getWbsType());
        //     pmsProjectWbsVO.setWbsProgress(wbsProgress);
        // }


        return pmsProjectWbsVOS;
    }

    void addPlanData(Long contractId, List<PmsProjectWbsVO> activityVOS) {
        if (!ObjectUtils.isEmpty(contractId)) {
            List<ConReceivablePlanVO> planVOList = conReceivablePlanService.queryBySaleConId(contractId);
            if (!ObjectUtils.isEmpty(planVOList)) {
                // 作废的收款阶段不需要关联阶段活动
                planVOList = planVOList.stream().filter(v -> !ObjectUtils.isEmpty(v.getReceStatus()) && !"INVALID".equals(v.getReceStatus())).collect(Collectors.toList());
            }
            if (!ObjectUtils.isEmpty(planVOList)) {
                Map<Long, ConReceivablePlanVO> planInfo = planVOList.stream().collect(Collectors.toMap(ConReceivablePlanVO::getId, Function.identity()));
                activityVOS.forEach(v -> {
                    if (!ObjectUtils.isEmpty(v.getReceivePlanId())) {
                        ConReceivablePlanVO planVO = planInfo.get(v.getReceivePlanId());
                        if (!ObjectUtils.isEmpty(planVO)) {
                            v.setReceivePlanDesc(planVO.getReceStage());
                            v.setReceRatio(planVO.getReceRatio());
                            v.setReceAmt(planVO.getReceAmt());
                            v.setReceStatus(planVO.getReceStatus());
                            v.setExpectReceDate(planVO.getExpectReceDate());
                            // 判断收款的预计收款日期在不在阶段的起止日期内
                            if (v.getExpectReceDate() != null
                                    && null != v.getStartDate()
                                    && null != v.getEndDate()
                                    && v.getExpectReceDate().isAfter(v.getStartDate()) && v.getExpectReceDate().isBefore(v.getEndDate())) {
                                v.setExpectReceDateFlag(1);
                            } else {
                                v.setExpectReceDateFlag(0);
                            }
                        }
                    }
                });
            }
        }
    }

    /**
     * 通过wbs-accept更新ms-wbs状态
     *
     * @param pmsProjectWbsVO 永磁同步电机项目wbs-vo
     */
    private void updateMsWbsStatusByWbsAccept(PmsProjectWbsVO pmsProjectWbsVO) {
        if (StringUtils.hasText(pmsProjectWbsVO.getWbsStatus()) && pmsProjectWbsVO.getWbsStatus().equals(ProjectWbsStatusEnum.CANCEL.getCode())) {
            return;
        }
        PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery = new PmsProjectWbsAcceptQuery();
        pmsProjectWbsAcceptQuery.setWbsId(pmsProjectWbsVO.getId());
        Long count = pmsProjectWbsAcceptDao.count(pmsProjectWbsAcceptQuery);
        // 预计结束时间
        LocalDate pmsProjectWbsVOEndDate = pmsProjectWbsVO.getPreEndDate();
        if (null != pmsProjectWbsVOEndDate) {
            //2.2 若里程碑的验收项为空，那么到预计完成日期后，自动更为“已完成”并记录“实际完成”；
            if (count < 1) {
                LocalDate now = LocalDate.now();
                if (now.isAfter(pmsProjectWbsVOEndDate)) {
                    PmsProjectWbsPayload updatePayload = new PmsProjectWbsPayload();
                    updatePayload.setId(pmsProjectWbsVO.getId());
                    updatePayload.setWbsStatus(ProjectWbsStatusEnum.FINISHED.getCode());
                    updatePayload.setEndDate(now);
                    if (pmsProjectWbsVO.getVersionNo().equals(0)) {
                        // updatePayload.setState("1");
                    }
                    pmsProjectWbsDAO.updateByKeyNoVersion(updatePayload);

                    pmsProjectWbsVO.setWbsStatus(ProjectWbsStatusEnum.FINISHED.getCode());
                    // pmsProjectWbsVO.setState("1");
                    pmsProjectWbsVO.setEndDate(now);
                } else {
                    PmsProjectWbsPayload updatePayload = new PmsProjectWbsPayload();
                    updatePayload.setId(pmsProjectWbsVO.getId());
                    updatePayload.setWbsStatus(ProjectWbsStatusEnum.UN_FINISHED.getCode());
                    updatePayload.setEndDateIsNull(now);
                    if (pmsProjectWbsVO.getVersionNo().equals(0)) {
                        // updatePayload.setState("1");
                    }
                    pmsProjectWbsDAO.updateByKeyNoVersion(updatePayload);

                    pmsProjectWbsVO.setWbsStatus(ProjectWbsStatusEnum.UN_FINISHED.getCode());
                    if (pmsProjectWbsVO.getVersionNo().equals(0)) {
                        // pmsProjectWbsVO.setState("1");
                    }
                    pmsProjectWbsVO.setEndDate(null);
                }
            }
        }
    }

    @Override
    public List<PmsProjectWbsVO> queryListByIds(List<Long> keys) {
        return pmsProjectWbsDAO.queryListByIds(keys);
    }


    @Override
    @Transactional
    public PmsProjectWbsVO queryByKey(Long key) {
        PmsProjectWbsVO pmsProjectWbsVO = pmsProjectWbsDAO.queryByKey(key);
        //处理预计持续时间
        // operDurationDay(pmsProjectWbsVO);
        transferData(pmsProjectWbsVO, null);
        // 获取节点进度
//        Map<String, Object> info = progressAndStatusCache.get(key);
//        if (!ObjectUtils.isEmpty(info)) {
//            Object wbsProgress = info.get("wbsProgress");
//            if (!ObjectUtils.isEmpty(wbsProgress)) {
//                pmsProjectWbsVO.setWbsProgress((BigDecimal) wbsProgress);
//            }
//            pmsProjectWbsVO.setWbsStatus(!ObjectUtils.isEmpty(info.get("wbsStatus")) ? info.get("wbsStatus").toString() : null);
//        }
        // 分配资源
        PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
        pmsProjectWbsResourceQuery.setWbsId(key);
        List<PmsProjectWbsResourceVO> resourceVOList = pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
        pmsProjectWbsVO.setPmsProjectWbsResourceVOList(resourceVOList);
        // 前置依赖
        PmsProjectWbsRelyQuery pmsProjectWbsRelyQuery = new PmsProjectWbsRelyQuery();
        pmsProjectWbsRelyQuery.setWbsId(key);
        List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS = pmsProjectWbsRelyService.queryListDynamic(pmsProjectWbsRelyQuery);
        pmsProjectWbsVO.setPmsProjectWbsRelyVOList(pmsProjectWbsRelyVOS);
        // // 进度汇总
        // BigDecimal wbsProgress = taskProService.summaryWbs(pmsProjectWbsVO.getId(), pmsProjectWbsVO.getWbsType());
        // pmsProjectWbsVO.setWbsProgress(wbsProgress);

        // 通过交付物情况 动态修改 wbs状态
        if (StringUtils.hasText(pmsProjectWbsVO.getWbsType()) && pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
            updateMsWbsStatusByWbsAccept(pmsProjectWbsVO);
        }
        return pmsProjectWbsVO;
    }

    /**
     * 处理预计持续时间
     *
     * @param pmsProjectWbsVO
     */
    void operDurationDay(PmsProjectWbsVO pmsProjectWbsVO) {
        if (pmsProjectWbsVO.getPreStartDate() != null && pmsProjectWbsVO.getPreEndDate() != null) {
            PmsProjectCalendarPayload payload = new PmsProjectCalendarPayload();
            payload.setSourceId(pmsProjectWbsVO.getId());
            payload.setSourceType(ProjectWbsTypeEnum.WBS.getCode());
            payload.setStartDate(pmsProjectWbsVO.getPreStartDate());
            payload.setEndDate(pmsProjectWbsVO.getPreEndDate());
            PmsProjectCalendarVO bySource = calendarService.findBySource(payload);
            pmsProjectWbsVO.setPreDurationDay(BigDecimal.valueOf(bySource.getDurationDays()));
        }


    }

    /**
     * 翻译数据
     *
     * @param vo
     */
    void transferData(PmsProjectWbsVO vo, Map<Long, String> planInfo) {
        vo.setCostTypeName(cacheUtil.transferSystemSelection("PMS:WBS:COST:TYPE", vo.getCostType()));
        vo.setCreator(cacheUtil.getUserName(vo.getCreateUserId()));
        vo.setManagerUserName(cacheUtil.getUserName(vo.getManagerUserId()));
        if (vo.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
            vo.setWbsStatusName(cacheUtil.transferSystemSelection("PMS:WBS:MS:STATUS", vo.getWbsStatus()));
        } else {
            vo.setWbsStatusName(cacheUtil.transferSystemSelection("PMS:PROJECT:WBS:STATUS", vo.getWbsStatus()));
        }

        if (!ObjectUtils.isEmpty(vo.getAllocateStatus())) {
            vo.setAllocateStatusDesc(cacheUtil.transferSystemSelection("PMS:ACTIVITY:ALLOCATESTATUS", vo.getAllocateStatus()));
        }
        if (!ObjectUtils.isEmpty(vo.getReceStatus())) {
            vo.setReceStatusDesc(cacheUtil.transferSystemSelection("salecon:payment_status", vo.getReceStatus()));
        }
        if (!ObjectUtils.isEmpty(planInfo)) {
            if (!ObjectUtils.isEmpty(vo.getReceivePlanId())) {
                vo.setReceivePlanDesc(planInfo.get(vo.getReceivePlanId()));
            }
        }

    }

    void transferDataList(List<PmsProjectWbsVO> list, Map<Long, String> planInfo) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(x -> {
            transferData(x, planInfo);
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            //删除wbs活动下预算
            List<PmsProjectWbsVO> list = pmsProjectWbsDAO.queryByKeys(keys);
            for (PmsProjectWbsVO wbsVO : list) {
                // 里程碑
                if (ProjectWbsTypeEnum.MS.getCode().equals(wbsVO.getWbsType())) {
                    if (ProjectWbsStatusEnum.FINISHED.getCode().equals(wbsVO.getWbsStatus())) {
                        throw TwException.error("", wbsVO.getWbsName() + "状态已达成，不可被删除");
                    }
                }
            }
            List<Long> effIds = list.stream().filter(x -> null != x.getEffRelateId()).map(x -> x.getEffRelateId()).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(effIds)) {
                pmsProjectWbsDAO.delByEffIds(effIds);
            }

            budgetDetailService.deleteSoftByWbsIds(keys);
            //删除wbs活动下任务
            getPmsWbsTaskService().deleteSoftByWbsIds(keys);

            //删除wbs
            pmsProjectWbsDAO.deleteSoft(keys);
            //删除依赖关系
            pmsProjectWbsRelyDAO.deleteSoftByWbsIds(keys);
            //删除wbs活动下成本预算
            pmsWbsActCostDAO.deleteSoftByWbsIds(keys);
            //删除wbs活动下交付物
            pmsWbsActPayDAO.deleteSoftByWbsIds(keys);
            //删除分配资源
            pmsProjectWbsResourceDao.delByWbsIds(keys);
            //删除验收标准
            pmsProjectWbsAcceptDao.delByWbsId(keys);

            //处理排期
            List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS = pmsProjectWbsRelyDAO.queryByWbsIds(keys);
            if (!ObjectUtils.isEmpty(pmsProjectWbsRelyVOS)) {
                Long projectId = list.get(0).getProjectId();
                //说明节点关系变动影响到排期，需更改排期状态
                updateSchedulingStatus(projectId);
            }

            // 权重重新更新
            Long projectId = list.get(0).getProjectId();
            List<String> parentWbsCodes = list.stream().filter(v -> v.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) || v.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode())).map(v -> v.getParentWbsCode()).collect(Collectors.toList());
            for (String parentWbsCode : parentWbsCodes) {
                list = pmsProjectWbsDAO.queryByParentWbsCode(projectId, parentWbsCode);
                list = list.stream().filter(wbsPayload -> wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) || wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode())).collect(Collectors.toList());
                // 算出已经手动设置过值得节点 总权重
                BigDecimal weights = list.stream().filter(v -> 1 == v.getManualSettingWeight() && !keys.contains(v.getId())).map(PmsProjectWbsVO::getWbsWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                list = list.stream().filter(v -> 0 == v.getManualSettingWeight() && !keys.contains(v.getId())).collect(Collectors.toList());
                updateWbsWeight(list, weights);
            }
        }
    }

    @Override
    public List<ComLogVO> queryLogList(PmsProjectWbsLogQuery query) {
        if ((query.getProjectId() != null && query.getVersionNo() != null) || query.getWbsId() != null) {
            ComLogQuery logQuery = new ComLogQuery();
            logQuery.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logQuery.setLogContent(query.getLogContent());
            if (query.getProjectId() != null && query.getVersionNo() != null) {
                String vid = query.getProjectId() + "-" + query.getVersionNo();
                logQuery.setExtString1(vid);
            } else {
                logQuery.setObjectId(query.getWbsId() + "");
            }
            if (StringUtils.hasText(query.getOperType())) {
                logQuery.setExtString3(query.getOperType());
            }
            if (StringUtils.hasText(query.getWbsType())) {
                logQuery.setExtString2(query.getWbsType());
            }
//            List<ComLogVO> comLogVOS = logService.queryList(logQuery);
//            comLogVOS.forEach(comLogVO -> {
//                String extString3 = comLogVO.getExtString3();
//                if (StringUtils.hasText(extString3)) {
//                    extString3 = extString3.equals("DEL") ? "删除" : extString3.equals("UPDATE") ? "更新" : "创建";
//                }
//                comLogVO.setExtString3(extString3);
//            });
            return logService.queryList(logQuery);
        } else {
            throw TwException.error("", "查询参数异常，请核验！");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectWbsSnapshotVO insertSnapshot(PmsProjectWbsSnapshotPayload payload) {
        if (ObjectUtils.isEmpty(payload.getProjectId())) {
            throw TwException.error("", "归属项目不存在，请核验！");
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsDAO.querySimpleByProjectId(payload.getProjectId());
        if (ObjectUtils.isEmpty(pmsProjectWbsVOS)) {
            throw TwException.error("", "基线数据不存在，请核验！");
        }
        String originalContent = JSONObject.toJSONString(pmsProjectWbsVOS);
        payload.setSnapContent(originalContent);
        PmsProjectWbsSnapshotVO insert = planSnapshotService.insert(payload);

        return insert;
    }

    @Override
    public List<PmsProjectWbsSnapshotVO> querySnapshotList(PmsProjectWbsSnapshotQuery query) {
        List<PmsProjectWbsSnapshotVO> pmsProjectWbsSnapshotVOS = planSnapshotService.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(pmsProjectWbsSnapshotVOS)) {
            pmsProjectWbsSnapshotVOS.forEach(snapshotVO -> {
                List<PmsProjectWbsSimpleVO> pmsProjectPlanVOS = JSON.parseObject(snapshotVO.getSnapContent(), List.class);
                snapshotVO.setProjectWbsSimpleVOS(pmsProjectPlanVOS);
            });
        }
        return pmsProjectWbsSnapshotVOS;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftSnapshot(List<Long> snapshotKeys) {
        planSnapshotService.deleteSoft(snapshotKeys);
    }

    @Override
    public List<PmsProjectWbsVO> queryStakeholdersList(PmsProjectWbsQuery query) {
        List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsDAO.queryListDynamic(query);

        return pmsProjectWbsVOS;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteManagerUserIds(Long projectId, List<Long> managerUserIds) {
        pmsProjectWbsDAO.upadateManagerUserId(projectId, managerUserIds, null);
    }

    @Override
    public void updateWbsProgress(Long wbsId, BigDecimal wbsProgress, String wbsStatus) {
        // 根据任务进度 更改 节点进度
        pmsProjectWbsDAO.updateWbsProgress(wbsId, wbsProgress, wbsStatus);

        // 根据节点 进度 更改 父节点进度
        PmsProjectWbsVO vo = pmsProjectWbsDAO.queryByKey(wbsId);
        updateParentWbsProgress(vo.getProjectId(), vo.getParentWbsCode());

        // 将更新节点 时间  更新到项目记录中去
//        pmsProjectDAO.updateWbsProgressUpdateTime(vo.getProjectId());
    }

    @Override
    public BigDecimal getProjectProgress(Long projectId) {
        List<PmsProjectWbsVO> list = pmsProjectWbsDAO.queryParentWbsCodeIsNull(projectId);
        list.forEach(pmsProjectWbsVO -> {
            // 获取节点进度
            Map<String, Object> info = progressAndStatusCache.get(pmsProjectWbsVO.getId());
            if (!ObjectUtils.isEmpty(info)) {
                Object wbsProgress = info.get("wbsProgress");
                if (!ObjectUtils.isEmpty(wbsProgress)) {
                    pmsProjectWbsVO.setWbsProgress((BigDecimal) wbsProgress);
                }
            }
        });
        return countWbsProgress(list);
    }

    /**
     * 更改父节点 进度
     *
     * @param projectId
     * @param parentWbsCode
     */
    public void updateParentWbsProgress(Long projectId, String parentWbsCode) {
        // 如果当前节点有父节点 还要计算父节点的进度,父节点 进度为其下节点进度的加权平均
        if (!ObjectUtils.isEmpty(parentWbsCode)) {
            List<PmsProjectWbsVO> list = getSetWbs(projectId, Arrays.asList(parentWbsCode));
            //计算 节点进度
            BigDecimal wbsProgress = countWbsProgress(list);
            PmsProjectWbsVO wbsVO = pmsProjectWbsDAO.queryByProjectAndWbs(projectId, parentWbsCode);
            if (!ObjectUtils.isEmpty(wbsVO)) {
                pmsProjectWbsDAO.updateWbsProgress(wbsVO.getId(), wbsProgress);
                updateParentWbsProgress(projectId, wbsVO.getParentWbsCode());
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void autoScheduling(PmsProjectWbsSchedulingPayload payload) {
        List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsDAO.queryByProjectIdAndVersion(payload.getProjectId(), payload.getVersionNo());
        List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS = pmsProjectWbsRelyDAO.queryByProjectIdAndVersionNo(payload.getProjectId(), payload.getVersionNo());
        //修改节点关键路径状态
        pmsProjectWbsDAO.updateKeyNodeAndVersionNo(payload.getProjectId(), payload.getVersionNo());
        //初始化计算数据
        AutoScheduling autoScheduling = new AutoScheduling(pmsProjectWbsVOS, pmsProjectWbsRelyVOS, payload.getStartDate(), calendarService, payload.getProjectId());
        //开始计算
        List<PmsProjectWbsVO> newVos = autoScheduling.startScheduling();
        List<PmsProjectWbsDO> pmsProjectWbsDOS = PmsProjectWbsConvert.INSTANCE.toDos(newVos);
        pmsProjectWbsDAO.saveAll(pmsProjectWbsDOS);
    }

    @Override
    public void updateSchedulingStatus(Long projectId) {
        pmsProjectWbsDAO.updateScheduling(projectId);
    }

    @Override
    @Transactional
    public List<PmsProjectWbsVO> listMilestone(PmsProjectWbsQuery query) {
        if (ObjectUtils.isEmpty(query.getProjectId())) {
            throw TwException.error("500", "归属项目不可为空，请核验！");
        }
        if (!StringUtils.hasText(query.getWbsType())) {
            query.setWbsType(ProjectWbsTypeEnum.MS.getCode());
        }
        // 默认查激活状态
        // if (!StringUtils.hasText(query.getState())) {
        //     query.setState("1");
        // }
        if (ObjectUtils.isEmpty(query.getVersionNo())) {
            query.setVersionNo(0);
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsDAO.queryListDynamic(query);
        // !!!重要
        if (CollectionUtils.isEmpty(pmsProjectWbsVOS)) {
            return pmsProjectWbsVOS;
        }
        pmsProjectWbsVOS.forEach(pmsProjectWbsVO -> transferData(pmsProjectWbsVO, null));

        // 是否有验收标准
        List<Long> wbsIds = pmsProjectWbsVOS.stream().map(x -> x.getId()).collect(Collectors.toList());
        PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery = new PmsProjectWbsAcceptQuery();
        pmsProjectWbsAcceptQuery.setWbsIdList(wbsIds);
        List<PmsProjectWbsAcceptVO> list = pmsProjectWbsAcceptService.getList(pmsProjectWbsAcceptQuery);
        Map<Long, Long> collectMap = list.stream().collect(Collectors.toMap(PmsProjectWbsAcceptVO::getWbsId, PmsProjectWbsAcceptVO::getProjectId, (t1, t2) -> t1));

        pmsProjectWbsVOS.forEach(x -> x.setHasAcceptFlag(collectMap.get(x.getId()) == null ? false : true));
        pmsProjectWbsVOS.forEach(x -> {
            // 查询分配资源
            PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
            pmsProjectWbsResourceQuery.setWbsId(x.getId());
            List<PmsProjectWbsResourceVO> list1 = pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
            x.setPmsProjectWbsResourceVOList(list1);
        });
        //2.2 若里程碑的验收项为空，那么到预计完成日期后，自动更为“已完成”并记录“实际完成”；
        pmsProjectWbsVOS.stream()
                .filter(pmsProjectWbsVO ->
                        (StringUtils.hasText(pmsProjectWbsVO.getWbsType()) && pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode()))
                                && (StringUtils.hasText(pmsProjectWbsVO.getState()) && "1".equals(pmsProjectWbsVO.getState()))
                )
                .forEach(pmsProjectWbsVO -> {
                    updateMsWbsStatusByWbsAccept(pmsProjectWbsVO);
                });
        pmsProjectWbsVOS.sort(Comparator.comparing(PmsProjectWbsVO::getWbsCode));
        return pmsProjectWbsVOS;
    }


    @Override
    public List<PmsProjectWbsVO> listStage(PmsProjectWbsQuery query) {
        Long projectId = query.getProjectId();
        if (ObjectUtils.isEmpty(projectId)) {
            throw TwException.error("500", "归属项目不可为空，请核验！");
        }
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(projectId);
        Assert.notNull(pmsProjectVO, "项目不存在");
        if (!StringUtils.hasText(query.getWbsType())) {
            query.setWbsType(ProjectWbsTypeEnum.ACTG.getCode());
        }
        // 默认查激活状态
        // if (!StringUtils.hasText(query.getState())) {
        //     query.setState("1");
        // }
        if (ObjectUtils.isEmpty(query.getVersionNo())) {
            query.setVersionNo(0);
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsDAO.queryListDynamic(query);
        // !!!重要
        if (CollectionUtils.isEmpty(pmsProjectWbsVOS)) {
            return pmsProjectWbsVOS;
        }
        setActgPreDateByAct(pmsProjectWbsVOS, true);
        Long contractId = pmsProjectVO.getContractId();
        // 收款计划
        Map<Long, String> conReceivablePlanMap = listConReceivablePlanVO(contractId);
        pmsProjectWbsVOS.forEach(pmsProjectWbsVO -> transferData(pmsProjectWbsVO, conReceivablePlanMap));
        pmsProjectWbsVOS.sort(Comparator.comparing(PmsProjectWbsVO::getWbsCode));
        return pmsProjectWbsVOS;
    }

    /**
     * 通过活动的预计开始结束时间赋值阶段预计开始结束日期
     *
     * @param pmsProjectWbsVOS   wbsvos
     * @param calculateCostsFlag 是否计算成本
     */
    @Override
    public void setActgPreDateByAct(List<PmsProjectWbsVO> pmsProjectWbsVOS, boolean calculateCostsFlag) {
        pmsProjectWbsVOS.forEach(pmsProjectWbsVO -> {
            // 根据阶段下 活动的预计开始时间、结束时间 计算阶段的时间
            if (StringUtils.hasText(pmsProjectWbsVO.getWbsType())
                    && pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.ACTG.getCode())) {
                PmsProjectWbsQuery pmsProjectWbsQuery = new PmsProjectWbsQuery();
                pmsProjectWbsQuery.setParentWbsCode(pmsProjectWbsVO.getWbsCode());
                pmsProjectWbsQuery.setVersionNo(pmsProjectWbsVO.getVersionNo());
                pmsProjectWbsQuery.setWbsType(ProjectWbsTypeEnum.ACT.getCode());
                pmsProjectWbsQuery.setProjectId(pmsProjectWbsVO.getProjectId());
                List<PmsProjectWbsVO> pmsProjectWbsChildList = pmsProjectWbsDAO.queryListDynamic(pmsProjectWbsQuery);
                if (!CollectionUtils.isEmpty(pmsProjectWbsChildList)) {
                    // 校验时间
                    pmsProjectWbsChildList.forEach(pmsProjectWbsChild -> {
                        if (ObjectUtils.isEmpty(pmsProjectWbsChild.getPreStartDate()) || ObjectUtils.isEmpty(pmsProjectWbsChild.getPreEndDate())) {
                            throw TwException.error("500", "wbs计划下活动预计开始时间或结束时间不可为空，请核验！");
                        }
                    });

                    // pmsProjectWbsChildList 选择最早预计开始时间 和最晚结束时间 做为阶段pmsProjectWbsVO的预计开始时间和结束时间
                    pmsProjectWbsChildList.sort(Comparator.comparing(PmsProjectWbsVO::getPreStartDate));
                    pmsProjectWbsVO.setPreStartDate(pmsProjectWbsChildList.get(0).getPreStartDate());
                    pmsProjectWbsChildList.sort(Comparator.comparing(PmsProjectWbsVO::getPreEndDate));
                    pmsProjectWbsVO.setPreEndDate(pmsProjectWbsChildList.get(pmsProjectWbsChildList.size() - 1).getPreEndDate());

                    if (calculateCostsFlag) {
                        // 汇总阶段下各活动的预计成本  活动的预计成本 = 各资源的（预计工期 *投入精力 *当量系数）之和
                        Long versionId = pmsProjectWbsVO.getVersionId();
                        BigDecimal sumResCost = BigDecimal.ZERO;
                        for (PmsProjectWbsVO projectWbsVO : pmsProjectWbsChildList) {
                            BigDecimal resCostSum = getResCostSum(projectWbsVO, versionId);
                            sumResCost = sumResCost.add(resCostSum);
                        }
                        pmsProjectWbsVO.setResCostSum(sumResCost);
                    }
                }
            }
        });
    }

    /**
     * 获取PmsWbsBudgetDetailsPayload对象
     *
     * @param wbs       WBS对象
     * @param versionId 版本ID
     * @return PmsWbsBudgetDetailsPayload对象
     */
    private BigDecimal getResCostSum(PmsProjectWbsVO wbs, Long versionId) {
        if (wbs == null) {
            throw new IllegalArgumentException("wbs cannot be null");
        }
        // 预计工期
        BigDecimal preDurationDay = wbs.getPreDurationDay() == null ? BigDecimal.ZERO : wbs.getPreDurationDay();
        // 查询分配资源
        PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
        Long wbsId = wbs.getId();
        pmsProjectWbsResourceQuery.setWbsId(wbsId);
        pmsProjectWbsResourceQuery.setVersionId(versionId);
        List<PmsProjectWbsResourceVO> wbsResourceVOS = pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
        //资源成本= sum(预计工期*投入精力*当量系数)
        BigDecimal resCostSum = calculateResourceCost(wbsResourceVOS, preDurationDay);
        return resCostSum;
    }

    /**
     * 计算资源成本
     *
     * @param wbsResourceVOS wbs资源vos
     * @param preDurationDay 会前一天
     * @return {@link BigDecimal}
     */
    private BigDecimal calculateResourceCost(List<PmsProjectWbsResourceVO> wbsResourceVOS, BigDecimal preDurationDay) {
        BigDecimal resCostSum = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(wbsResourceVOS)) {
            for (PmsProjectWbsResourceVO wbsResourceVO : wbsResourceVOS) {
                Long relatePartiesId = wbsResourceVO.getRelatePartiesId();
                ProRelatedPartiesVO proRelatedPartiesVO = proRelatedPartiesService.get(relatePartiesId);
//                Assert.notNull(proRelatedPartiesVO, "相关方不存在");
                if (null != proRelatedPartiesVO) {
                    // 当量系数
                    BigDecimal eqvaRatio = proRelatedPartiesVO.getEqvaRatio() == null ? BigDecimal.ZERO : proRelatedPartiesVO.getEqvaRatio();
                    // 投入精力
                    BigDecimal input = wbsResourceVO.getInput() == null ? BigDecimal.ZERO : wbsResourceVO.getInput();
                    // 资源成本
                    BigDecimal resCost = preDurationDay.multiply(input).multiply(eqvaRatio).divide(new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    resCostSum = resCostSum.add(resCost);
                }

            }
        }
        return resCostSum;
    }

//    @Override
//    public Boolean submit(List<Long> wbsId) {
//
//        List<PmsProjectWbsVO> pmsProjectWbsVOList = this.submitVer(wbsId);
//
//        // 生成下一版本数据（异步）
//        if (CollUtil.isNotEmpty(pmsProjectWbsVOList)) {
//            createNextVersion(pmsProjectWbsVOList);
//        }
//        return true;
//    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public List<PmsProjectWbsVO> submitVer(List<Long> wbsId) {

        pmsProjectWbsDAO.submit(wbsId);
        // 版本处理
        List<PmsProjectWbsVO> pmsProjectWbsVOS = changeVersion(wbsId);

        if (CollUtil.isNotEmpty(pmsProjectWbsVOS)) {
            this.createNextVersion(pmsProjectWbsVOS);
        }
        return pmsProjectWbsVOS;

    }


    /**
     * 变更 Wbs版本
     *
     * @param wbsId
     */
    @Transactional
    public List<PmsProjectWbsVO> changeVersion2(List<Long> wbsId) {

        List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsDAO.queryListByIds(wbsId);
        if (CollUtil.isNotEmpty(pmsProjectWbsVOS)) {

            // 1.变更版本表为激活状态
            PmsProjectWbsVO pmsProjectWbsVO1 = pmsProjectWbsVOS.get(0);
            Long versionId = pmsProjectWbsVO1.getVersionId();
            if (null != versionId) {
                PmsWbsVersionPayload pmsWbsVersionPayload = new PmsWbsVersionPayload();
                pmsWbsVersionPayload.setId(versionId);
                pmsWbsVersionPayload.setState(3);
                pmsWbsVersionService.updateDynamic(pmsWbsVersionPayload);

            }

            // 2.copy版本数据
            for (PmsProjectWbsVO pmsProjectWbsVO : pmsProjectWbsVOS) {
                // 查询V0版本数据
                Long res = pmsProjectWbsDAO.queryBykeyAndVersion(pmsProjectWbsVO.getProjectId(), pmsProjectWbsVO.getWbsCode(), 0);
                if (null == res) {
                    // .若没有V0则新增
                    PmsProjectWbsDO pmsProjectWbsDO = PmsProjectWbsConvert.INSTANCE.toEntity(pmsProjectWbsVO);
                    pmsProjectWbsDO.setId(null);
                    pmsProjectWbsDO.setVersionNo(0);
                    pmsProjectWbsDO.setEffRelateId(res);
                    pmsProjectWbsDO.setVersionId(0L);
                    PmsProjectWbsDO wbsSaveV0DO = pmsProjectWbsDAO.save(pmsProjectWbsDO);

                    // 更新本版本vRelateId数据
                    PmsProjectWbsPayload payloadSelf = PmsProjectWbsConvert.INSTANCE.toPayload(pmsProjectWbsVO);
                    payloadSelf.setEffRelateId(wbsSaveV0DO.getId());
                    pmsProjectWbsDAO.updateByKeyNoVersion(payloadSelf);
                    pmsProjectWbsVO.setEffRelateId(wbsSaveV0DO.getId());


                    // 子表
//                    // 依赖关系
//                    PmsProjectWbsRelyQuery pmsProjectWbsRelyQuery = new PmsProjectWbsRelyQuery();
//                    pmsProjectWbsRelyQuery.setWbsId(pmsProjectWbsVO.getId());
//                    pmsProjectWbsRelyQuery.setVersionId(pmsProjectWbsVO.getVersionId());
//                    List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS = pmsProjectWbsRelyService.queryListDynamic(pmsProjectWbsRelyQuery);
//                    List<PmsProjectWbsRelyDO> pmsProjectWbsRelyDOList = new ArrayList<>();
//                    for (PmsProjectWbsRelyVO pmsProjectWbsRelyVO : pmsProjectWbsRelyVOS) {
//                        PmsProjectWbsRelyDO entity = PmsProjectWbsRelyConvert.INSTANCE.toEntity(pmsProjectWbsRelyVO);
//                        entity.setId(null);
//                        entity.setVersionNo(0);
//                        entity.setVersionId(0L);
//                        entity.setWbsId(wbsSaveV0DO.getId());
//                        pmsProjectWbsRelyDOList.add(entity);
//
//                    }
//                    pmsProjectWbsRelyDAO.saveAll(pmsProjectWbsRelyDOList);
//
//                    // 分配资源
//                    PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
//                    pmsProjectWbsResourceQuery.setWbsId(pmsProjectWbsVO.getId());
//                    pmsProjectWbsResourceQuery.setVersionId(pmsProjectWbsVO.getVersionId());
//
//                    List<PmsProjectWbsResourceVO> pmsProjectWbsResourceServiceList = pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
//                    List<PmsProjectWbsResourceDO> pmsProjectWbsResourceDOList = new ArrayList<>();
//                    for (PmsProjectWbsResourceVO pmsProjectWbsResourceVO : pmsProjectWbsResourceServiceList) {
//                        PmsProjectWbsResourceDO entity = PmsProjectWbsResourceConvert.INSTANCE.toEntity(pmsProjectWbsResourceVO);
//                        entity.setId(null);
//                        entity.setWbsId(wbsSaveV0DO.getId());
//                        entity.setVersionNo(0);
//                        entity.setVersionId(0L);
//                        pmsProjectWbsResourceDOList.add(entity);
//
//                    }
//                    List<PmsProjectWbsResourceDO> resourceV0DOList = pmsProjectWbsResourceRepo.saveAll(pmsProjectWbsResourceDOList);
//                    Map<Long, Long> resourceMap = resourceV0DOList.stream().collect(Collectors.toMap(PmsProjectWbsResourceDO::getRelatePartiesId, PmsProjectWbsResourceDO::getId));
//                    // 更新 vr数据
//                    for (PmsProjectWbsResourceVO pmsProjectWbsResourceVO : pmsProjectWbsResourceServiceList) {
//                        PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload = PmsProjectWbsResourceConvert.INSTANCE.toPayload(pmsProjectWbsResourceVO);
//                        pmsProjectWbsResourcePayload.setEffRelateId(resourceMap.get(pmsProjectWbsResourcePayload.getRelatePartiesId()));
//                        pmsProjectWbsResourceDao.updateByKeyNoVersion(pmsProjectWbsResourcePayload);
//                    }
//
//                    // 验收标准
//                    PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery = new PmsProjectWbsAcceptQuery();
//                    pmsProjectWbsAcceptQuery.setWbsId(pmsProjectWbsVO.getId());
//                    pmsProjectWbsAcceptQuery.setVersionId(pmsProjectWbsVO.getVersionId());
//                    List<PmsProjectWbsAcceptVO> pmsProjectWbsAcceptServiceList = pmsProjectWbsAcceptService.getList(pmsProjectWbsAcceptQuery);
//                    List<PmsProjectWbsAcceptDO> pmsProjectWbsAcceptDOList = new ArrayList<>();
//                    for (PmsProjectWbsAcceptVO pmsProjectWbsAcceptVO : pmsProjectWbsAcceptServiceList) {
//                        PmsProjectWbsAcceptDO entity = PmsProjectWbsAcceptConvert.INSTANCE.toEntity(pmsProjectWbsAcceptVO);
//                        entity.setId(null);
//                        entity.setWbsId(wbsSaveV0DO.getId());
//                        entity.setVersionNo(0);
//                        entity.setVersionId(0L);
//                        pmsProjectWbsAcceptDOList.add(entity);
//                    }
//                    pmsProjectWbsAcceptDao.save(pmsProjectWbsAcceptDOList);

                } else {
                    // copy最新数据到 V0
                    PmsProjectWbsPayload pmsProjectWbsPayload = PmsProjectWbsConvert.INSTANCE.toPayload(pmsProjectWbsVO);
                    pmsProjectWbsPayload.setId(res);
                    pmsProjectWbsDAO.updateByKeyNoVersion(pmsProjectWbsPayload);


//                    // 子表
//                    // 依赖关系 todo
//
//
//                    // 分配资源 todo
//                    PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
//                    pmsProjectWbsResourceQuery.setWbsId(pmsProjectWbsVO.getId());
//                    List<PmsProjectWbsResourceVO> pmsProjectWbsResourceVOList = pmsProjectWbsResourceDao.getList(pmsProjectWbsResourceQuery);
//                    for (PmsProjectWbsResourceVO pmsProjectWbsResourceVO : pmsProjectWbsResourceVOList) {
//                        // 查找V0数据，copy最新数据到V0
//                        Long sourceV0Id = pmsProjectWbsResourceDao.queryBykeyAndVersion(pmsProjectWbsVO.getId(), pmsProjectWbsResourceVO.getRelatePartiesId(), 0);
//                        if (sourceV0Id != null) {
//                            PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload = PmsProjectWbsResourceConvert.INSTANCE.toPayload(pmsProjectWbsResourceVO);
//                            pmsProjectWbsResourcePayload.setId(sourceV0Id);
//                            pmsProjectWbsResourceDao.updateByKeyNoVersion(pmsProjectWbsResourcePayload);
//
//                        }
//
//                    }


                    // 验收标准 todo


                }

            }

            // 生成下一版本数据（异步）
//            createNextVersion(pmsProjectWbsVO1, pmsProjectWbsVOS);
        }
        return pmsProjectWbsVOS;

    }


    @Transactional
    public List<PmsProjectWbsVO> changeVersion(List<Long> wbsId) {

        List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsDAO.queryListByIds(wbsId);
        if (CollUtil.isNotEmpty(pmsProjectWbsVOS)) {

            // 1.变更版本表为激活状态
            PmsProjectWbsVO pmsProjectWbsVO1 = pmsProjectWbsVOS.get(0);
            Long versionId = pmsProjectWbsVO1.getVersionId();
            if (null != versionId) {
                PmsWbsVersionPayload pmsWbsVersionPayload = new PmsWbsVersionPayload();
                pmsWbsVersionPayload.setId(versionId);
                pmsWbsVersionPayload.setState(3);
                pmsWbsVersionService.updateDynamic(pmsWbsVersionPayload);
            }
            // 如果是首次 ,V0->V1
            if (pmsProjectWbsVO1.getVersionNo() == 0) {

                // 3.生成一个版本+1的数据
                PmsWbsVersionVO versionVO = createWbsVersion(pmsProjectWbsVO1, 3);
                // 循环V0数据
                for (PmsProjectWbsVO pmsProjectWbsVO : pmsProjectWbsVOS) {
                    // 生成V1数据
                    PmsProjectWbsDO pmsProjectWbsDO = PmsProjectWbsConvert.INSTANCE.toEntity(pmsProjectWbsVO);
                    pmsProjectWbsDO.setId(null);
                    pmsProjectWbsDO.setVersionNo(versionVO.getVersionNo());
                    pmsProjectWbsDO.setEffRelateId(pmsProjectWbsVO.getId());
                    pmsProjectWbsDO.setVersionId(versionVO.getId());
                    PmsProjectWbsDO wbsSaveV1DO = pmsProjectWbsDAO.save(pmsProjectWbsDO);
                    pmsProjectWbsVO.setVersionNo(versionVO.getVersionNo());
//                    pmsProjectWbsVO.setId(wbsSaveV1DO.getId());
                    pmsProjectWbsVO.setEffRelateId(pmsProjectWbsVO.getId());

                    // -------------------------------------------------明细----------------------------------------------------
                    // 分配资源
                    PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
                    pmsProjectWbsResourceQuery.setWbsId(pmsProjectWbsVO.getId());
                    List<PmsProjectWbsResourceVO> pmsProjectWbsResourceVOList = pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);

                    List<PmsProjectWbsResourceDO> pmsProjectWbsResourceDOList = new ArrayList<>();
                    // 循环分配资源V0数据
                    for (PmsProjectWbsResourceVO pmsProjectWbsResourceVO : pmsProjectWbsResourceVOList) {
                        // 生成V1明细数据
                        PmsProjectWbsResourceDO v1entity = PmsProjectWbsResourceConvert.INSTANCE.toEntity(pmsProjectWbsResourceVO);
                        v1entity.setId(null);
                        v1entity.setEffRelateId(pmsProjectWbsResourceVO.getId());
                        v1entity.setVersionId(versionVO.getId());
                        v1entity.setVersionNo(versionVO.getVersionNo());
                        v1entity.setWbsId(wbsSaveV1DO.getId());
                        pmsProjectWbsResourceDOList.add(v1entity);
                    }
                    pmsProjectWbsResourceDao.save(pmsProjectWbsResourceDOList);

                    // 验收标准
                    PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery = new PmsProjectWbsAcceptQuery();
                    pmsProjectWbsAcceptQuery.setWbsId(pmsProjectWbsVO.getId());
                    List<PmsProjectWbsAcceptVO> pmsProjectWbsAcceptVOList = pmsProjectWbsAcceptService.getList(pmsProjectWbsAcceptQuery);
                    // 循环验收标准V0数据
                    List<PmsProjectWbsAcceptDO> pmsProjectWbsAcceptDOList = new ArrayList<>();
                    for (PmsProjectWbsAcceptVO pmsProjectWbsAcceptVO : pmsProjectWbsAcceptVOList) {
                        // 生成V1明细数据
                        PmsProjectWbsAcceptDO v1entity = PmsProjectWbsAcceptConvert.INSTANCE.toEntity(pmsProjectWbsAcceptVO);
                        v1entity.setId(null);
                        v1entity.setEffRelateId(pmsProjectWbsAcceptVO.getId());
                        v1entity.setVersionId(versionVO.getId());
                        v1entity.setVersionNo(versionVO.getVersionNo());
                        v1entity.setWbsId(wbsSaveV1DO.getId());
                        pmsProjectWbsAcceptDOList.add(v1entity);
                    }
                    pmsProjectWbsAcceptDao.save(pmsProjectWbsAcceptDOList);

                    // 前置依赖
                    PmsProjectWbsRelyQuery pmsProjectWbsRelyQuery = new PmsProjectWbsRelyQuery();
                    pmsProjectWbsRelyQuery.setWbsId(pmsProjectWbsVO.getId());
                    List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS = pmsProjectWbsRelyService.queryListDynamic(pmsProjectWbsRelyQuery);
                    List<PmsProjectWbsRelyDO> pmsProjectWbsRelyDOS = new ArrayList<>();
                    for (PmsProjectWbsRelyVO pmsProjectWbsRelyVO : pmsProjectWbsRelyVOS) {
                        PmsProjectWbsRelyDO v1entity = PmsProjectWbsRelyConvert.INSTANCE.toEntity(pmsProjectWbsRelyVO);
                        v1entity.setId(null);
                        v1entity.setEffRelateId(pmsProjectWbsRelyVO.getId());
                        v1entity.setVersionId(versionVO.getId());
                        v1entity.setVersionNo(versionVO.getVersionNo());
                        v1entity.setWbsId(wbsSaveV1DO.getId());
                        // 前置依赖wbsid处理
                        PmsProjectWbsVO wbsRelyIdVO = pmsProjectWbsDAO.queryByKey(v1entity.getWbsRelyId());
                        if (null != wbsRelyIdVO) {
                            Long relyWbsId = pmsProjectWbsDAO.queryBykeyAndVersion(wbsRelyIdVO.getProjectId(), wbsRelyIdVO.getWbsCode(), v1entity.getVersionNo());
                            if (null == relyWbsId) {
                                relyWbsId = 0L;
                            }
                            v1entity.setWbsRelyId(relyWbsId);
                        }
                        pmsProjectWbsRelyDOS.add(v1entity);
                    }
                    pmsProjectWbsRelyDAO.saveAll(pmsProjectWbsRelyDOS);
                    pmsProjectWbsVO.setId(wbsSaveV1DO.getId());
                }

            } else {
                // 不是首次
                for (PmsProjectWbsVO pmsProjectWbsVO : pmsProjectWbsVOS) {
                    if (null == pmsProjectWbsVO.getEffRelateId()) {
                        // 没有V0，创建V0
                        PmsProjectWbsDO pmsProjectWbsDO = PmsProjectWbsConvert.INSTANCE.toEntity(pmsProjectWbsVO);
                        pmsProjectWbsDO.setId(null);
                        pmsProjectWbsDO.setVersionNo(0);
                        pmsProjectWbsDO.setVersionId(0L);
                        PmsProjectWbsDO wbsSaveV0DO = pmsProjectWbsDAO.save(pmsProjectWbsDO);
                        // 赋值 该版本的effId
                        PmsProjectWbsPayload pmsProjectWbsPayload = PmsProjectWbsConvert.INSTANCE.toPayload(pmsProjectWbsVO);
                        pmsProjectWbsPayload.setEffRelateId(wbsSaveV0DO.getId());
                        pmsProjectWbsDAO.updateByKeyNoVersion(pmsProjectWbsPayload);
                        pmsProjectWbsVO.setEffRelateId(wbsSaveV0DO.getId());
                    } else {
                        // 有V0则要更新
                        PmsProjectWbsPayload pmsProjectWbsPayload = PmsProjectWbsConvert.INSTANCE.toPayload(pmsProjectWbsVO);
                        pmsProjectWbsPayload.setId(pmsProjectWbsVO.getEffRelateId());
                        // 如果不是取消则不覆盖状态
                        if (org.apache.commons.lang3.StringUtils.isNotBlank(pmsProjectWbsPayload.getWbsStatus()) && !pmsProjectWbsPayload.getWbsStatus().equals(ProjectWbsStatusEnum.CANCEL.getCode())) {
                            pmsProjectWbsPayload.setWbsStatus(null);
                        }
                        pmsProjectWbsDAO.updateByKeyNoVersion(pmsProjectWbsPayload);
                    }
                    // -------------------------------------------------明细----------------------------------------------------
                    // 1.分配资源列表
                    PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
                    pmsProjectWbsResourceQuery.setWbsId(pmsProjectWbsVO.getId());
                    List<PmsProjectWbsResourceVO> pmsProjectWbsResourceVOList = pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
                    // 删除剩余的V0数据
                    List<Long> resourceDelIds = pmsProjectWbsResourceVOList.stream().filter(x -> null != x.getEffRelateId()).map(x -> x.getEffRelateId()).collect(Collectors.toList());
                    pmsProjectWbsResourceDao.delByV0(resourceDelIds, pmsProjectWbsVO.getEffRelateId());
                    for (PmsProjectWbsResourceVO pmsProjectWbsResourceVO : pmsProjectWbsResourceVOList) {
                        if (null == pmsProjectWbsResourceVO.getEffRelateId()) {
                            // 没有V0
                            PmsProjectWbsResourceDO entity = PmsProjectWbsResourceConvert.INSTANCE.toEntity(pmsProjectWbsResourceVO);
                            entity.setId(null);
                            entity.setVersionId(0L);
                            entity.setVersionNo(0);
                            Long wbsV0Id = pmsProjectWbsDAO.queryBykeyAndVersion(pmsProjectWbsResourceVO.getProjectId(), pmsProjectWbsResourceVO.getWbsCode(), 0);
                            // 查找V0版本的id赋值给wbsId
                            entity.setWbsId(wbsV0Id);
                            PmsProjectWbsResourceDO V0save = pmsProjectWbsResourceRepo.save(entity);
                            // 赋值 该版本的effId
                            PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload = PmsProjectWbsResourceConvert.INSTANCE.toPayload(pmsProjectWbsResourceVO);
                            pmsProjectWbsResourcePayload.setEffRelateId(V0save.getId());
                            pmsProjectWbsResourceDao.updateByKeyNoVersion(pmsProjectWbsResourcePayload);
                        } else {
                            // 有V0版本则要更新V0
                            PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload = PmsProjectWbsResourceConvert.INSTANCE.toPayload(pmsProjectWbsResourceVO);
                            pmsProjectWbsResourcePayload.setId(pmsProjectWbsResourceVO.getEffRelateId());
                            pmsProjectWbsResourcePayload.setWbsId(null);
                            pmsProjectWbsResourcePayload.setWbsCode(null);

                            pmsProjectWbsResourceDao.updateByKeyNoVersion(pmsProjectWbsResourcePayload);
                        }

                    }

                    // 2.前置依赖
                    PmsProjectWbsRelyQuery pmsProjectWbsRelyQuery = new PmsProjectWbsRelyQuery();
                    pmsProjectWbsRelyQuery.setWbsId(pmsProjectWbsVO.getId());
                    List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS = pmsProjectWbsRelyService.queryListDynamic(pmsProjectWbsRelyQuery);
                    // 删除剩余的V0数据
                    List<Long> relyDelIds = pmsProjectWbsRelyVOS.stream().filter(x -> null != x.getEffRelateId()).map(x -> x.getEffRelateId()).collect(Collectors.toList());
                    pmsProjectWbsRelyDAO.delByV0(relyDelIds, pmsProjectWbsVO.getEffRelateId());
                    for (PmsProjectWbsRelyVO pmsProjectWbsRelyVO : pmsProjectWbsRelyVOS) {
                        if (null == pmsProjectWbsRelyVO.getEffRelateId()) {
                            // 没有V0
                            PmsProjectWbsRelyDO entity = PmsProjectWbsRelyConvert.INSTANCE.toEntity(pmsProjectWbsRelyVO);
                            entity.setId(null);
                            entity.setVersionId(0L);
                            entity.setVersionNo(0);
                            Long wbsV0Id = pmsProjectWbsDAO.queryBykeyAndVersion(pmsProjectWbsRelyVO.getProjectId(), pmsProjectWbsRelyVO.getWbsCode(), 0);
                            // 查找V0版本的id赋值给wbsId
                            entity.setWbsId(wbsV0Id);
                            // 前置依赖wbsid处理
                            PmsProjectWbsVO wbsRelyIdVO = pmsProjectWbsDAO.queryByKey(entity.getWbsRelyId());
                            if (null != wbsRelyIdVO) {
                                Long relyWbsId = pmsProjectWbsDAO.queryBykeyAndVersion(wbsRelyIdVO.getProjectId(), wbsRelyIdVO.getWbsCode(), entity.getVersionNo());
                                if (null == relyWbsId) {
                                    relyWbsId = 00L;
                                }
                                entity.setWbsRelyId(relyWbsId);
                            }
                            PmsProjectWbsRelyDO v0Id = pmsProjectWbsRelyDAO.save(entity);
                            // 赋值 该版本的effId
                            PmsProjectWbsRelyPayload pmsProjectWbsRelyPayload = PmsProjectWbsRelyConvert.INSTANCE.toPayload(pmsProjectWbsRelyVO);
                            pmsProjectWbsRelyPayload.setEffRelateId(v0Id.getId());
                            pmsProjectWbsRelyDAO.updateByKeyDynamic(pmsProjectWbsRelyPayload);

                        } else {
                            // 更新V0
                            PmsProjectWbsRelyPayload pmsProjectWbsRelyPayload = PmsProjectWbsRelyConvert.INSTANCE.toPayload(pmsProjectWbsRelyVO);
                            pmsProjectWbsRelyPayload.setId(pmsProjectWbsRelyVO.getEffRelateId());
                            pmsProjectWbsRelyPayload.setWbsId(null);
                            // 前置依赖wbsid处理
                            if (null != pmsProjectWbsRelyPayload.getWbsRelyId()) {
                                PmsProjectWbsVO wbsRelyIdVO = pmsProjectWbsDAO.queryByKey(pmsProjectWbsRelyPayload.getWbsRelyId());
                                if (null != wbsRelyIdVO) {
                                    Long relyWbsId = pmsProjectWbsDAO.queryBykeyAndVersion(wbsRelyIdVO.getProjectId(), wbsRelyIdVO.getWbsCode(), pmsProjectWbsRelyPayload.getVersionNo());
                                    if (null == relyWbsId) {
                                        relyWbsId = 000L;
                                    }
                                    pmsProjectWbsRelyPayload.setWbsRelyId(relyWbsId);
                                }
                                pmsProjectWbsRelyPayload.setWbsCode(null);
                                pmsProjectWbsRelyDAO.updateByKeyDynamic(pmsProjectWbsRelyPayload);
                            }

                        }
                    }
                    // 3.验收标准
                    PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery = new PmsProjectWbsAcceptQuery();
                    pmsProjectWbsAcceptQuery.setWbsId(pmsProjectWbsVO.getId());
                    List<PmsProjectWbsAcceptVO> pmsProjectWbsAcceptVOList = pmsProjectWbsAcceptService.getList(pmsProjectWbsAcceptQuery);
                    // 删除剩余的V0数据
                    List<Long> acceptDelIds = pmsProjectWbsAcceptVOList.stream().filter(x -> null != x.getEffRelateId()).map(x -> x.getEffRelateId()).collect(Collectors.toList());
                    pmsProjectWbsAcceptDao.delByV0(acceptDelIds, pmsProjectWbsVO.getEffRelateId());
                    for (PmsProjectWbsAcceptVO pmsProjectWbsAcceptVO : pmsProjectWbsAcceptVOList) {
                        if (null == pmsProjectWbsAcceptVO.getEffRelateId()) {
                            // 没有V0，
                            PmsProjectWbsAcceptDO entity = PmsProjectWbsAcceptConvert.INSTANCE.toEntity(pmsProjectWbsAcceptVO);
                            entity.setId(null);
                            entity.setVersionId(0L);
                            entity.setVersionNo(0);
                            Long wbsV0Id = pmsProjectWbsDAO.queryBykeyAndVersion(pmsProjectWbsAcceptVO.getProjectId(), pmsProjectWbsAcceptVO.getWbsCode(), 0);
                            // 查找V0版本的id赋值给wbsId
                            entity.setWbsId(wbsV0Id);
                            PmsProjectWbsAcceptDO v0save = pmsProjectWbsAcceptRepo.save(entity);
                            // 赋值 该版本的effId
                            PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload = PmsProjectWbsAcceptConvert.INSTANCE.toPayload(pmsProjectWbsAcceptVO);
                            pmsProjectWbsAcceptPayload.setEffRelateId(v0save.getId());
                            pmsProjectWbsAcceptDao.update(pmsProjectWbsAcceptPayload);

                        } else {
                            // 更新V0
                            PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload = PmsProjectWbsAcceptConvert.INSTANCE.toPayload(pmsProjectWbsAcceptVO);
                            pmsProjectWbsAcceptPayload.setId(pmsProjectWbsAcceptVO.getEffRelateId());
                            pmsProjectWbsAcceptPayload.setWbsCode(null);
                            pmsProjectWbsAcceptPayload.setWbsId(null);
                            pmsProjectWbsAcceptDao.update(pmsProjectWbsAcceptPayload);
                        }
                    }

                }

            }

        }
        return pmsProjectWbsVOS;

    }

    @Override
    @Transactional
    public void createNextVersion(List<PmsProjectWbsVO> pmsProjectWbsVOS) {

        PmsProjectWbsVO pmsProjectWbsVO1 = pmsProjectWbsVOS.get(0);
        // 3.生成一个新建状态的版本+1的 版本数据
        PmsWbsVersionVO wbsVersion = createWbsVersion(pmsProjectWbsVO1, 1);
        // 生成新建状态的 Wbs主数据 关联的版本id，版本号为 ↑↑↑
        for (PmsProjectWbsVO pmsProjectWbsVO : pmsProjectWbsVOS) {
            pmsProjectWbsVO.setVersionId(wbsVersion.getId());
            pmsProjectWbsVO.setVersionNo(wbsVersion.getVersionNo());
            // wbs主表
            PmsProjectWbsDO wbsByVersion = createWbsByVersion(pmsProjectWbsVO);
            // 子表

            // 依赖关系
            createWbsRelyByVersion(pmsProjectWbsVO, wbsByVersion.getId());
            // 分配资源
            createWbsResourceByVersion(pmsProjectWbsVO, wbsByVersion.getId());
            // 验收标准
            createWbsAcceptByVersion(pmsProjectWbsVO, wbsByVersion.getId());
        }

    }

    private void createWbsRelyByVersion(PmsProjectWbsVO pmsProjectWbsVO, Long wbsId) {
        PmsProjectWbsRelyQuery pmsProjectWbsRelyQuery = new PmsProjectWbsRelyQuery();
        pmsProjectWbsRelyQuery.setWbsId(pmsProjectWbsVO.getId());

        List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS = pmsProjectWbsRelyDAO.queryListDynamic(pmsProjectWbsRelyQuery);
        List<PmsProjectWbsRelyDO> pmsProjectWbsRelyDOS = new ArrayList<>();
        for (PmsProjectWbsRelyVO pmsProjectWbsRelyVO : pmsProjectWbsRelyVOS) {
            PmsProjectWbsRelyDO entity = PmsProjectWbsRelyConvert.INSTANCE.toEntity(pmsProjectWbsRelyVO);
            entity.setId(null);
            entity.setWbsId(wbsId);
            entity.setVersionId(pmsProjectWbsVO.getVersionId());
            entity.setVersionNo(pmsProjectWbsVO.getVersionNo());
            // 前置依赖wbsid处理
            PmsProjectWbsVO wbsRelyIdVO = pmsProjectWbsDAO.queryByKey(entity.getWbsRelyId());
            if (null != wbsRelyIdVO) {
                Long relyWbsId = pmsProjectWbsDAO.queryBykeyAndVersion(wbsRelyIdVO.getProjectId(), wbsRelyIdVO.getWbsCode(), entity.getVersionNo());
                if (null == relyWbsId) {
                    relyWbsId = 0000L;
                }
                entity.setWbsRelyId(relyWbsId);
            }
            pmsProjectWbsRelyDOS.add(entity);
        }
        pmsProjectWbsRelyDAO.saveAll(pmsProjectWbsRelyDOS);

    }

    private void createWbsAcceptByVersion(PmsProjectWbsVO pmsProjectWbsVO, Long wbsId) {

        PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery = new PmsProjectWbsAcceptQuery();
        pmsProjectWbsAcceptQuery.setWbsId(pmsProjectWbsVO.getId());
        List<PmsProjectWbsAcceptVO> pmsProjectWbsAcceptVOList = pmsProjectWbsAcceptDao.getList(pmsProjectWbsAcceptQuery);

        List<PmsProjectWbsAcceptDO> pmsProjectWbsAcceptDOList = new ArrayList<>();
        for (PmsProjectWbsAcceptVO pmsProjectWbsAcceptVO : pmsProjectWbsAcceptVOList) {
            PmsProjectWbsAcceptDO entity = PmsProjectWbsAcceptConvert.INSTANCE.toEntity(pmsProjectWbsAcceptVO);
            entity.setId(null);
            entity.setWbsId(wbsId);
            entity.setVersionId(pmsProjectWbsVO.getVersionId());
            entity.setVersionNo(pmsProjectWbsVO.getVersionNo());
            pmsProjectWbsAcceptDOList.add(entity);
        }
        pmsProjectWbsAcceptDao.save(pmsProjectWbsAcceptDOList);
    }

    @Override
    @Transactional
    public List<PmsProjectWbsVO> submitVerPro(PmsProjectWbsSubmitDataPayload payload) {
        List<PmsProjectWbsPayload> wbsPayloadList = payload.getWbsPayloadList();
        //按需 修改收款计划一些信息
        batchUpdate(wbsPayloadList);

        List<PmsProjectWbsVO> pmsProjectWbsVOS = submitVer(payload.getWbsId());
        // 预算提交
//        pmsWbsBudgetDetailsService.submit(payload.getBudgetDetailsList());
        return pmsProjectWbsVOS;
    }

    @Override
    @Transactional
    public void savePro(PmsProjectWbsSubmitDataPayload payload) {
        List<PmsProjectWbsPayload> wbsPayloadList = payload.getWbsPayloadList();
        //按需 修改收款计划一些信息
        batchUpdate(wbsPayloadList);
    }

    @Override
    @Transactional
    public Long updateState(PmsProjectWbsPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        Assert.notNull(payload.getWbsStatus(), "状态不能为空");
        if (payload.getWbsStatus().equals(ProjectWbsStatusEnum.CANCEL.getCode())) {
            payload.setState("2");
            // 判断原状态是否是开始状态（活动清单-已开始）
            PmsProjectWbsVO pmsProjectWbsVO = pmsProjectWbsDAO.queryByKey(payload.getId());
            // 活动
            if (pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode())) {
                if (pmsProjectWbsVO.getWbsStatus().equals(ProjectWbsStatusEnum.NOGIONG.getCode())) {
                    payload.setCancelShowFlag(true);
                }
                // 阶段
            } else if (pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.ACTG.getCode())) {
                // 校验拨付状态
                // 拨付中和拨付成功的阶段，不可删除
                // long count = activityVOS.stream().filter(v -> ProjActivityAllocateStateEnum.ING.getType().equals(v.getAllocateStatus()) || ProjActivityAllocateStateEnum.OK.getType().equals(v.getAllocateStatus())).count();
                if (StringUtils.hasText(pmsProjectWbsVO.getAllocateStatus()) &&
                        (
                                pmsProjectWbsVO.getAllocateStatus().equals(ProjWbsAllocateStateEnum.ING.getCode())
                                        || pmsProjectWbsVO.getWbsStatus().equals(ProjWbsAllocateStateEnum.OK.getCode())
                        )
                ) {
                    throw TwException.error("", "拨付中和拨付成功的阶段，不可删除");
                }
            }

        }
        Long res = pmsProjectWbsDAO.updateWbsStatus(payload.getId(), payload.getWbsStatus(), payload.getState(), payload.getCancelShowFlag());
        return res;
    }

    public void createWbsResourceByVersion(PmsProjectWbsVO pmsProjectWbsVO, Long wbsId) {

        PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
        pmsProjectWbsResourceQuery.setWbsId(pmsProjectWbsVO.getId());

        List<PmsProjectWbsResourceVO> pmsProjectWbsResourceVOList = pmsProjectWbsResourceDao.getList(pmsProjectWbsResourceQuery);
        List<PmsProjectWbsResourceDO> pmsProjectWbsResourceDOList = new ArrayList<>();
        for (PmsProjectWbsResourceVO pmsProjectWbsResourceVO : pmsProjectWbsResourceVOList) {
            PmsProjectWbsResourceDO entity = PmsProjectWbsResourceConvert.INSTANCE.toEntity(pmsProjectWbsResourceVO);
            entity.setId(null);
            entity.setWbsId(wbsId);
            entity.setVersionId(pmsProjectWbsVO.getVersionId());
            entity.setVersionNo(pmsProjectWbsVO.getVersionNo());
            pmsProjectWbsResourceDOList.add(entity);
        }

        pmsProjectWbsResourceDao.save(pmsProjectWbsResourceDOList);

    }

    public PmsProjectWbsDO createWbsByVersion(PmsProjectWbsVO pmsProjectWbsVO) {

        PmsProjectWbsDO entity = PmsProjectWbsConvert.INSTANCE.toEntity(pmsProjectWbsVO);
        entity.setId(null);
        if (pmsProjectWbsVO.getState() != null && pmsProjectWbsVO.getState().equals("2")) {
            // 已取消的 不需要激活
        } else {
            entity.setState("1");
        }
        PmsProjectWbsDO save = pmsProjectWbsDAO.save(entity);
        return save;
    }

    /**
     * 给指定项目新建一条新建状态的指定版本号的数据
     *
     * @param pmsProjectWbsVO
     */
    public PmsWbsVersionVO createWbsVersion(PmsProjectWbsVO pmsProjectWbsVO, Integer state) {

        PmsWbsVersionPayload pmsWbsVersionPayload = new PmsWbsVersionPayload();
        pmsWbsVersionPayload.setProId(pmsProjectWbsVO.getProjectId());
        pmsWbsVersionPayload.setVersionNo(pmsProjectWbsVO.getVersionNo() + 1);
        pmsWbsVersionPayload.setStepNum(1);
        pmsWbsVersionPayload.setState(state);
        PmsWbsVersionVO insert = pmsWbsVersionService.insert(pmsWbsVersionPayload);
        return insert;
    }

    /**
     * 核验活动下成本估算和交付物数据
     *
     * @param wbsPayloads
     * @param pmsProjectWbsDOS
     * @param actCostPayloads
     * @param actPayPayloads
     * @param projectId
     */
    void checkWbsAct(List<PmsProjectWbsPayload> wbsPayloads, List<PmsProjectWbsDO> pmsProjectWbsDOS, List<PmsWbsActCostPayload> actCostPayloads, List<PmsWbsActPayPayload> actPayPayloads, Long projectId, List<PmsWbsActCostVO> pmsWbsActCostVOS, List<PmsWbsActPayVO> pmsWbsActPayVOS) {
        //核验名称是否重复
        for (PmsProjectWbsPayload wbsPayload : wbsPayloads) {
            List<PmsWbsActCostPayload> costPayloads = wbsPayload.getActCostPayloads();
            List<PmsWbsActPayPayload> payloads = wbsPayload.getActPayPayloads();
            if (!ObjectUtils.isEmpty(costPayloads) || !ObjectUtils.isEmpty(payloads)) {
                Optional<PmsProjectWbsDO> first = pmsProjectWbsDOS.stream().filter(wbsDO -> wbsDO.getWbsCode().equals(wbsPayload.getWbsCode())).findFirst();
                PmsProjectWbsDO pmsProjectWbsDO = first.get();
                if (!ObjectUtils.isEmpty(costPayloads)) {
                    List<String> collect = costPayloads.stream().map(PmsWbsActCostPayload::getCostName).distinct().collect(Collectors.toList());
                    if (costPayloads.size() != collect.size()) {
                        throw TwException.error("", "【" + pmsProjectWbsDO.getWbsName() + "】活动描述不可重复，请核验！");
                    }
                    //注释掉是因为记录不了名称的变更
                    costPayloads.forEach(costPayload -> {
                        costPayload.setProjectId(projectId);
                        costPayload.setWbsId(pmsProjectWbsDO.getId());
                        costPayload.setWbsName(pmsProjectWbsDO.getWbsName());
                    });
                    actCostPayloads.addAll(costPayloads);
                }
                if (!ObjectUtils.isEmpty(payloads)) {
                    List<String> collect = payloads.stream().map(PmsWbsActPayPayload::getPayName).distinct().collect(Collectors.toList());
                    if (payloads.size() != collect.size()) {
                        throw TwException.error("", "【" + pmsProjectWbsDO.getWbsName() + "】目标交付物名称不可重复，请核验！");
                    }
                    //注释掉是因为记录不了名称的变更
                    payloads.forEach(payPayload -> {
                        payPayload.setProjectId(projectId);
                        payPayload.setWbsId(pmsProjectWbsDO.getId());
                        payPayload.setWbsName(pmsProjectWbsDO.getWbsName());
                    });
                    actPayPayloads.addAll(payloads);
                }
            }
        }
    }


    /**
     * 获取要计算 节点权重的 子节点
     *
     * @param projectId
     * @param parentWbsCodes
     * @return
     */
    public List<PmsProjectWbsVO> getSetWbs(Long projectId, List<String> parentWbsCodes) {
        PmsProjectWbsQuery query = new PmsProjectWbsQuery();
        query.setProjectId(projectId);
        query.setParentWbsCodes(parentWbsCodes);
        List<PmsProjectWbsVO> list = pmsProjectWbsDAO.queryListDynamic(query);
        // 排除 节点属性 为 里程碑的节点
        return list.stream().filter(v -> !ProjectWbsTypeEnum.MS.getCode().equals(v.getWbsType())).collect(Collectors.toList());
    }


    /**
     * 活动节点 新建  或者  节点下没有任务时 活动进度=（当前时间-实际开始时间）/预计持续天数*100%
     * 节点修改时，如果 有任务  根据任务来算,进度和状态不变
     */
    public void countProgressAndStatus(List<PmsProjectWbsVO> pmsProjectWbsVOS) {
        // 查询有任务的节点
        List<Long> wbsIds = pmsProjectWbsVOS.stream().map(v -> v.getId()).collect(Collectors.toList());
        List<Long> hasTaskWbsIdS = new ArrayList<>();
        if (!ObjectUtils.isEmpty(wbsIds)) {
            List<PmsWbsTaskVO> taskVOS = getPmsWbsTaskService().findByWbsIds(wbsIds);
            hasTaskWbsIdS = taskVOS.stream().map(v -> v.getWbsId()).collect(Collectors.toList());
        }
        // 先处理  活动节点 进度  ：是活动节点  但下面没任务
        List<Long> finalHasTaskWbsIdS = hasTaskWbsIdS;
        pmsProjectWbsVOS.forEach(wbs -> {
            if (ProjectWbsTypeEnum.ACT.getCode().equals(wbs.getWbsType()) && !finalHasTaskWbsIdS.contains(wbs.getId())) {
                countWbsProgress(wbs);
            }
        });
        // 再处理  WBS元素 进度
        Map<String, BigDecimal> map = new HashMap<>();

        // 1.计算 WBS元素 下面有活动的
        Map<String, List<PmsProjectWbsVO>> actMap = pmsProjectWbsVOS.stream()
                .filter(v -> ProjectWbsTypeEnum.ACT.getCode().equals(v.getWbsType()))
                .collect(Collectors.groupingBy(
                        PmsProjectWbsVO::getParentWbsCode,
                        Collectors.toList()
                ));
        for (Map.Entry<String, List<PmsProjectWbsVO>> entry : actMap.entrySet()) {
            map.put(entry.getKey(), countWbsProgress(entry.getValue()));
        }
        // 2.计算 WBS元素 下面没有活动的： 是WBS元素  但下面没有活动
        pmsProjectWbsVOS.forEach(wbs -> {
            if (ProjectWbsTypeEnum.WBS.getCode().equals(wbs.getWbsType()) && !map.containsKey(wbs.getWbsCode())) {
                countWbsProgress(wbs);
            }
        });
        // 3.计算 WBS元素 父级
        Map<String, List<PmsProjectWbsVO>> wbsMap = pmsProjectWbsVOS.stream()
                .filter(v -> ProjectWbsTypeEnum.WBS.getCode().equals(v.getWbsType()) && !ObjectUtils.isEmpty(v.getParentWbsCode()))
                .collect(Collectors.groupingBy(
                        PmsProjectWbsVO::getParentWbsCode,
                        Collectors.toList()
                ));
        // 要小心 元素下 有元素和活动
        for (Map.Entry<String, List<PmsProjectWbsVO>> entry : wbsMap.entrySet()) {
            List<PmsProjectWbsVO> value = entry.getValue();
            if (actMap.containsKey(entry.getKey())) {
                value.addAll(actMap.get(entry.getKey()));
            }
            map.put(entry.getKey(), countWbsProgress(value));
        }

        // 给 WBS元素 元素赋值
        pmsProjectWbsVOS.forEach(wbs -> {
            if (ProjectWbsTypeEnum.WBS.getCode().equals(wbs.getWbsType())) {
                if (map.containsKey(wbs.getWbsCode())) {
                    wbs.setWbsProgress(map.get(wbs.getWbsCode()));
                }
            }
            //将 节点  的  进度 和状态缓存下来
            Map<String, Object> info = new HashMap<>();
            info.put("wbsProgress", wbs.getWbsProgress());
            info.put("wbsStatus", wbs.getWbsStatus());
            progressAndStatusCache.put(wbs.getId(), info);
        });
    }


    /**
     * 计算  进度
     * 是活动节点  但下面没任务
     * 是WBS元素  但下面没有活动
     */
    public void countWbsProgress(PmsProjectWbsVO wbs) {
        if (!ObjectUtils.isEmpty(wbs.getPreStartDate()) && !ObjectUtils.isEmpty(wbs.getPreEndDate()) && !ObjectUtils.isEmpty(wbs.getStartDate())) {
            // 获取预计持续工作天数 不能为空
            if (ObjectUtils.isEmpty(wbs.getPreDurationDay())) {
                PmsProjectCalendarPayload payload = new PmsProjectCalendarPayload();
                payload.setSourceId(wbs.getId());
                payload.setSourceType(ProjectWbsTypeEnum.WBS.getCode());
                payload.setStartDate(wbs.getPreStartDate());
                payload.setEndDate(wbs.getPreEndDate());
                payload.setProjectId(wbs.getProjectId());
                PmsProjectCalendarVO bySource = calendarService.findBySource(payload);
                if (!ObjectUtils.isEmpty(bySource)) {
                    payload.setDurationDays(bySource.getDurationDays());
                }
            }
            if (!ObjectUtils.isEmpty(wbs.getPreDurationDay())) {
                BigDecimal wbsProgress = BigDecimal.valueOf(Period.between(wbs.getStartDate(), LocalDate.now()).getDays()).divide(wbs.getPreDurationDay(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
                if (wbsProgress.doubleValue() > 100) {
                    wbsProgress = BigDecimal.valueOf(100);
                }
                wbs.setWbsProgress(wbsProgress);
                if (wbsProgress.doubleValue() > 0 && wbsProgress.doubleValue() < 100) {
                    wbs.setWbsStatus(ProjectWbsStatusEnum.NOGIONG.getCode());
                    wbs.setWbsStatusName(ProjectWbsStatusEnum.NOGIONG.getDesc());
                } else if (wbsProgress.doubleValue() == 100) {
                    wbs.setWbsStatus(ProjectWbsStatusEnum.FINISHED.getCode());
                    wbs.setWbsStatusName(ProjectWbsStatusEnum.FINISHED.getDesc());
                } else if (wbsProgress.doubleValue() == 0) {
                    wbs.setWbsStatus(ProjectWbsStatusEnum.NOSTART.getCode());
                    wbs.setWbsStatusName(ProjectWbsStatusEnum.NOSTART.getDesc());
                }
            }
        }
    }

    /**
     * 计算 节点进度
     *
     * @param list
     * @return
     */
    private BigDecimal countWbsProgress(List<PmsProjectWbsVO> list) {
        if (ObjectUtils.isEmpty(list)) {
            return BigDecimal.ZERO;
        }
        // 如果节点下的子节点进度都100   父节点的进度也就是100了
        long size = list.stream().filter(v -> !ObjectUtils.isEmpty(v.getWbsProgress()) && v.getWbsProgress().doubleValue() == 100).count();
        if (list.size() == size) {
            return BigDecimal.valueOf(100);
        }
        BigDecimal wbsProgress = BigDecimal.ZERO;
        for (PmsProjectWbsVO wbs : list) {
            if (!ObjectUtils.isEmpty(wbs.getWbsProgress()) && !ObjectUtils.isEmpty(wbs.getWbsWeight())) {
                wbsProgress = wbsProgress.add(wbs.getWbsProgress().multiply(wbs.getWbsWeight()));
            }
        }
        return wbsProgress.divide(BigDecimal.valueOf(100));
    }

    /**
     * 计算权重  只有  wbs 元素 和活动创建 权重
     *
     * @param wbsPayloads
     */
    private void setWbsWeight(List<PmsProjectWbsPayload> wbsPayloads, List<PmsProjectWbsVO> pmsProjectWbsVOS) {
        // 判断是新增还是修改
        Boolean insertFlag = ObjectUtils.isEmpty(wbsPayloads.get(0).getId()) || wbsPayloads.get(0).getId().longValue() < 1;
        // 根据父级 编号 分组
        Map<String, List<PmsProjectWbsPayload>> groupMap = wbsPayloads.stream()
                .collect(Collectors.groupingBy(
                        PmsProjectWbsPayload::getParentWbsCode,
                        Collectors.toList()
                ));
        for (Map.Entry<String, List<PmsProjectWbsPayload>> entry : groupMap.entrySet()) {
            String parentWbsCode = entry.getKey();
            List<PmsProjectWbsVO> list = new ArrayList<>();
            if (!ObjectUtils.isEmpty(pmsProjectWbsVOS)) {
                list = pmsProjectWbsVOS.stream().filter(vo -> vo.getParentWbsCode().equals(parentWbsCode) && (vo.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) || vo.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode()))).collect(Collectors.toList());
            }
            if (insertFlag) {
                List<PmsProjectWbsPayload> value = entry.getValue();
                // 只有  wbs 元素 和活动创建 权重
                value = value.stream().filter(wbsPayload -> wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) || wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode())).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty(value)) {
                    insertWbsWeight(value, list);
                }
            } else {
                List<PmsProjectWbsVO> finalList = list;
                wbsPayloads.forEach(v -> updateWbsWeight(v, finalList));
            }
        }
    }


    /**
     * 计算权重  只有  wbs 元素 和活动创建 权重
     *
     * @param wbsPayloads
     */
    private void insertWbsWeight(List<PmsProjectWbsPayload> wbsPayloads, List<PmsProjectWbsVO> list) {
        wbsPayloads.forEach(v -> v.setManualSettingWeight(0));
        if (ObjectUtils.isEmpty(list)) {
            // 获取旧的平均值
            BigDecimal average = BigDecimal.valueOf(100).divide(BigDecimal.valueOf(wbsPayloads.size()), 2, RoundingMode.HALF_UP);
            wbsPayloads.forEach(v -> v.setWbsWeight(average));
        } else {
            // 算出已经手动设置过值得节点 总权重
            BigDecimal weights = list.stream().filter(v -> 1 == v.getManualSettingWeight()).map(PmsProjectWbsVO::getWbsWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 计算出新的平均值
            list = list.stream().filter(v -> 0 == v.getManualSettingWeight()).collect(Collectors.toList());
            long count = list.size();
            BigDecimal averageNew = BigDecimal.valueOf(100).subtract(weights).divide(BigDecimal.valueOf(count + wbsPayloads.size()), 2, RoundingMode.HALF_UP);
            wbsPayloads.forEach(v -> v.setWbsWeight(averageNew));

            // 修改数据库里 权重不一致的值
            list.forEach(v -> v.setWbsWeight(averageNew));
            pmsProjectWbsDAO.saveAll(PmsProjectWbsConvert.INSTANCE.toEntity(list));
        }
    }


    /**
     * 计算权重  只有  wbs 元素 和活动创建 权重
     */
    private void updateWbsWeight(PmsProjectWbsPayload payload, List<PmsProjectWbsVO> list) {
        BigDecimal weightNew = payload.getWbsWeight();
        if (!ObjectUtils.isEmpty(weightNew)) {
            payload.setManualSettingWeight(1);
            // 判断下 前端传过来的值 是否是旧值 不一样 重新计算权重
            BigDecimal weightOld = list.stream().filter(v -> payload.getId().equals(v.getId())).findFirst().get().getWbsWeight();
            if (weightNew.compareTo(weightOld) != 0) {
                // 算出已经手动设置过值得节点 总权重  排除当前节点
                BigDecimal weights = list.stream().filter(v -> !payload.getId().equals(v.getId()) && 1 == v.getManualSettingWeight()).map(PmsProjectWbsVO::getWbsWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                // 验证权重总和不可超过100
                weights = weights.add(weightNew);
                if (weights.doubleValue() > 100) {
                    throw TwException.error("", "该节点下的手动设置节点权重总和超过100了，请核验！");
                }
                list = list.stream().filter(v -> !payload.getId().equals(v.getId()) && 0 == v.getManualSettingWeight()).collect(Collectors.toList());
                updateWbsWeight(list, weights);
            }
        }
    }

    /**
     * 修改原表记录的 权重
     *
     * @param list
     * @param weights
     */
    private void updateWbsWeight(List<PmsProjectWbsVO> list, BigDecimal weights) {
        // 计算出新的平均值
        long count = list.size();
        if (count > 0) {
            BigDecimal averageNew = BigDecimal.valueOf(100).subtract(weights).divide(BigDecimal.valueOf(count), 2, RoundingMode.HALF_UP);
            // 修改数据库里 权重不一致的值
            list.forEach(v -> v.setWbsWeight(averageNew));
            pmsProjectWbsDAO.saveAll(PmsProjectWbsConvert.INSTANCE.toEntity(list));
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateAllocateInfo(Long activityId, BigDecimal allocateEqva, BigDecimal allocateCost, String allocateStatus) {
        PmsProjectWbsPayload activityPayload = new PmsProjectWbsPayload();
        activityPayload.setId(activityId);
        activityPayload.setAllocateCost(allocateCost);
        activityPayload.setAllocateEqva(allocateEqva);
        activityPayload.setAllocateStatus(allocateStatus);
        pmsProjectWbsDAO.updateByKeyNoVersion(activityPayload);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateAllocateInfoByEffId(Long effId, BigDecimal allocateEqva, BigDecimal allocateCost, String allocateStatus) {
        PmsProjectWbsPayload activityPayload = new PmsProjectWbsPayload();
        activityPayload.setEffRelateId(effId);
        activityPayload.setAllocateCost(allocateCost);
        activityPayload.setAllocateEqva(allocateEqva);
        activityPayload.setAllocateStatus(allocateStatus);
        pmsProjectWbsDAO.updateByKeyNoVersionByEffId(activityPayload);
    }

    @Override
    public void checkStep2(PmsProjectWbsQuery query) {
        List<Long> ids = query.getIds();
        List<PmsProjectWbsVO> pmsProjectWbsVOS = pmsProjectWbsDAO.queryListByIds(ids);
        for (PmsProjectWbsVO pmsProjectWbsVO : pmsProjectWbsVOS) {
            // 活动
            if (pmsProjectWbsVO.getWbsType().equals("ACT")) {
                if (null == pmsProjectWbsVO.getPreStartDate()) {
                    throw new BusinessException("编号为" + pmsProjectWbsVO.getWbsCode() + "的计划预计开始时间不能为空");
                }
                if (null == pmsProjectWbsVO.getPreEndDate()) {
                    throw new BusinessException("编号为" + pmsProjectWbsVO.getWbsCode() + "的计划预计结束时间不能为空");
                }

            }
            // 里程碑
            if (pmsProjectWbsVO.getWbsType().equals("MS")) {
                if (null == pmsProjectWbsVO.getPreEndDate()) {
                    throw new BusinessException("编号为" + pmsProjectWbsVO.getWbsCode() + "的计划预计结束时间不能为空");
                }
            }

        }

    }

    @Override
    public void exportElecPlanTask(HttpServletResponse response, PmsProjectWbsQuery query) {
        try {

            List<PmsProjectWbsVO> pmsProjectWbsVOS = queryList(query);
            if (!ObjectUtils.isEmpty(pmsProjectWbsVOS)) {
                AtomicInteger atomicId = new AtomicInteger(1);
                pmsProjectWbsVOS.forEach(mpxjMppTaskVO -> mpxjMppTaskVO.setRowId(atomicId.getAndIncrement()));
            }
            ProjectFile projectFile = new ProjectFile();
            pmsProjectWbsVOS.forEach(mpxjMppTaskVO -> {
                Task task = projectFile.addTask();

                //任务行id
                task.setID(mpxjMppTaskVO.getRowId());
                //wbs编码
                task.setWBS(mpxjMppTaskVO.getWbsCode());
                //任务级别
                // task.setOutlineLevel(mpxjMppTaskVO.getTasKLevel());
                //任务名称
                task.setName(mpxjMppTaskVO.getWbsName());
                if (mpxjMppTaskVO.getWbsProgress() != null) {
                    //任务进度
                    task.setPercentageComplete(mpxjMppTaskVO.getWbsProgress());
                }
//            Date baseline2FinishDate = Date.from(mpxjMppTaskVO.getBaseline2FinishDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
//
//            //基线二数据
//            task.setBaselineEstimatedFinish(2, baseline2FinishDate);
                //工期
                double preDurationDay = mpxjMppTaskVO.getPreDurationDay() == null ? 0d : mpxjMppTaskVO.getPreDurationDay().doubleValue();
                task.setDuration(Duration.getInstance(preDurationDay, TimeUnit.getInstance(TimeUnit.DAYS.getValue())));
                if (mpxjMppTaskVO.getPreStartDate() != null) {
                    //开始时间
                    Date planStartDate = Date.from(mpxjMppTaskVO.getPreStartDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                    task.setStart(planStartDate);
                }
                //结束时间
                if (mpxjMppTaskVO.getPreEndDate() != null) {
                    Date planFinishDate = Date.from(mpxjMppTaskVO.getPreEndDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                    task.setFinish(planFinishDate);
                }

                if (StringUtils.hasText(mpxjMppTaskVO.getWbsType())) {
                    //是否总线任务
                    if (mpxjMppTaskVO.getWbsType().equals(ProjectWbsTypeEnum.ACTG.getCode())) {
                        task.setSummary(true);
                    }
                    if (mpxjMppTaskVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
                        task.setMilestone(true);
                    }
                }

                //资源
                if (!ObjectUtils.isEmpty(mpxjMppTaskVO.getPmsProjectWbsResourceVOList())) {
                    mpxjMppTaskVO.getPmsProjectWbsResourceVOList().forEach(resourceVO -> {
                        Resource resource = projectFile.addResource();

                        //resource.setID(resourceVO.getId());
                        resource.setName(resourceVO.getRelatePartiesName());
                        task.addResourceAssignment(resource);
                    });
                }
            });
            //赋值前置任务
            List<Task> tasks = projectFile.getTasks();
            tasks.forEach(task -> {
                PmsProjectWbsVO mpxjMppTaskVO = pmsProjectWbsVOS.stream().filter(taskVO -> taskVO.getRowId().equals(task.getID())).findFirst().get();

                if (!ObjectUtils.isEmpty(mpxjMppTaskVO.getPmsProjectWbsRelyVOList())) {
//                    List<RelationVO> os = JSON.parseObject(mpxjMppTaskVO.getTaskPredecessors(), List.class);
                    // List<RelationVO> os = JSON.parseArray(mpxjMppTaskVO.getTaskPredecessors(), RelationVO.class);
                    //List<RelationVO> os = (List<RelationVO>) JSONArray.parseObject(mpxjMppTaskVO.getTaskPredecessors());
                    mpxjMppTaskVO.getPmsProjectWbsRelyVOList().forEach(relation -> {
                        PmsProjectWbsVO pmsProjectWbsVO1 = pmsProjectWbsVOS.stream().filter(pmsProjectWbsVO -> pmsProjectWbsVO.getId().equals(relation.getWbsRelyId())).findFirst().get();
                        Optional<Task> first = tasks.stream().filter(taskVO -> taskVO.getID().equals(pmsProjectWbsVO1.getRowId())).findFirst();
                        if (first.isPresent()) {
                            //  relation.getRelyType()
                            int typeValue = 0;
                            String relyType = relation.getRelyType();
                            switch (relyType) {
                                case "FS":
                                    typeValue = 1;
                                    break;
                                case "SF":
                                    typeValue = 2;
                                    break;
                                case "SS":
                                    typeValue = 3;
                                    break;
                            }
                            task.addPredecessor(first.get(), RelationType.getInstance(typeValue), Duration.getInstance(0, TimeUnit.getInstance(TimeUnit.DAYS.getValue())));
                        }
                    });
                }
                if (StringUtils.hasText(mpxjMppTaskVO.getParentWbsCode())) {
                    Optional<Task> first = tasks.stream().filter(taskVO -> taskVO.getWBS().equals(mpxjMppTaskVO.getParentWbsCode())).findFirst();
                    if (first.isPresent()) {
                        first.get().addChildTask(task);
                    }
                }

            });
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            MSPDIWriter writer = new MSPDIWriter();

            writer.write(projectFile, bos);

            InputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
            response.setContentType("application/octet-stream");
            response.addHeader("Content-Disposition", "attachment;filename=project.xml");
            byte[] buffer = new byte[1024];
            int bytesRead;
            while ((bytesRead = byteArrayInputStream.read(buffer)) != -1) {
                response.getOutputStream().write(buffer, 0, bytesRead);
            }

            byteArrayInputStream.close();

        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    @Override
    public List<PmsProjectWbsVO> importElecPlanTask(MultipartFile file, Long projectId) {
        String extension = FilenameUtils.getExtension(file.getOriginalFilename());
        if (!"mpp".equals(extension)) {
            log.info("导入失败，文件名后缀必须为“mpp”！");
        }
        MPPReader mppRead = new MPPReader();
        ProjectFile project = null;
        try {
            project = mppRead.read(file.getInputStream());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "文件解析异常");
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = new ArrayList<>();
        //遍历任务
        analysisFile(project, pmsProjectWbsVOS, projectId);

        return pmsProjectWbsVOS;
    }

    /**
     * 分析文件内容并处理相应任务
     * 该方法主要用于接收一个任务对象和一个项目分解结构的列表，对文件进行分析，
     * 并根据分析结果更新任务或项目信息具体的分析逻辑和文件处理方式依赖于具体实现
     *
     * @param project          需要分析处理的任务对象，包含任务的相关信息和上下文
     * @param pmsProjectWbsVOS 项目分解结构的列表，用于参考项目结构和任务之间的关系
     */
    void analysisFile(ProjectFile project, List<PmsProjectWbsVO> pmsProjectWbsVOS, Long projectId) {
        //相关方数据
        ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
        proRelatedPartiesQuery.setProId(projectId);
        List<ProRelatedPartiesVO> list = proRelatedPartiesDao.getList(proRelatedPartiesQuery);

        List<Task> tasks = project.getTasks();
        for (int i = 1; i < tasks.size(); i++) {
            PmsProjectWbsVO pmsProjectWbsVO = new PmsProjectWbsVO();

            Task task = tasks.get(i);
//            //任务项ID
            Integer task_id = task.getID();
            pmsProjectWbsVO.setId(Long.valueOf(task_id));
            //父级任务项ID
            Task parentTask = task.getParentTask();
            if (parentTask != null) {
                pmsProjectWbsVO.setParentWbsCode(parentTask.getWBS());
                pmsProjectWbsVO.setParentWbsName(parentTask.getName());
            }

            //wbs
            String task_wbs = task.getWBS();
            pmsProjectWbsVO.setWbsCode(task_wbs);
            //任务项名称
            String task_name = task.getName();
            pmsProjectWbsVO.setWbsName(task_name);
            //计划开始日期
            Date task_start_date = task.getStart();
            pmsProjectWbsVO.setPreStartDate(task_start_date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            //计划结束日期
            Date task_finish_date = task.getFinish();
            pmsProjectWbsVO.setPreEndDate(task_finish_date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());

            //工期差距
            double duration = task.getDuration().getDuration();
            pmsProjectWbsVO.setPreDurationDay(BigDecimal.valueOf(duration));

            List<ResourceAssignment> resourceAssignments = task.getResourceAssignments();
            if (!ObjectUtils.isEmpty(resourceAssignments)) {
                List<PmsProjectWbsResourceVO> resourceVOS = new ArrayList<>();
                resourceAssignments.forEach(resourceAssignment -> {
                    Resource resource = resourceAssignment.getResource();
                    if (resource != null) {
                        //获取相关方
                        Optional<ProRelatedPartiesVO> first = list.stream().filter(proRelatedPartiesVO -> proRelatedPartiesVO.getName().equals(resource.getName())).findFirst();
                        if (first.isPresent()) {
                            PmsProjectWbsResourceVO resourceVO = new PmsProjectWbsResourceVO();
                            resourceVO.setRelatePartiesName(resource.getName());
                            resourceVO.setRelatePartiesId(first.get().getId());
                            resourceVO.setRelatePartiesName(first.get().getName());
                            resourceVOS.add(resourceVO);
                        }
                    }
                });
                pmsProjectWbsVO.setPmsProjectWbsResourceVOList(resourceVOS);
            }
            //完成百分比
            pmsProjectWbsVO.setWbsProgress(BigDecimal.valueOf(task.getPercentageComplete().doubleValue()));
            pmsProjectWbsVO.setWbsType(ProjectWbsTypeEnum.ACT.getCode());
            //标记为里程碑
            boolean milestone = task.getMilestone();
            if (milestone) {
                pmsProjectWbsVO.setWbsType(ProjectWbsTypeEnum.MS.getCode());
            }
            //是否总账任务
            boolean summary = task.getSummary();
            if (summary) {
                pmsProjectWbsVO.setWbsType(ProjectWbsTypeEnum.ACTG.getCode());
            }
//获取前置任务（任务流）
            List<Relation> task_predecessors = task.getPredecessors();

            if (task_predecessors != null) {
                List<PmsProjectWbsRelyVO> taskRelations = new ArrayList<>();
                task_predecessors.forEach(relation -> {
                    if (relation.getTargetTask() != null) {
                        PmsProjectWbsRelyVO relationVO = new PmsProjectWbsRelyVO();
                        relationVO.setWbsId(Long.valueOf(task.getID()));
                        relationVO.setWbsName(task.getName());
                        relationVO.setWbsCode(task.getWBS());
                        relationVO.setWbsRelyId(Long.valueOf(relation.getTargetTask().getID()));
                        relationVO.setWbsRelyName(relation.getTargetTask().getName());
                        relationVO.setWbsRelyCode(relation.getTargetTask().getWBS());
                        relationVO.setRelyType(relation.getType().toString());
                        taskRelations.add(relationVO);
                    }
                });
                pmsProjectWbsVO.setPmsProjectWbsRelyVOList(taskRelations);
            }
            pmsProjectWbsVOS.add(pmsProjectWbsVO);
        }


    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateAllocateStatus(List<Long> wbsIdList, String status) {
        pmsProjectWbsDAO.updateAllocateStatus(wbsIdList, status);
    }

    @Override
    @Transactional
    public void batchUpdate(List<PmsProjectWbsPayload> activityPayloads) {
        if (!CollectionUtils.isEmpty(activityPayloads)) {
            activityPayloads.forEach(item -> {
                pmsProjectWbsDAO.updateByKeyNoVersion(item);
            });
        }
    }

    @Override
    @Transactional
    public void updateAllocateStatusByEffId(List<Long> wbsIdList, String allocateStatus) {
        pmsProjectWbsDAO.updateAllocateStatusByEffId(wbsIdList, allocateStatus);
    }


    public Map<Long, String> listConReceivablePlanVO(Long contractId) {
        //收款计划
        List<ConReceivablePlanVO> planVOList = conReceivablePlanService.queryBySaleConId(contractId);
        if (!ObjectUtils.isEmpty(planVOList)) {
            // 作废的收款阶段不需要关联阶段活动
            planVOList = planVOList.stream().filter(v -> !ObjectUtils.isEmpty(v.getReceStatus()) && !"INVALID".equals(v.getReceStatus())).collect(Collectors.toList());
        }
        // vo.setPlanVOS(planVOList);
        Map<Long, String> planInfo = planVOList.stream().collect(Collectors.toMap(ConReceivablePlanVO::getId, ConReceivablePlanVO::getReceStage));
        return planInfo;
    }


}


