package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsSnapshotPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsSnapshotQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsSnapshotService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsSnapshotVO;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectPlanSnapshotConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsSnapshotDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsSnapshotDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsSnapshotRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 项目计划快照
 *
 * @author carl
 * @date 2023-04-17
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectWbsSnapshotServiceImpl extends BaseServiceImpl implements PmsProjectWbsSnapshotService {

    private final PmsProjectWbsSnapshotRepo pmsProjectWbsSnapshotRepo;
    private final PmsProjectWbsSnapshotDAO pmsProjectWbsSnapshotDAO;

    @Override
    public PagingVO<PmsProjectWbsSnapshotVO> queryPaging(PmsProjectWbsSnapshotQuery query) {
        return pmsProjectWbsSnapshotDAO.queryPaging(query);
    }

    @Override
    public List<PmsProjectWbsSnapshotVO> queryListDynamic(PmsProjectWbsSnapshotQuery query) {
        return pmsProjectWbsSnapshotDAO.queryListDynamic(query);
    }

    @Override
    public PmsProjectWbsSnapshotVO queryByKey(Long key) {
        PmsProjectWbsSnapshotDO entity = pmsProjectWbsSnapshotRepo.findById(key).orElseGet(PmsProjectWbsSnapshotDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectWbsSnapshotVO vo = PmsProjectPlanSnapshotConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectWbsSnapshotVO insert(PmsProjectWbsSnapshotPayload payload) {
        PmsProjectWbsSnapshotDO entityDo = PmsProjectPlanSnapshotConvert.INSTANCE.toDo(payload);
        return PmsProjectPlanSnapshotConvert.INSTANCE.toVo(pmsProjectWbsSnapshotRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectWbsSnapshotVO update(PmsProjectWbsSnapshotPayload payload) {
        PmsProjectWbsSnapshotDO entity = pmsProjectWbsSnapshotRepo.findById(payload.getId()).orElseGet(PmsProjectWbsSnapshotDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectWbsSnapshotDO entityDo = PmsProjectPlanSnapshotConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectPlanSnapshotConvert.INSTANCE.toVo(pmsProjectWbsSnapshotRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsProjectWbsSnapshotDAO.deleteSoft(keys);
        }
    }

}
