package com.elitesland.tw.tw5.server.prd.pms.service;


import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsTempBatchPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsTempPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsTempQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsTempVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectWbsTempConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsTempDao;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsTempDO;
import com.elitesland.tw.tw5.server.prd.pms.service.inf.PmsProjectWbsTempService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;


/**
 * 项目wbs模板表service impl
 *
 * @author wangxl
 * @date 2024/4/2
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsProjectWbsTempServiceImpl implements PmsProjectWbsTempService {

    private final PmsProjectWbsTempDao dao;

    @Override
    public TwOutputUtil<PagingVO<PmsProjectWbsTempVO>> queryPage(PmsProjectWbsTempQuery query) {
        PagingVO<PmsProjectWbsTempVO> pageVO = dao.queryPage(query);
        translate(pageVO.getRecords());
        return TwOutputUtil.ok(pageVO);
    }

    @Override
    public TwOutputUtil<List<PmsProjectWbsTempVO>> queryList(PmsProjectWbsTempQuery query) {
        List<PmsProjectWbsTempVO> listVO = dao.queryList(query);
        translate(listVO);
        return TwOutputUtil.ok(listVO);
    }

    @Override
    public TwOutputUtil<Long> queryCount(PmsProjectWbsTempQuery query) {
        return TwOutputUtil.ok(dao.queryCount(query));
    }

    @Override
    public TwOutputUtil<PmsProjectWbsTempVO> queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsProjectWbsTempVO vo = dao.queryByKey(id);
        Assert.notNull(vo, "查询的数据不存在");
        translate(List.of(vo));
        return TwOutputUtil.ok(vo);
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsProjectWbsTempVO> insert(PmsProjectWbsTempPayload payload) {
        // 检查数据局
        checkData(payload);
        // 新增默认状态为草稿
        if (StrUtil.isBlank(payload.getState())) {
            payload.setState("1");
        }
        // 保存数据
        PmsProjectWbsTempVO save = dao.save(payload);
        // 开启工作流
        // startWorkFlow(ado);

        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsProjectWbsTempVO> update(PmsProjectWbsTempPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsProjectWbsTempVO save = dao.save(payload);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsProjectWbsTempVO> updateDynamic(PmsProjectWbsTempPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        dao.updateByKeyDynamic(payload);
        return queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<Long> deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw  TwException.error("","ids参数不能为空");
        }
        return TwOutputUtil.ok(dao.deleteSoft(ids));
    }

    @Override
    @Transactional
    public TwOutputUtil<Boolean> batchInsert(PmsProjectWbsTempBatchPayload payload) {
        payload.getPmsProjectWbsTempPayloadList().forEach(x -> {
            x.setTempId(payload.getTempId());
            checkData(x);
        });
        dao.delByTempId(payload.getTempId());
        List<PmsProjectWbsTempDO> pmsProjectWbsTempDOList = PmsProjectWbsTempConvert.INSTANCE.toEntity(payload.getPmsProjectWbsTempPayloadList());
        List<PmsProjectWbsTempDO> pmsProjectWbsTempDOS = dao.saveAll(pmsProjectWbsTempDOList);

        return TwOutputUtil.ok(true);
    }

    @Override
    @Transactional
    public Long submitTemplate(Long tempId) {
        Long res = dao.submitTemplate(tempId, "1");
        return res;
    }


    /**
     * 发起工作流
     *
     * @param payload payload
     * @return result
     */
    private TwOutputUtil<Long> startWorkFlow(PmsProjectWbsTempPayload payload) {
        // 发起工作流程
        HashMap<String, Object> varMaps = new HashMap<>();
//        Assert.notNull(payload.getUserId(), "userId不能为空");
//        // 变更资源审批
//        varMaps.put("Activity_111kevq", payload.getUserId());
        //发起流程审批
//        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                HrBaseEnum.BASE_BU_CHANGE.getCode(),
//                HrBaseEnum.BASE_BU_CHANGE.getDesc(),
//                res.getId().toString(), varMaps));
//        String procInstId = processInfo.getProcInstId();
//        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        String procInstId = "";
        // 回写单据的工作流信息
//        payload.setProcInstId(procInstId);
//        payload.setProcInstStatus("");
        Long update = dao.updateByKeyDynamic(payload);
        return TwOutputUtil.ok(update);
    }

    /**
     * 数据校验
     *
     * @param payload payload
     */
    private void checkData(PmsProjectWbsTempPayload payload) {
        Assert.notNull(payload.getTempId(), "项目模板主键不能为空");
        Assert.notNull(payload.getWbsName(), "项目wbs名称不能为空");
        Assert.notNull(payload.getWbsType(), "项目wbs类型不能为空");
        Assert.notNull(payload.getWbsCode(), "项目wbs编码不能为空");
    }

    /**
     * todo
     *
     * @param vos vos
     */
    private void translate(List<PmsProjectWbsTempVO> vos) {
        vos.forEach(vo -> {
            // todo 翻译vo对象
//            vo.setUserIdDesc("");
        });
    }

}