package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsActPayPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsWbsActPayQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsWbsActPayService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsActPayVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsWbsActPayConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsWbsActPayDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsWbsActPayDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsWbsActPayRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * wbs活动交付物
 *
 * @author carl
 * @date 2023-04-06
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsWbsActPayServiceImpl extends BaseServiceImpl implements PmsWbsActPayService {

    private final PmsWbsActPayRepo pmsWbsActPayRepo;
    private final PmsWbsActPayDAO pmsWbsActPayDAO;

    @Override
    public PagingVO<PmsWbsActPayVO> paging(PmsWbsActPayQuery query) {
        Page<PmsWbsActPayDO> page = pmsWbsActPayRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(PmsWbsActPayConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<PmsWbsActPayVO> queryPaging(PmsWbsActPayQuery query) {
        return pmsWbsActPayDAO.queryPaging(query);
    }

    @Override
    public List<PmsWbsActPayVO> queryList(PmsWbsActPayQuery query) {
        return PmsWbsActPayConvert.INSTANCE.toVoList(
                pmsWbsActPayRepo.findAll(
                        (root, criteriaQuery, criteriaBuilder)
                                -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                        , query.getPageRequest().getSort()
                )
        );
    }

    @Override
    public List<PmsWbsActPayVO> queryListDynamic(PmsWbsActPayQuery query) {
        return pmsWbsActPayDAO.queryListDynamic(query);
    }

    @Override
    public PmsWbsActPayVO queryByKey(Long key) {
        PmsWbsActPayDO entity = pmsWbsActPayRepo.findById(key).orElseGet(PmsWbsActPayDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsWbsActPayVO vo = PmsWbsActPayConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsWbsActPayVO insert(PmsWbsActPayPayload payload) {
        PmsWbsActPayDO entityDo = PmsWbsActPayConvert.INSTANCE.toDo(payload);
        return PmsWbsActPayConvert.INSTANCE.toVo(pmsWbsActPayRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsWbsActPayVO update(PmsWbsActPayPayload payload) {
        PmsWbsActPayDO entity = pmsWbsActPayRepo.findById(payload.getId()).orElseGet(PmsWbsActPayDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsWbsActPayDO entityDo = PmsWbsActPayConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsWbsActPayConvert.INSTANCE.toVo(pmsWbsActPayRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<PmsWbsActPayDO> optional = pmsWbsActPayRepo.findById(id);
                if (!optional.isEmpty()) {
                    PmsWbsActPayDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    pmsWbsActPayRepo.save(entity);
                }
            });
        }
    }

}
