package com.elitesland.tw.tw5.server.prd.pms.stateflow.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.PmsStateFlowVersionPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.PmsStateFlowVersionQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.PmsStateFlowVersionVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.PmsStateFlowVersionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 状态流版本表
 *
 * @author wangxl
 * @date 2024/4/19
 */
@RestController
@RequestMapping("/api/pmsStateFlowVersion")
@RequiredArgsConstructor
@Slf4j
@Api(value = "状态流版本表", tags = {"状态流版本表"})
public class PmsStateFlowVersionController {


    private final PmsStateFlowVersionService service;


    @ApiOperation("分页查询")
    @GetMapping("/page")
    public TwOutputUtil<PagingVO<PmsStateFlowVersionVO>> page(PmsStateFlowVersionQuery query) {
        return service.queryPage(query);
    }

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TwOutputUtil<List<PmsStateFlowVersionVO>> list(PmsStateFlowVersionQuery query) {
        return service.queryList(query);
    }

    @ApiOperation("主键查询")
    @GetMapping("/key")
    public TwOutputUtil<PmsStateFlowVersionVO> queryByKey(Long id) {
        return service.queryByKey(id);
    }

    @ApiOperation("新增")
    @PostMapping("/insert")
    // @DuplicateSubmissionPrevention
    public TwOutputUtil<PmsStateFlowVersionVO> insert(@RequestBody PmsStateFlowVersionPayload payload) {
        // 关键日志打印
        log.debug("【PmsStateFlowVersionController.insert】入参：" + payload.toString());
        return service.insert(payload);
    }

//    @ApiOperation("修改")
//    @PostMapping("/update")
//    public TwOutputUtil<PmsStateFlowVersionVO> update(@RequestBody PmsStateFlowVersionPayload payload) {
//        // 关键日志打印
//        log.debug("【PmsStateFlowVersionController.update】入参：" + payload.toString());
//        return service.update(payload);
//    }

    @ApiOperation("动态修改")
    @PostMapping("/updateDynamic")
    public TwOutputUtil<PmsStateFlowVersionVO> updateDynamic(@RequestBody PmsStateFlowVersionPayload payload) {
        // 关键日志打印
        log.debug("【PmsStateFlowVersionController.updateDynamic】入参：" + payload.toString());
        return service.updateDynamic(payload);
    }

    @ApiOperation("完成")
    @PostMapping("/complete")
    public TwOutputUtil<PmsStateFlowVersionVO> complete(@RequestBody PmsStateFlowVersionPayload payload) {
        // 关键日志打印
        log.debug("【PmsStateFlowVersionController.updateDynamic】入参：" + payload.toString());
        payload.setState(3);
        return service.updateDynamic(payload);
    }

    @ApiOperation("删除")
    @PostMapping("/deleteSoft")
    public TwOutputUtil<Long> deleteSoft(@RequestBody List<Long> ids) {
        log.debug("【PmsStateFlowVersionController.deleteSoft】入参：" + ids);
        return service.deleteSoft(ids);
    }
}
