package com.elitesland.tw.tw5.server.prd.pms.stateflow.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.StateFlowConfigPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowConfigQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowConfigVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowConfigService;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-23
 * @desc : 状态流转配置
 */
@RestController
@RequestMapping("/api/stateFlowConfig")
@RequiredArgsConstructor
@Api(value = "状态流转配置", tags = {"状态流转配置"})
public class StateFlowConfigController {

   private final StateFlowConfigService stateFlowConfigService;


   @GetMapping("get")
   @ApiOperation("详情-状态流转配置")
   public TwOutputUtil<StateFlowConfigVO> get(Long id) {

       StateFlowConfigVO res = stateFlowConfigService.get(id);
       return TwOutputUtil.ok(res);

   }


   @PostMapping("save")
   @ApiOperation("新增-状态流转配置")
   public TwOutputUtil<Long> save(@RequestBody StateFlowConfigPayload stateFlowConfigPayload) {

       StateFlowConfigVO res = stateFlowConfigService.save(stateFlowConfigPayload);
       return TwOutputUtil.ok(res.getId());

   }


   @PostMapping("update")
   @ApiOperation("修改-状态流转配置")
   public TwOutputUtil<Long> update(@RequestBody StateFlowConfigPayload stateFlowConfigPayload) {

       Long res = stateFlowConfigService.update(stateFlowConfigPayload);
       return TwOutputUtil.ok(res);

   }


   @PostMapping("del")
   @ApiOperation("删除-状态流转配置")
   public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {

       Long res = stateFlowConfigService.del(ids);
       return TwOutputUtil.ok(res);

   }


   @PostMapping("page")
   @UdcNameClass
   @ApiOperation("分页查询-状态流转配置")
   public TwOutputUtil<PagingVO<StateFlowConfigVO>> page(@RequestBody StateFlowConfigQuery stateFlowConfigQuery) {

       PagingVO<StateFlowConfigVO> res = stateFlowConfigService.page(stateFlowConfigQuery);
       return TwOutputUtil.ok(res);

   }



   @GetMapping("getList")
   @ApiOperation("列表查询-状态流转配置")
   public TwOutputUtil<List<StateFlowConfigVO>> getList(StateFlowConfigQuery stateFlowConfigQuery) {

       List<StateFlowConfigVO> res = stateFlowConfigService.getList(stateFlowConfigQuery);
       return TwOutputUtil.ok(res);

   }


}

