package com.elitesland.tw.tw5.server.prd.pms.stateflow.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.StateFlowPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowService;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-23
 * @desc : 状态流
 */
@RestController
@RequestMapping("/api/stateFlow")
@RequiredArgsConstructor
@Api(value = "状态流", tags = {"状态流"})
public class StateFlowController {

   private final StateFlowService stateFlowService;


   @GetMapping("get")
   @ApiOperation("详情-状态流")
   public TwOutputUtil<StateFlowVO> get(Long id) {

       StateFlowVO res = stateFlowService.get(id);
       return TwOutputUtil.ok(res);

   }


   @PostMapping("save")
   @ApiOperation("新增-状态流")
   public TwOutputUtil<Long> save(@RequestBody StateFlowPayload stateFlowPayload) {

       StateFlowVO res = stateFlowService.save(stateFlowPayload);
       return TwOutputUtil.ok(res.getId());

   }


   @PostMapping("update")
   @ApiOperation("修改-状态流")
   public TwOutputUtil<Long> update(@RequestBody StateFlowPayload stateFlowPayload) {

       Long res = stateFlowService.update(stateFlowPayload);
       return TwOutputUtil.ok(res);

   }


   @PostMapping("del")
   @ApiOperation("删除-状态流")
   public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {

       Long res = stateFlowService.del(ids);
       return TwOutputUtil.ok(res);

   }


   @PostMapping("page")
   @UdcNameClass
   @ApiOperation("分页查询-状态流")
   public TwOutputUtil<PagingVO<StateFlowVO>> page(@RequestBody StateFlowQuery stateFlowQuery) {

       PagingVO<StateFlowVO> res = stateFlowService.page(stateFlowQuery);
       return TwOutputUtil.ok(res);

   }



   @GetMapping("getList")
   @ApiOperation("列表查询-状态流")
   public TwOutputUtil<List<StateFlowVO>> getList(StateFlowQuery stateFlowQuery) {

       List<StateFlowVO> res = stateFlowService.getList(stateFlowQuery);
       return TwOutputUtil.ok(res);

   }


    @GetMapping("getListByDtl")
    @ApiOperation("列表查询-状态流/状态流转配置")
    public TwOutputUtil<List<StateFlowVO>> getListByDtl(StateFlowQuery stateFlowQuery) {

        List<StateFlowVO> res = stateFlowService.getListByDtl(stateFlowQuery);
        return TwOutputUtil.ok(res);

    }


}

