package com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;


/**
 * @author : WWW
 * @date : 2024-1-23
 * @desc : 状态流转配置
 */
@Entity
@Table(name = "pms_state_flow_config")
@org.hibernate.annotations.Table(appliesTo = "pms_state_flow_config", comment = "状态流转配置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class StateFlowConfigDO extends BaseModel {


    /**
     * 状态流id
     */
    @Column(name = "flow_id", columnDefinition = "bigint(20) comment '状态流id'")
    private Long flowId;

    /**
     * 配置流id
     */
    @Column(name = "config_flow_id", columnDefinition = "bigint(20) comment '配置流id'")
    private Long configFlowId;


    /**
     * 配置流code
     */
    @Comment("配置流code")
    @Column()
    private String configFlowCode;

    /**
     * 状态
     */
    @Column(name = "state", columnDefinition = "int(11) comment '状态'")
    private Integer state;


    /**
     * 版本
     */
    @Comment("版本")
    @Column()
    private Long versionId;


    /**
     * 版本号
     */
    @Comment("版本号")
    @Column()
    private Integer versionNo;


    @Comment("有效关联id")
    @Column
    private Long effRelateId;

}

