package com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;


/**
 * @author : WWW
 * @date : 2024-1-23
 * @desc : 状态流
 */
@Entity
@Table(name = "pms_state_flow")
@org.hibernate.annotations.Table(appliesTo = "pms_state_flow", comment = "状态流")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class StateFlowDO extends BaseModel {


    /**
     * 名称
     */
    @Column(name = "name", columnDefinition = "varchar(255) comment '名称'")
    private String name;

    /**
     * 编码
     */
    @Column(name = "code", columnDefinition = "varchar(255) comment '编码'")
    private String code;

    /**
     * 进度百分比
     */
    @Comment("进度百分比")
    @Column
    private BigDecimal progressPercentage;

    /**
     * 状态
     */
    @Column(name = "state", columnDefinition = "int(11) comment '状态 1开始2进行中3已完成'")
    private Integer state;

    /**
     * 默认标志
     */
    @Column(name = "def_flag", columnDefinition = "tinyint(1) comment '默认标志'")
    private Boolean defFlag;

    /**
     * 字体颜色
     */
    @Column(name = "font_color", columnDefinition = "varchar(255) comment '字体颜色'")
    private String fontColor;

    /**
     * 背景色
     */
    @Column(name = "background_color", columnDefinition = "varchar(255) comment '背景色'")
    private String backgroundColor;

    /**
     * 阶段id
     */
    @Column(name = "stage_id", columnDefinition = "bigint(20) comment '阶段id'")
    private Long stageId;


    /**
     * 类型1需求2任务3缺陷
     */
    @Column(name = "type", columnDefinition = "int(11) comment '类型1需求2任务3缺陷'")
    private Integer type;

    /**
     * 关联单据主键
     */
    @ApiModelProperty("关联单据主键")
    private Long objId;

    /**
     * 排序
     */
    @Column(name = "sort", columnDefinition = "int(11) comment '排序'")
    private Integer sort;


    /**
     * 版本
     */
    @com.elitescloud.cloudt.common.annotation.Comment("版本")
    @Column()
    private Long versionId;


    /**
     * 版本号
     */
    @com.elitescloud.cloudt.common.annotation.Comment("版本号")
    @Column()
    private Integer versionNo;


    /**
     * 有效关联id
     */
    @com.elitescloud.cloudt.common.annotation.Comment("有效关联id")
    @Column
    private Long effRelateId;

}

