package com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;


/**
 * @author : WWW
 * @date : 2024-1-23
 * @desc : 状态流
 */
@Data
@ApiModel(description = "状态流")
public class StateFlowQuery extends TwQueryParam {


    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String name;

    /**
     * 编码
     */
    @ApiModelProperty("编码")
    private String code;

    /**
     * 进度百分比
     */
    private BigDecimal progressPercentage;

    /**
     * 状态
     */
    @ApiModelProperty("状态 1开始2进行中3已完成")
    private Integer state;

    /**
     * 默认标志
     */
    @ApiModelProperty("默认标志")
    private Boolean defFlag;

    /**
     * 字体颜色
     */
    @ApiModelProperty("字体颜色")
    private String fontColor;

    /**
     * 背景色
     */
    @ApiModelProperty("背景色")
    private String backgroundColor;

    /**
     * 阶段id
     */
    @ApiModelProperty("阶段id")
    private Long stageId;

    /**
     * 业务id
     */
    @ApiModelProperty("业务id")
    private Long businessId;

    /**
     * 类型1需求2任务3缺陷
     */
    @ApiModelProperty("类型1需求2任务3缺陷")
    private Integer type;

    /**
     * 关联单据主键
     */
    @ApiModelProperty("关联单据主键")
    private Long objId;


    /**
     * 版本
     */
    @ApiModelProperty("版本")
    private Long versionId;


    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;


    /**
     * 有效关联id
     */
    @ApiModelProperty("有效关联id")
    private Long effRelateId;
}

