package com.elitesland.tw.tw5.server.prd.pms.stateflow.service;


import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.PmsStateFlowVersionPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.PmsStateFlowVersionQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.PmsStateFlowVersionVO;


/**
 * 状态流版本表service
 *
 * @author wangxl
 * @date 2024/4/19
 */
public interface PmsStateFlowVersionService {

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<PagingVO<PmsStateFlowVersionVO>> queryPage(PmsStateFlowVersionQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<List<PmsStateFlowVersionVO>> queryList(PmsStateFlowVersionQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<Long> queryCount(PmsStateFlowVersionQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    TwOutputUtil<PmsStateFlowVersionVO> queryByKey(Long id);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsStateFlowVersionVO> insert(PmsStateFlowVersionPayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsStateFlowVersionVO> update(PmsStateFlowVersionPayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsStateFlowVersionVO> updateDynamic(PmsStateFlowVersionPayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    TwOutputUtil<Long> deleteSoft(List<Long> ids);

}