package com.elitesland.tw.tw5.server.prd.pms.stateflow.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.StateFlowConfigPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowConfigQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowConfigVO;

import java.util.List;


/**
  * @author : WWW
  * @date : 2024-1-23
  * @desc : 状态流转配置Service
  */
public interface StateFlowConfigService {
    
    /**
     * 新增状态流转配置数据
     * @param stateFlowConfigPayload
     * @return
     */
    StateFlowConfigVO save(StateFlowConfigPayload stateFlowConfigPayload);
    
    /**
     * 根据主键更新
     * @param stateFlowConfigPayload
     * @return
     */
    StateFlowConfigVO updateAll(StateFlowConfigPayload stateFlowConfigPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    StateFlowConfigVO get(Long id);
    
    /**
     * 分页查询列表
     * @param stateFlowConfigQuery
     * @return
     */
    PagingVO<StateFlowConfigVO> page(StateFlowConfigQuery stateFlowConfigQuery);
    
    /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
     * 获取列表查询
     * @param stateFlowConfigQuery
     * @return
     */
    List<StateFlowConfigVO> getList(StateFlowConfigQuery stateFlowConfigQuery);
    
    /**
     * 根据条件修改
     * @param stateFlowConfigPayload
     * @return
     */
    Long update(StateFlowConfigPayload stateFlowConfigPayload);

     /**
      * 根据flowId删除
      * @param res
      * @return
      */
     Boolean delByFlowId(Long res);
 }

