package com.elitesland.tw.tw5.server.prd.provacation.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.provacation.model.payload.ProVacationSettingPayload;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationSettingQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationSettingVO;
import com.elitesland.tw.tw5.server.prd.provacation.service.ProVacationSettingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author : duwh
 * @date : 2024-1-19
 * @desc : 项目假期设置
 */
@RestController
@RequestMapping("/api/proVacationSetting")
@RequiredArgsConstructor
@Api(value = "项目假期设置", tags = {"项目假期设置"})
public class ProVacationSettingController {

    private final ProVacationSettingService proVacationSettingService;

    @GetMapping("get")
    @ApiOperation("详情-项目假期设置")
    public TwOutputUtil<ProVacationSettingVO> get(Long id) {
        ProVacationSettingVO res = proVacationSettingService.get(id);
        return TwOutputUtil.ok(res);

    }

    @PostMapping("save")
    @ApiOperation("新增-项目假期设置")
    public TwOutputUtil<ProVacationSettingVO> save(@RequestBody ProVacationSettingPayload payload) {
        return TwOutputUtil.ok(proVacationSettingService.save(payload));

    }

    @PostMapping("update")
    @ApiOperation("修改-项目假期设置")
    public TwOutputUtil<Long> update(@RequestBody ProVacationSettingPayload proVacationPayload) {
        Long res = proVacationSettingService.update(proVacationPayload);
        return TwOutputUtil.ok(res);
    }

    @DeleteMapping("del")
    @ApiOperation("删除-项目假期设置")
    public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {
        Long res = proVacationSettingService.del(ids);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("/page")
    // @UdcNameClass
    @ApiOperation("分页查询-项目假期设置")
    public TwOutputUtil<PagingVO<ProVacationSettingVO>> page(ProVacationSettingQuery query) {
        PagingVO<ProVacationSettingVO> res = proVacationSettingService.page(query);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("getList")
    @ApiOperation("列表查询-项目假期设置")
    public TwOutputUtil<List<ProVacationSettingVO>> getList(ProVacationSettingQuery query) {
        List<ProVacationSettingVO> res = proVacationSettingService.getList(query);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("/{year}/{projectId}")
    @ApiOperation("年度-项目假期设置查询")
    public TwOutputUtil<ProVacationSettingVO> findVacationSetting(@PathVariable int year, @PathVariable Long projectId) {
        ProVacationSettingQuery query = new ProVacationSettingQuery();
        query.setYear(year);
        query.setProjectId(projectId);
        List<ProVacationSettingVO> list = proVacationSettingService.getList(query);
        if (!CollectionUtils.isEmpty(list)) {
            return TwOutputUtil.ok(list.get(0));
        }
        return TwOutputUtil.ok(null);
    }

}

