package com.elitesland.tw.tw5.server.prd.provacation.repo.dao;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.provacation.model.entity.QProVacationSettingDO;
import com.elitesland.tw.tw5.server.prd.provacation.model.payload.ProVacationSettingPayload;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationSettingQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationSettingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;


/**
 * @author : duwh
 * @date : 2024-1-24
 * @desc : 项目假期RepoProc
 */
@Repository
@RequiredArgsConstructor
public class ProVacationSettingDao  {
    private final JPAQueryFactory jpaQueryFactory;
    private  final QProVacationSettingDO qProVacationSettingDO = QProVacationSettingDO.proVacationSettingDO;

    public PagingVO<ProVacationSettingVO> page(ProVacationSettingQuery proVacationQuery) {
        JPAQuery<ProVacationSettingVO> query =
            select(ProVacationSettingVO.class)
                .where(bulidPredicate(proVacationQuery));
        proVacationQuery.setPaging(query);
        proVacationQuery.fillOrders(query, qProVacationSettingDO);
        return PagingVO.<ProVacationSettingVO>builder()
            .total(query.fetchCount())
            .records(query.fetch())
            .build();
    }

    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qProVacationSettingDO)
            .set(qProVacationSettingDO.deleteFlag, 1)
            .where(qProVacationSettingDO.id.in(ids))
            .execute();
        return res;
    }

    public ProVacationSettingVO get(Long id) {
        ProVacationSettingVO proVacationVO = select(ProVacationSettingVO.class)
            .where(qProVacationSettingDO.id.eq(id))
            .fetchOne();
        return proVacationVO;
    }

    public List<ProVacationSettingVO> getList(ProVacationSettingQuery proVacationQuery) {
        List<ProVacationSettingVO> res =
            select(ProVacationSettingVO.class)
                .where(bulidPredicate(proVacationQuery))
                .fetch();
        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
            jpaQueryFactory.select(Projections.bean(cls,
                qProVacationSettingDO.projectId,
                qProVacationSettingDO.workHours,
                qProVacationSettingDO.year,
                qProVacationSettingDO.id,
                qProVacationSettingDO.createTime,
                qProVacationSettingDO.remark

            )).from(qProVacationSettingDO);

    }


    private Predicate bulidPredicate(ProVacationSettingQuery proVacationQuery) {

        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
            .andEq(null != proVacationQuery.getProjectId(), qProVacationSettingDO.projectId, proVacationQuery.getProjectId())
            .andEq(null != proVacationQuery.getWorkHours(), qProVacationSettingDO.workHours, proVacationQuery.getWorkHours())
            .andEq(null != proVacationQuery.getYear(), qProVacationSettingDO.year, proVacationQuery.getYear())
            .build();

        return predicate;

    }


    private Predicate bulidPredicates(ProVacationSettingQuery proVacationQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 项目id
        if (null != proVacationQuery.getProjectId()) {
            predicates.add(qProVacationSettingDO.projectId.eq(proVacationQuery.getProjectId()));
        }
        // 工作小时数
        if (null != proVacationQuery.getWorkHours()) {
            predicates.add(qProVacationSettingDO.workHours.eq(proVacationQuery.getWorkHours()));
        }
        if (null != proVacationQuery.getYear()) {
            predicates.add(qProVacationSettingDO.year.eq(proVacationQuery.getYear()));
        }

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public Long count(ProVacationSettingQuery proVacationQuery) {
        long res = select(ProVacationSettingVO.class)
            .where(bulidPredicates(proVacationQuery))
            .fetchCount();
        return res;


    }

    public Long update(ProVacationSettingPayload proVacationPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qProVacationSettingDO);
        // 项目id
        if (null != proVacationPayload.getProjectId()) {
            update.set(qProVacationSettingDO.projectId, proVacationPayload.getProjectId());
        }
        // 工作小时数
        if (null != proVacationPayload.getWorkHours()) {
            update.set(qProVacationSettingDO.workHours, proVacationPayload.getWorkHours());
        }
        if (null != proVacationPayload.getYear()) {
            update.set(qProVacationSettingDO.year, proVacationPayload.getYear());
        }
        long res = update.where(qProVacationSettingDO.id.eq(proVacationPayload.getId()))
            .execute();
        return res;

    }


    public Long countByProjectId(Long projectId, Integer year) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
            .select(qProVacationSettingDO.count())
            .from(qProVacationSettingDO);
        jpaQuery.where(qProVacationSettingDO.projectId.eq(projectId),
            qProVacationSettingDO.year.eq(year));
        long total = jpaQuery.fetchOne();
        return total;
    }
}

