package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPlanPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.LatePaymentPlanQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementPaymentQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentPlanQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentPlanService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.LatePaymentPlanVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentPlanVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 采购合同管理-采购付款计划
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@Api(tags = "采购合同管理-采购付款计划")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/purchasePaymentPlan")
@Slf4j
public class PurchasePaymentPlanController {

    private final PurchasePaymentPlanService purchasePaymentPlanService;

    /**
     * 采购付款计划-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("采购付款计划-新增")
    public TwOutputUtil insert(@RequestBody PurchasePaymentPlanPayload payload){
        return TwOutputUtil.ok(purchasePaymentPlanService.insert(payload));
    }

    /**
     * 采购付款计划-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("采购付款计划-更新")
    public TwOutputUtil update(@RequestBody PurchasePaymentPlanPayload payload){
        return TwOutputUtil.ok(purchasePaymentPlanService.update(payload));
    }

    /**
     * 采购付款计划-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("采购付款计划-主键查询")
    public TwOutputUtil<PurchasePaymentPlanVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(purchasePaymentPlanService.queryByKey(key));
    }

    /**
     * 采购付款计划-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("采购付款计划-分页")
    public TwOutputUtil<PagingVO<PurchasePaymentPlanVO>> paging(PurchasePaymentPlanQuery query) {
        return TwOutputUtil.ok(purchasePaymentPlanService.queryPaging(query));
    }

    /**
     * 采购付款计划-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("采购付款计划-查询列表")
    public TwOutputUtil<List<PurchasePaymentPlanVO>> queryList(PurchasePaymentPlanQuery query) {
        return TwOutputUtil.ok(purchasePaymentPlanService.queryListDynamic(query));
    }

    /**
     * 采购付款计划-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("采购付款计划-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        purchasePaymentPlanService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
   }

    /**
     * 逾期付款计划
     * @param latePaymentPlanQuery 查询条件
     * @return 结果
     */
    @GetMapping("/findLatePaymentPlanList")
    @UdcNameClass
    @ApiOperation("采购付款计划-逾期付款计划表")
    public TwOutputUtil<PagingVO<LatePaymentPlanVO>> findLatePaymentPlanList(LatePaymentPlanQuery latePaymentPlanQuery) {
        return TwOutputUtil.ok(purchasePaymentPlanService.findLatePaymentPlanList(latePaymentPlanQuery));
    }

    /**
     * 根据采购协议编号查询付款明细
     * @param query 查询条件
     * @return 付款明细
     */
    @GetMapping("/findPlanListByAgreementNo")
    @UdcNameClass
    @ApiOperation("根据采购协议编号查询付款明细")
    public TwOutputUtil<PagingVO<PurchasePaymentPlanVO>> findPlanListByAgreementNo(PurchaseAgreementPaymentQuery query) {
        return TwOutputUtil.ok(purchasePaymentPlanService.findPlanListByAgreementNo(query));
    }

}
