package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerExportVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.SettleApplyDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.SettleApplyDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementResVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.SettleApplyDetailsVO;
import com.elitesland.tw.tw5.api.prd.purchase.service.SettleApplyDetailsService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 结算申请明细
 *
 * @folder 结算申请明细
 * @author wangly
 * @date 2024-08-21
 */
@Api(tags = "结算申请明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/settleApplyDetails")
@Slf4j
public class SettleApplyDetailsController {

private final SettleApplyDetailsService settleApplyDetailsService;
private final UdcUtil udcUtil;
    /**
     * 结算申请明细-新增
     *
     * @folder 结算申请明细
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("结算申请明细-新增")
    public TwOutputUtil<SettleApplyDetailsVO> insert(@RequestBody SettleApplyDetailsPayload payload){
         return TwOutputUtil.ok(settleApplyDetailsService.insert(payload));
    }

    /**
     * 结算申请明细-更新
     *
         * @folder 结算申请明细
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("结算申请明细-更新")
    public TwOutputUtil<SettleApplyDetailsVO> update(@RequestBody SettleApplyDetailsPayload payload){
        return TwOutputUtil.ok(settleApplyDetailsService.update(payload));
    }

    /**
     * 结算申请明细-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 结算申请明细
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("结算申请明细-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody SettleApplyDetailsPayload payload){
        return TwOutputUtil.ok(settleApplyDetailsService.updateByKeyDynamic(payload));
    }

    /**
     * 结算申请明细-主键查询
     *
     * @folder 结算申请明细
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("结算申请明细-主键查询")
    public TwOutputUtil<SettleApplyDetailsVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(settleApplyDetailsService.queryByKey(key));
    }

    /**
     * 结算申请明细-分页
     *
         * @folder 结算申请明细
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("结算申请明细-分页")
    public TwOutputUtil<PagingVO<SettleApplyDetailsVO>> paging(SettleApplyDetailsQuery query) {
        return TwOutputUtil.ok(settleApplyDetailsService.queryPaging(query));
    }

    /**
     * 结算申请明细-查询列表
     *
     * @folder 结算申请明细
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("结算申请明细-查询列表")
    public TwOutputUtil<List<SettleApplyDetailsVO>> queryList(SettleApplyDetailsQuery query) {
        return TwOutputUtil.ok(settleApplyDetailsService.queryListDynamic(query));
    }

    /**
     * 结算申请明细-删除
     *
         * @folder 结算申请明细
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("结算申请明细-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         settleApplyDetailsService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 结算申请-关联资源查询
     *
     * @folder 关联资源查询
     * @param userId 资源id
     * @param settleStartDate 结算开始日期
     * @param settleEndDate 结算结束日期
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryAssocationResoure")
    @ApiOperation("结算申请明细-关联资源查询")
    public TwOutputUtil<PurchaseAgreementResVO> queryAssocationResoure(Long userId, String settleStartDate, String settleEndDate){
        return TwOutputUtil.ok(settleApplyDetailsService.queryAssocationResoure(userId, TimeUtil.dateFromYmd(settleStartDate), TimeUtil.dateFromYmd(settleEndDate)));
    }

    /**
     * 结算申请-关联资源查询
     *
     * @folder 关联资源查询
     * @param userId 资源id
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryAssocationByResId")
    @ApiOperation("结算申请明细-关联资源查询")
    public TwOutputUtil queryAssocationByResId(Long userId){
        settleApplyDetailsService.queryAssocationByResId(userId);
        return TwOutputUtil.ok();
    }

    @GetMapping("/excelExport")
    @ApiOperation("结算申请明细-导出")
    public void excelExport(SettleApplyDetailsQuery query, HttpServletResponse response) throws IOException {

        //导出顺序是反的
//        OrderItem orderItem = OrderItem.asc("createTime");
//        query.defaultOrder(orderItem);
        //获取想要导出的数据
        List<SettleApplyDetailsVO> settleApplyDetailsVOS = settleApplyDetailsService.queryListDynamic(query);

        settleApplyDetailsVOS = udcUtil.translateList(settleApplyDetailsVOS);
        //定义文件名称
        String sheetName = "结算申请";
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
   //     response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName);
        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), SettleApplyDetailsVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        EasyExcel.write(response.getOutputStream(), SettleApplyDetailsVO.class).sheet(sheetName).doWrite(settleApplyDetailsVOS);

//        // 列
//        ExcelUtil.excelHelper(sheet, SettleApplyDetailsVO.class, null);
//        //写入
//        sheet.doWrite(settleApplyDetailsVOS);
    }


    @ApiOperation("批量导入excel")
    @PostMapping(value = "/batchImportPro", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public TwOutputUtil batchImportPro(MultipartFile file, Boolean force) throws IOException {
        settleApplyDetailsService.importBatchPro(file, force);
        return TwOutputUtil.ok();
    }

}

