package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 结算申请
 *
 * @author wangly
 * @date 2024-08-21
 */
@Entity
@Table(name = "settle_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "settle_apply", comment = "结算申请")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class SettleApplyDO extends BaseModel implements Serializable  {
    /** 结算单号 */
    @Comment("结算单号")
    @Column()
    private String settleNo;
    /** 结算单名称 */
    @Comment("结算单名称")
    @Column()
    private String settleName;
    /** 申请日期 */
    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;
    /** 申请人ID */
    @Comment("申请人ID")
    @Column()
    private Long applyUserId;
    /** 申请人部门ID */
    @Comment("申请人部门ID")
    @Column()
    private Long applyUserBuId;
    /** 单据状态 */
    @Comment("单据状态")
    @Column()
    private String status;
    /** 结算人天 */
    @Comment("结算人天")
    @Column()
    private Integer settleDays;
    /** 相关附件 */
    @Comment("相关附件")
    @Column()
    private String fileCodes;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;
    /** 扩展字段1 */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /** 扩展字段2 */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /** 扩展字段3 */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /** 扩展字4 */
    @Comment("扩展字4")
    @Column()
    private String ext4;
    /** 扩展字5 */
    @Comment("扩展字5")
    @Column()
    private String ext5;

    public void copy(SettleApplyDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
