package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 采购合同终止
 *
 * @author lemon
 * @date 2023-10-19
 */
@Entity
@Table(name = "t_purchase_contract_over", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_purchase_contract_over", comment = "采购合同终止")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TPurchaseContractOverDO extends BaseModel implements Serializable  {
    /** 合同终止编号 */
    @Comment("合同终止编号")
    @Column()
    private String overNo;
    /** 申请人资源ID */
    @Comment("申请人资源ID")
    @Column()
    private Long applyResId;
    /** 合同终止状态 */
    @Comment("合同终止状态")
    @Column()
    private String overStatus;
    /** 采购合同ID */
    @Comment("采购合同ID")
    @Column()
    private Long contractId;
    /** 采购合同编号 */
    @Comment("采购合同编号")
    @Column()
    private String contractNo;
    /** 终止原因 */
    @Comment("终止原因")
    @Column()
    private String overWhy;
    /** 终止日期 */
    @Comment("终止日期")
    @Column()
    private LocalDate overTime;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    public void copy(TPurchaseContractOverDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
