package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.BillVerDetailPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.BillVerDetailQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.BillVerDetailService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.BillVerDetailVO;
import com.elitesland.tw.tw5.server.prd.purchase.convert.BillVerDetailConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.BillVerDetailDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.BillVerDetailDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.BillVerDetailRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 预付款收据管理
 *
 * @author wangly
 * @date 2024-05-27
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BillVerDetailServiceImpl extends BaseServiceImpl implements BillVerDetailService {

    private final BillVerDetailRepo billVerDetailRepo;
    private final BillVerDetailDAO billVerDetailDAO;

    @Override
    public PagingVO<BillVerDetailVO> queryPaging(BillVerDetailQuery query){
        return billVerDetailDAO.queryPaging(query);
    }

    @Override
    public List<BillVerDetailVO> queryListDynamic(BillVerDetailQuery query){
        return billVerDetailDAO.queryListDynamic(query);
    }

    @Override
    public BillVerDetailVO queryByKey(Long key) {
        BillVerDetailDO entity = billVerDetailRepo.findById(key).orElseGet(BillVerDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BillVerDetailVO vo = BillVerDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BillVerDetailVO insert(BillVerDetailPayload payload) {
        BillVerDetailDO entityDo = BillVerDetailConvert.INSTANCE.toDo(payload);
        return BillVerDetailConvert.INSTANCE.toVo(billVerDetailRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BillVerDetailVO update(BillVerDetailPayload payload) {
        BillVerDetailDO entity = billVerDetailRepo.findById(payload.getId()).orElseGet(BillVerDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BillVerDetailDO entityDo = BillVerDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BillVerDetailConvert.INSTANCE.toVo(billVerDetailRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BillVerDetailPayload payload) {
        BillVerDetailDO entity = billVerDetailRepo.findById(payload.getId()).orElseGet(BillVerDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = billVerDetailDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            billVerDetailDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<BillVerDetailVO> queryListByPaymentApplyId(String docType, Long paymentApplyId) {
        return billVerDetailDAO.queryListByPaymentApplyId(docType, paymentApplyId);
    }

    @Override
    public List<BillVerDetailVO> queryListIsNullByPaymentApplyId(String docType, Long paymentApplyId) {
        return billVerDetailDAO.queryListIsNullByPaymentApplyId(docType, paymentApplyId);
    }

    @Override
    public void deleteByPaymentApplyId(Long paymentApplyId) {
        billVerDetailDAO.deleteByPaymentApplyId(paymentApplyId);
    }

    @Override
    public void insertAll(List<BillVerDetailPayload> billVerDetailPayloads) {
        billVerDetailRepo.saveAll(BillVerDetailConvert.INSTANCE.toDoList(billVerDetailPayloads));
    }


}
