package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.alibaba.excel.EasyExcel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPotentialCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPotentialCustomerQuery;
import com.elitesland.tw.tw5.api.prd.prj.payload.PrjProjectPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.SettleApplyPayload;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementResVO;
import com.elitesland.tw.tw5.server.common.ExcelEntityDataListener;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPotentialCustomerDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.SettleApplyCoopWayEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.SettleApplyDetailsRepo;
import com.elitesland.tw.tw5.server.prd.purchase.dao.SettleApplyDetailsDAO;
import com.elitesland.tw.tw5.server.prd.purchase.convert.SettleApplyDetailsConvert;
import com.elitesland.tw.tw5.api.prd.purchase.service.SettleApplyDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.payload.SettleApplyDetailsPayload;
import com.elitesland.tw.tw5.server.prd.purchase.entity.SettleApplyDetailsDO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.SettleApplyDetailsVO;
import com.elitesland.tw.tw5.api.prd.purchase.query.SettleApplyDetailsQuery;
import com.elitesland.tw.tw5.server.prd.purchase.convert.SettleApplyDetailsConvert;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * 结算申请明细
 *
 * @author wangly
 * @date 2024-08-21
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SettleApplyDetailsServiceImpl extends BaseServiceImpl implements SettleApplyDetailsService {

    private final SettleApplyDetailsRepo settleApplyDetailsRepo;
    private final SettleApplyDetailsDAO settleApplyDetailsDAO;

    @Override
    public PagingVO<SettleApplyDetailsVO> queryPaging(SettleApplyDetailsQuery query){
        return settleApplyDetailsDAO.queryPaging(query);
    }

    @Override
    public List<SettleApplyDetailsVO> queryListDynamic(SettleApplyDetailsQuery query){
        return settleApplyDetailsDAO.queryListDynamic(query);
    }

    @Override
    public SettleApplyDetailsVO queryByKey(Long key) {
        SettleApplyDetailsDO entity = settleApplyDetailsRepo.findById(key).orElseGet(SettleApplyDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        SettleApplyDetailsVO vo = SettleApplyDetailsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SettleApplyDetailsVO insert(SettleApplyDetailsPayload payload) {
        SettleApplyDetailsDO entityDo = SettleApplyDetailsConvert.INSTANCE.toDo(payload);
        return SettleApplyDetailsConvert.INSTANCE.toVo(settleApplyDetailsRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SettleApplyDetailsVO update(SettleApplyDetailsPayload payload) {
        SettleApplyDetailsDO entity = settleApplyDetailsRepo.findById(payload.getId()).orElseGet(SettleApplyDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        SettleApplyDetailsDO entityDo = SettleApplyDetailsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SettleApplyDetailsConvert.INSTANCE.toVo(settleApplyDetailsRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(SettleApplyDetailsPayload payload) {
        SettleApplyDetailsDO entity = settleApplyDetailsRepo.findById(payload.getId()).orElseGet(SettleApplyDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = settleApplyDetailsDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            settleApplyDetailsDAO.deleteSoft(keys);
        }
    }

    @Override
    public PurchaseAgreementResVO queryAssocationResoure(Long userId, LocalDate settleStartDate, LocalDate settleEndDate) {
        PurchaseAgreementResVO purchaseAgreementResVO = settleApplyDetailsDAO.queryAssocationResoure(userId, settleStartDate, settleEndDate);
        /** 结算资源：选择的资源未关联激活的外部专家资源外包采购协议，提示：“该资源未关联采购协议”
         *  结算开始~结束日期：选择后，校验证1，当前结算资源+结算开始结束日期是否匹配到激活的外部专家资源外包采购协议-关联资源的资源日期之内，否提示：当前结算资源结算日期不在结算范围日期内！
         *  结算开始~结束日期：选择后，校验证2，当前结算资源+结算开始结束日期是否在历史结算记录范围内(含审批中、已审批结算单)，否，提示：“当前资源结算周期已发起过结算申请单，单号：“EV20240102002”
         *  结算开始~结束日期：选择后，校验证3，结算资源，合作方式属于打包结算只允许在关联资源服务周期内结算1次，否提示：“当前结算资源属于打包结算，已发起过结算申请单，单号“EV20240102001”
         */
        if(purchaseAgreementResVO==null){
           throw TwException.error("","当前结算资源结算日期不在结算范围日期内！");
        }
        String cooperationWay = purchaseAgreementResVO.getCooperationWay();
        SettleApplyDetailsQuery query = new SettleApplyDetailsQuery();
        query.setCoopWay(cooperationWay);
        query.setPurchaseAgreementId(purchaseAgreementResVO.getDocumentId());
        query.setSettleResId(userId);
        query.setPurchaseAgreementResId(purchaseAgreementResVO.getId());
        List<SettleApplyDetailsVO> settleApplyDetailsVOS = settleApplyDetailsDAO.queryListDynamic(query);
        if(!CollectionUtils.isEmpty(settleApplyDetailsVOS)){
            if(SettleApplyCoopWayEnum.demand_settlement.getCode().equals(cooperationWay)){
                settleApplyDetailsVOS.stream().forEach(p->{
                   Boolean flag =  hasOverlap(settleStartDate,settleEndDate,p.getStartDate(),p.getEndDate());
                   if(flag){
                       throw TwException.error("","当前资源结算周期已发起过结算申请单，单号:"+p.getSettleNo());
                   }
                });
            }else{
                throw TwException.error("","当前结算资源属于打包结算，已发起过结算申请单，单号:"+settleApplyDetailsVOS.get(0).getSettleNo());
            }
        }
        return  purchaseAgreementResVO;
    }

    @Override
    public void queryAssocationByResId(Long userId) {
        PurchaseAgreementResVO purchaseAgreementResVO = settleApplyDetailsDAO.queryAssocationResoure(userId,null,null);
        if(purchaseAgreementResVO==null){
            throw TwException.error("","该资源未关联采购协议");
        }
    }

    /**
     * 判断两个日期区间是否有重叠部分。
     *
     * @param start1 第一个区间的开始日期
     * @param end1   第一个区间的结束日期
     * @param start2 第二个区间的开始日期
     * @param end2   第二个区间的结束日期
     * @return 如果两个区间有重叠返回true，否则返回false
     */
    public  boolean hasOverlap(LocalDate start1, LocalDate end1, LocalDate start2, LocalDate end2) {
        // 检查第一个区间的开始日期是否在第二个区间内
        if (start1.isBefore(end2) && end1.isAfter(start2)) {
            return true;
        }
        // 检查第二个区间的开始日期是否在第一个区间内
        if (start2.isBefore(end1) && end2.isAfter(start1)) {
            return true;
        }
        // 如果以上条件都不满足，则没有重叠
        return false;
    }
    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public void importBatchPro(MultipartFile file, Boolean force) throws IOException {
        if (file == null) {
            throw TwException.error("", "上传文件异常");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create(file.getInputStream());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "文件解析异常");
        }
        Sheet sheet = workbook.getSheet("结算申请");
        if (sheet == null) {
            throw TwException.error("", "表结构错误");
        }
        int dataStartRow = 1;
        List<SettleApplyDetailsPayload> detailsPayloadList = new ArrayList<>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); i++) {
            Row row = sheet.getRow(i);
            SettleApplyDetailsPayload detailsPayload = new SettleApplyDetailsPayload();
            String id = ExcelUtil.getCellFormatValue(row.getCell(0));
            if(!StringUtils.hasText(id)){
               throw TwException.error("","第"+i+"行id不能为空");
            }
            detailsPayload.setId(Long.valueOf(id));
            String payTime = ExcelUtil.getCellFormatValue(row.getCell(20));
            String paymentAmt = ExcelUtil.getCellFormatValue(row.getCell(21));
            String paymentStatus = ExcelUtil.getCellFormatValue(row.getCell(22));
            if(!StringUtils.hasText(payTime) && !StringUtils.hasText(paymentStatus) &&!StringUtils.hasText(paymentAmt) ){
                continue;
            }
            // 付款时间
            if (StringUtils.hasText(payTime)) {
                try {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                    LocalDate parse = LocalDate.parse(payTime,formatter);
                    detailsPayload.setPayTime(parse);
                } catch (Exception e) {
                    throw TwException.error("","第"+i+"行付款时间格式错误,应为2020-01-01");
                }
            }
            // 付款状态
            detailsPayload.setPayStatus(paymentStatus);
            // 付款金额
            if (StringUtils.hasText(paymentAmt)) {
                try {
                    detailsPayload.setPayAmt(new BigDecimal(paymentAmt));
                } catch (Exception e) {
                    throw TwException.error("","第"+i+"行付款金额格式错误");

                }
            }
            detailsPayloadList.add(detailsPayload);
        }
        detailsPayloadList.stream().forEach(p->{
            updateByKeyDynamic(p);
        });
    }


}
