package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConEpibolyCostConPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConEpibolyCostConQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConEpibolyCostConService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 外包费用确认单
 *
 * @author likunpeng
 * @date 2023-04-17
 */
@Api(tags = "外包费用确认单")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/contract/conEpibolyCostCon")
@Slf4j
public class ConEpibolyCostConController {

    private final ConEpibolyCostConService conEpibolyCostConService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody ConEpibolyCostConPayload payload){
        return TwOutputUtil.ok(conEpibolyCostConService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody ConEpibolyCostConPayload payload){
        return TwOutputUtil.ok(conEpibolyCostConService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conEpibolyCostConService.queryByKey(key));
    }

    /**
     * 通过明细id查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryOneByCostDId/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByCostDId(@PathVariable Long key) {
        return TwOutputUtil.ok(conEpibolyCostConService.queryOneByCostDId(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ConEpibolyCostConQuery query) {
        return TwOutputUtil.ok(conEpibolyCostConService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ConEpibolyCostConQuery query) {
        return TwOutputUtil.ok(conEpibolyCostConService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        conEpibolyCostConService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 根据合同ID查询外包费用确认单
     * @param contractId
     * @return result
     */
    @GetMapping("/epiboly/{contractId}")
    @UdcNameClass
    @ApiOperation("根据合同ID查询外包费用确认单")
    public TwOutputUtil queryByContractId(@PathVariable Long contractId) {
        return TwOutputUtil.ok(conEpibolyCostConService.queryByContractId(contractId));
    }
}
