package com.elitesland.tw.tw5.server.prd.salecon.dao;


import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingMonthPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingMonthQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingMonthVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingMonthDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConInvSettingMonthDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvSettingMonthRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * ConInvSettingMonthController
 *
 * @author zoey
 * @date 2024-03-14
 */
@Repository
@RequiredArgsConstructor
public class ConInvSettingMonthDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final ConInvSettingMonthRepo repo;
    private final QConInvSettingMonthDO qdo = QConInvSettingMonthDO.conInvSettingMonthDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ConInvSettingMonthVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ConInvSettingMonthVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 开票月份
                qdo.invMonth,
                // 开票额度
                qdo.invLimit,
                // 预警值
                qdo.warnPercent,
                // 配置主表id
                qdo.invSettingId
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ConInvSettingMonthVO> getJpaQueryWhere(ConInvSettingMonthQuery query) {
        JPAQuery<ConInvSettingMonthVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ConInvSettingMonthQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(ConInvSettingMonthQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 开票月份 精确 */
        if (!ObjectUtils.isEmpty(query.getInvMonth())) {
            list.add(qdo.invMonth.eq(query.getInvMonth()));
        }
        /** 开票额度 精确 */
        if (!ObjectUtils.isEmpty(query.getInvLimit())) {
            list.add(qdo.invLimit.eq(query.getInvLimit()));
        }
        /** 预警值 精确 */
        if (!ObjectUtils.isEmpty(query.getWarnPercent())) {
            list.add(qdo.warnPercent.eq(query.getWarnPercent()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ConInvSettingMonthVO queryByKey(Long id) {
        JPAQuery<ConInvSettingMonthVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<ConInvSettingMonthVO> queryListDynamic(ConInvSettingMonthQuery query) {
        JPAQuery<ConInvSettingMonthVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ConInvSettingMonthVO> queryPaging(ConInvSettingMonthQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<ConInvSettingMonthVO> jpaQuery = getJpaQueryWhere(query);
        List<ConInvSettingMonthVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ConInvSettingMonthVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ConInvSettingMonthDO save(ConInvSettingMonthDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ConInvSettingMonthDO> saveAll(List<ConInvSettingMonthDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ConInvSettingMonthPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 开票月份
        if (payload.getInvMonth() != null) {
            update.set(qdo.invMonth, payload.getInvMonth());
        }
        // 开票额度
        if (payload.getInvLimit() != null) {
            update.set(qdo.invLimit, payload.getInvLimit());
        }
        // 预警值
        if (payload.getWarnPercent() != null) {
            update.set(qdo.warnPercent, payload.getWarnPercent());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 开票月份
            if (nullFields.contains("invMonth")) {
                update.setNull(qdo.invMonth);
            }
            // 开票额度
            if (nullFields.contains("invLimit")) {
                update.setNull(qdo.invLimit);
            }
            // 预警值
            if (nullFields.contains("warnPercent")) {
                update.setNull(qdo.warnPercent);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

