package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 外包费用确认明细
 *
 * @author likunpeng
 * @date 2023-04-17
 */
@Entity
@Table(name = "con_epiboly_cost_con_d", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_epiboly_cost_con_d", comment = "外包费用确认明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConEpibolyCostConDDO extends BaseModel implements Serializable  {
    /** 外包费用确认单ID */
    @Comment("外包费用确认单ID")
    @Column()
    private Long epibolyCostConId;
    /** 工作类型 */
    @Comment("工作类型")
    @Column()
    private String workType;
    /** 具体理由 */
    @Comment("具体理由")
    @Column()
    private String reason;
    /** 伙伴类型 */
    @Comment("伙伴类型")
    @Column()
    private String partnerType;
    /** 合作方 */
    @Comment("合作方")
    @Column()
    private String collaborator;
    /** 基于 */
    @Comment("基于")
    @Column()
    private String base;
    /** 比例 */
    @Comment("比例")
    @Column()
    private Integer proportion;
    /** 金额 */
    @Comment("金额")
    @Column()
    private BigDecimal amt;
    /** 税费率 */
    @Comment("税费率")
    @Column()
    private BigDecimal taxRate;
    /** 税费 */
    @Comment("税费")
    @Column()
    private BigDecimal taxCost;
    /** 税费承担方 */
    @Comment("税费承担方")
    @Column()
    private String taxPayer;
    /** 净支付额 */
    @Comment("净支付额")
    @Column()
    private BigDecimal netPay;
    /** 具体支付方式 */
    @Comment("具体支付方式")
    @Column()
    private String paymentMethod;
    /** 收款节点 */
    @Comment("收款节点")
    @Column()
    private String receStage;
    /** 线下合同&沟通签署状态 */
    @Comment("线下合同&沟通签署状态")
    @Column()
    private String contractStatus;
    /** 联系人姓名 */
    @Comment("联系人姓名")
    @Column()
    private String liaisonName;
    /** 联系电话 */
    @Comment("联系电话")
    @Column()
    private String liaisonPhone;
    /** 关联单据类型 */
    @Comment("关联单据类型")
    @Column()
    private String docType;
    /** 关联单据号 */
    @Comment("关联单据号")
    @Column()
    private String documentNumber;
    /** 明细状态 */
    @Comment("明细状态")
    @Column()
    private String detailedStatus;
    /** 父明细 */
    @Comment("父明细")
    @Column()
    private Long parentId;

    /** 4.0id */
    @Comment("4.0id")
    @Column()
    private Long costCondIdV4;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    public void copy(ConEpibolyCostConDDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
