package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 收款计划确认单
 *
 * @author lemon
 * @date 2023-12-23
 */
@Entity
@Table(name = "con_receivable_plan_confirm", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_receivable_plan_confirm", comment = "收款计划确认单")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConReceivablePlanConfirmDO extends BaseModel implements Serializable  {
    /** 确认单编号 */
    @Comment("确认单编号")
    @Column()
    private String confirmNo;
    /** 合同ID */
    @Comment("合同ID")
    @Column()
    private Long contractId;
    /** 关联收款计划ID */
    @Comment("关联收款计划ID")
    @Column()
    private Long recePlanId;
    /** 收款计划编号-收款号 */
    @Comment("收款计划编号-收款号")
    @Column()
    private String receNo;
    /** 预付款计划-预计收款日期 */
    @Comment("预付款计划-预计收款日期")
    @Column()
    private LocalDate expectReceDate;
    /** 提示类型备用 */
    @Comment("提示类型备用")
    @Column()
    private String tipsType;
    /** 提示信息 */
    @Comment("提示信息")
    @Column()
    private String tips;
    /** 销售负责人修改原因 */
    @Comment("销售负责人修改原因")
    @Column()
    private String salesRemark;
    /** 项目经理修改原因 */
    @Comment("项目经理修改原因")
    @Column()
    private String pmRemark;
    /** 预计收款日期调整 */
    @Comment("预计收款日期调整")
    @Column()
    private LocalDate adjExpectReceDate;
    /** 由项目经理确认 0 不需要 1需要 */
    @Comment("由项目经理确认 0 不需要 1需要")
    @Column()
    private Integer pmConfirm;
    /** 已付款由财务确认 0不需要 1需要 */
    @Comment("已付款由财务确认 0不需要 1需要")
    @Column()
    private Integer financeConfirm;
    /** 是否发送催款函 0 不需要 1需要 */
    @Comment("是否发送催款函 0 不需要 1需要")
    @Column()
    private Integer sendPaymentRequest;
    /** 预计收款日期确认无误？ 0 否 1是 */
    @Comment("预计收款日期确认无误？ 0 否 1是")
    @Column()
    private Integer receDateConfirm;
    /** 申请状态 */
    @Comment("申请状态")
    @Column()
    private String applyStatus;
    /** 申请人用户ID */
    @Comment("申请人用户ID")
    @Column()
    private Long applyUserId;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    public void copy(ConReceivablePlanConfirmDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
