package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 合同模板
 *
 * @author likunpeng
 * @date 2023-04-17
 */
@Entity
@Table(name = "con_template", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_template", comment = "合同模板")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConTemplateDO extends BaseModel implements Serializable  {
    /** 模板名称 */
    @Comment("模板名称")
    @Column()
    private String name;
    /** 合同类型 */
    @Comment("合同类型")
    @Column()
    private String conType;
    /** 是否标准模板 */
    @Comment("是否标准模板")
    @Column()
    private Integer standardTemp;
    /** 模板描述 */
    @Comment("模板描述")
    @Column()
    private String tempDesc;
    /** 附件 */
    @Comment("附件")
    @Column()
    private String fileCodes;

    public void copy(ConTemplateDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
