package com.elitesland.tw.tw5.server.prd.salecon.repo;

import com.elitesland.tw.tw5.server.prd.salecon.entity.ConPurchaseDemandDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivablePlanDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购需求处理
 *
 * @author likunpeng
 * @date 2023-03-29
 */
public interface ConPurchaseDemandRepo extends JpaRepository<ConPurchaseDemandDO, Long>, JpaSpecificationExecutor<ConPurchaseDemandDO> {

    @Query(value = " select * from con_purchase_demand e where e.modify_time >= ?1  ", nativeQuery = true)
    List<ConPurchaseDemandDO> findByModifyTimeStart(String format);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update con_purchase_demand set modify_time=now() where id=?1",nativeQuery = true)
    @Modifying
    void updateRemark(Long id);
}
