package com.elitesland.tw.tw5.server.prd.salecon.repo;

import com.elitesland.tw.tw5.server.prd.salecon.entity.SaleConContractDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

/**
 * 销售合同
 *
 * @author danting
 * @date 2023-03-23
 */
public interface SaleConContractRepo extends JpaRepository<SaleConContractDO, Long>, JpaSpecificationExecutor<SaleConContractDO> {
    //查询主合同下所有子合同（包括已经被删除的）--- 用来向前端展示子合同的code
    List<SaleConContractDO> findByParentId(Long parentId);

    @Query(value = " select * from sale_con_contract e where e.modify_time >= ?1 ", nativeQuery = true)
//            " and ((e.plat_type = 'NO_CONTRACT_VIRTUAL_CONTRACT' and e.status='ACTIVE_WAITING') or (e.plat_type != 'NO_CONTRACT_VIRTUAL_CONTRACT' and e.status='ACTIVE' )) ", nativeQuery = true)
    List<SaleConContractDO> findByModifyTimeStart(String format);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update sale_con_contract set modify_time=now()  where id=?1",nativeQuery = true)
    @Modifying
    void updateRemark(Long id);

    @Query(value = "select contract_idv4 from sale_con_contract where contract_idv4 IN ?1 ",nativeQuery = true)
    List<Long> findByContractIdV4(List<Long> id);

    @Query(value = "select * from sale_con_contract where id = ?1 ",nativeQuery = true)
    SaleConContractDO findContractById(Long id);

    @Query(value = " update sale_con_contract t1 , sale_con_contract te set t1.parent_id = te.id  WHERE t1.parent_id=te.contract_idv4 AND t1.contract_idv4 is not null and te.contract_idv4 is not null ",nativeQuery = true)
    @Modifying
    void updateParentId();

    @Query(value = " update sale_con_contract t1 , sale_con_contract te set t1.related_contract_id = te.id  WHERE t1.related_contract_id=te.contract_idv4 AND t1.contract_idv4 is not null and te.contract_idv4 is not null ",nativeQuery = true)
    @Modifying
    void updateRelatId();

    /**
     * 查询主合同列表下所有子合同
     * @param deleteFlag
     * @param parentsId
     * @return List<SaleConContractDO>
     */
    List<SaleConContractDO> findByDeleteFlagAndParentIdIn(Integer deleteFlag,List<Long> parentsId);

    /**
     * 查询合同的公司id
     * @param id
     * @return
     */
//    @Query(value = "select ouId from SaleConContractDO where id = ?1 ")
//    Long findConOuId(Long id);
    @Query(value = "select ouBookId from SaleConContractDO where id = ?1 ")
    Long findConOuId(Long id);

    /**
     * 根据code 查询销售合同
     * @param deleteFlag 删除标志
     * @param code 合同编号
     * @return SaleConContractDO
     */
    Optional<SaleConContractDO> findByDeleteFlagAndCode(Integer deleteFlag, String code);

    @Query(value = " select jde_bu_no from tw_jde_bu e where e.tw_bu_no = ?1  ", nativeQuery = true)
    String findJdeBuNo(String twBuNo);
}
