package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConAchieveDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConAchievePayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConContractPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConAchieveQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConAchieveService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConAchieveDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConAchieveVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.constants.ConAchieveTypeEnum;
import com.elitesland.tw.tw5.server.common.crontask.payload.TwContractAchieveAllInfoEntity;
import com.elitesland.tw.tw5.server.common.crontask.payload.TwContractAchieveEntity;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConAchieveConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConAchieveDConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.SaleConContractConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConAchieveDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConAchieveDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConAchieveDDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConAchieveDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.SaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConAchieveDRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConAchieveRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 业绩统计
 *
 * @author likunpeng
 * @date 2023-04-24
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConAchieveServiceImpl extends BaseServiceImpl implements ConAchieveService {

    private final ConAchieveRepo conAchieveRepo;
    private final ConAchieveDAO conAchieveDAO;
    private final ConAchieveDDAO conAchieveDDAO;
    private final ConAchieveDRepo conAchieveDRepo;
    @Autowired
    private final SaleConContractService saleConContractService;
    private final SaleConContractRepo saleConContractRepo;
    private final SaleConContractDAO saleConContractDAO;

    private final HttpUtil httpUtil;
    private final PrdOrgSyncLogDAO daoLog;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService orgService;

    public static final String SIGN = "SIGN"; //签单
    private static final String CO = "CO";    //副签单
    public static final String DELI = "DELI";    //交付
    private static final String CODELI = "CODELI";    //副交付
    public static final String PRE_SALE = "PRE_SALE";    //售前

//    @Value("${tw4.url}")
//    private String tw4_url;
//
//    @Value("${tw4.sale.contractAchieve}")
//    private String contractAchieve;

    @Override
    public PagingVO<ConAchieveVO> queryPaging(ConAchieveQuery query) {
        return conAchieveDAO.queryPaging(query);
    }

    @Override
    public List<ConAchieveVO> queryListDynamic(ConAchieveQuery query) {
        return conAchieveDAO.queryListDynamic(query);
    }

    @Override
    public ConAchieveVO queryByKey(Long key) {
        ConAchieveDO entity = conAchieveRepo.findById(key).orElseGet(ConAchieveDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConAchieveVO vo = ConAchieveConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConAchieveVO insert(ConAchievePayload payload) {
        ConAchieveDO entityDo = ConAchieveConvert.INSTANCE.toDo(payload);
        return ConAchieveConvert.INSTANCE.toVo(conAchieveRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConAchieveVO update(ConAchievePayload payload) {
        ConAchieveDO entity = conAchieveRepo.findById(payload.getId()).orElseGet(ConAchieveDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConAchieveDO entityDo = ConAchieveConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConAchieveConvert.INSTANCE.toVo(conAchieveRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conAchieveDAO.deleteSoft(keys);
        }
    }

    @Override
    public ConAchieveVO queryByContractId(Long contractId) {
        ConAchieveVO vo = conAchieveDAO.queryByContractId(contractId);
        if (vo == null) {
            return null;
        }
        List<ConAchieveDVO> dvos = conAchieveDDAO.queryByAchieveId(vo.getId());
        vo.setConAchieveDVOS(dvos);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConAchieveVO saveAchieve(ConAchievePayload payload) {
        if (payload.getId() == null) {
            payload.setAchieveStatus("unhandled");
        } else {
            payload.setAchieveStatus("handled");
        }
        BigDecimal amt = payload.getAmt() == null ? BigDecimal.ZERO : payload.getAmt(); //修改后的合同总金额
        ConAchieveDO save = conAchieveRepo.save(ConAchieveConvert.INSTANCE.toDo(payload));
        SaleConContractVO saleConContractVO = saleConContractService.queryByKey(payload.getContractId());
        SaleConContractPayload contractPayload = SaleConContractConvert.INSTANCE.toPayload(saleConContractVO);
        contractPayload.setAmt(amt);    //赋值给payload用以计算有效合同金额
        SaleConContractPayload saleConContractPayload = saleConContractService.subAmtCount(contractPayload);
        //有效合同金额
        BigDecimal effectiveAmt = saleConContractPayload.getEffectiveAmt();
        //修改合同签单额和有效合同金额
        conAchieveDAO.updateConAmt(amt, effectiveAmt, payload.getContractId());
        List<ConAchieveDPayload> conAchieveDPayloads = payload.getConAchieveDPayloads();
        if (conAchieveDPayloads != null) {
            for (ConAchieveDPayload conAchieveDPayload : conAchieveDPayloads) {
                ConAchieveDDO subDo = ConAchieveDConvert.INSTANCE.toDo(conAchieveDPayload);
                //根据分配比例计算金额
//                BigDecimal conAmt = payload.getAmt() == null ? BigDecimal.ZERO : payload.getAmt();
//                int ratioInt = Integer.parseInt(conAchieveDPayload.getRatio());
//                BigDecimal ratio = BigDecimal.valueOf((float)ratioInt / 100);
//                BigDecimal subAmt = conAmt.multiply(ratio);
//                subDo.setAmt(conAchieveDPayload.getAmt());
                subDo.setAchieveId(save.getId());
                conAchieveDDAO.save(subDo);
            }
        }
        return ConAchieveConvert.INSTANCE.toVo(save);
    }

    @Override
    public void syncConAchieveTo4(String param) {
        String syncType = "con_achieve_to4";
        LocalDateTime syncTime;
        if (StringUtils.hasText(param)) {
            syncTime = LocalDateTime.parse(param);
        } else {
            syncTime = daoLog.queryOrgSyncLog(syncType);
            if (syncTime == null) {
                syncTime = LocalDateTime.of(2023, 7, 1, 0, 0);
            } else {
                //将同步时间提前10秒，防止拉数据遗漏
                syncTime = syncTime.minusSeconds(120);
            }
        }
        XxlJobLogger.log("业绩统计同步到4.0开始...");
        XxlJobLogger.log("syncConAchieveTo4 localDateTime：" + syncTime);

        // 查询待同步数据
        String format = DateUtil.format(syncTime, "yyyy-MM-dd HH:mm:ss");
        List<ConAchieveDO> querySyncDatas = conAchieveRepo.findByModifyTimeStart(format);

        // 同步内容
        String syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(querySyncDatas)) {
            Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            // 组装同步的数据
            List<TwContractAchieveAllInfoEntity> copy = new ArrayList<>();
            for (ConAchieveDO tempDo : querySyncDatas) {
                TwContractAchieveAllInfoEntity e = new TwContractAchieveAllInfoEntity();
                e.setAchieveIdV5(tempDo.getId());
                // 查询需求明细表
                List<ConAchieveDDO> conAchieveDVOS = conAchieveDRepo.findConAchieveByAchieveId(tempDo.getId());
                if (!ObjectUtils.isEmpty(conAchieveDVOS)) {
                    // 明细表
                    List<TwContractAchieveEntity> detail = new ArrayList<>();
                    conAchieveDVOS.stream().forEach(item -> {
                        TwContractAchieveEntity view = new TwContractAchieveEntity();
                        if (tempDo.getContractId() != null) {
                            view.setContractId(tempDo.getContractId().intValue());
                        }
                        view.setAchieveIdV5(item.getId());
                        view.setBuType(item.getBuType());
                        if (v4AndV5OrgIds.get(item.getBuId()) != null) {
                            view.setBuId(v4AndV5OrgIds.get(item.getBuId()).intValue());
                        }
                        view.setCountType(item.getAchieveType());
                        if (v4AndV5UserIds.get(item.getChargeResId()) != null) {
                            view.setChargeResId(v4AndV5UserIds.get(item.getChargeResId()).intValue());
                        }
                        view.setRatio(item.getRatio());
                        view.setAmt(item.getAmt());
                        view.setAchieveIdV4(item.getAchievedIdV4());
                        view.setRemark(item.getRemark());
                        view.setDelFlag(item.getDeleteFlag());
                        view.setValueRole(item.getValueRole());
                        detail.add(view);
                    });
                    e.setDetail(detail);
                }
                // 查询合同
                SaleConContractDO saleConContractVO = saleConContractRepo.findContractById(tempDo.getContractId());
                if (saleConContractVO != null) {
                    e.setContractId(tempDo.getContractId());
                    e.setAchieveStatus(tempDo.getAchieveStatus());
                    e.setObversionedEffectiveAmt(tempDo.getObversionEffectiveAmt());
                }
                copy.add(e);
            }

            // 循环调用同步新增接口
            if (!ObjectUtils.isEmpty(copy)) {
                int failNum = 0;
                for (TwContractAchieveAllInfoEntity temDo : copy) {
                    LocalDateTime syncStartTime = LocalDateTime.now();
                    try {
                        Map<String, Object> map = BeanUtil.beanToMap(temDo);
//                        String resultMain = httpUtil.sendPost(tw4_url + contractAchieve, map);
//                        Map<String, Object> data = (Map) JSON.parse(resultMain);
                        Map<String, Object> data = new HashMap<>();
                        if (!(data.get("ok") + "").equals("true")) {
                            throw new Exception();
                        }
                    } catch (Exception e) {
                        XxlJobLogger.log("业绩统计" + temDo.getAchieveIdV5() + "同步异常......" + e);
                        LocalDateTime syncEndTime = LocalDateTime.now();
                        this.saveSyncLog(syncType + "_exception", "业绩统计id" + temDo.getAchieveIdV5() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + e, null);
                        failNum++;
                        //更新该条合同的更新时间，下一次处理;
                        conAchieveRepo.updateRemark(temDo.getAchieveIdV5());
                    }
                }
                syncData = "更新了" + (copy.size() - failNum) + "数据,有" + failNum + "条数据更新失败！";
            } else {
                syncData = "业绩统计数据未变化";
            }
        } else {
            syncData = "业绩统计数据未变化";
        }
        // 记录同步日志
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, syncData, syncNow);
        XxlJobLogger.log("同步业绩统计结束..." + logDO);
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        return logDO;
    }

    @Override
    public List<ConAchieveDVO> initSignAndDeli(Long contractId) {
        List<ConAchieveDVO> result = new ArrayList<>();
        SaleConContractVO saleConContractVO = saleConContractDAO.queryByKey(contractId);
        if (saleConContractVO == null) {
            return result;
        }
        //签单BU、销售负责人
        Long signBuId = saleConContractVO.getSignBuId();
        if (signBuId != null) {
            ConAchieveDVO view = new ConAchieveDVO();
            view.setBuId(signBuId);
            view.setAchieveType(SIGN); //签单
            view.setChargeResId(saleConContractVO.getSaleManUserId());
            Integer number = new Random().nextInt(900000) + 100000;
            view.setId(System.currentTimeMillis() + number);
            result.add(view);
        }

        //副签单BU和副签单负责人
        SaleConContractVO parentCon = saleConContractDAO.queryByKey(saleConContractVO.getParentId());
        if (parentCon != null) {
            Long coSignBuId = parentCon.getCoSignBuId();
            if (coSignBuId != null) {
                ConAchieveDVO view = new ConAchieveDVO();
                view.setBuId(coSignBuId);
                view.setAchieveType(CO); //副签单
                view.setChargeResId(parentCon.getCoSignUserId());
                Integer number = new Random().nextInt(900000) + 100000;
                view.setId(System.currentTimeMillis() + number);
                result.add(view);
            }
        }

        //主交付BU、交付负责人
        Long deliBuId = saleConContractVO.getDeliBuId();
        if (deliBuId != null) {
            ConAchieveDVO view = new ConAchieveDVO();
            view.setBuId(deliBuId);
            view.setAchieveType(DELI); //交付
            view.setChargeResId(saleConContractVO.getDeliUserId());
            Integer number = new Random().nextInt(900000) + 100000;
            view.setId(System.currentTimeMillis() + number);
            result.add(view);
        }

        //副交付BU和副交付负责人
        if (parentCon != null) {
            Long codeliBuId = parentCon.getCodeliBuId();
            if (codeliBuId != null) {
                ConAchieveDVO view = new ConAchieveDVO();
                view.setBuId(codeliBuId);
                view.setAchieveType(CODELI); //副交付
                view.setChargeResId(parentCon.getCodeliUserId());
                Integer number = new Random().nextInt(900000) + 100000;
                view.setId(System.currentTimeMillis() + number);
                result.add(view);
            }
        }

        //售前BU和售前负责人
        Long preSaleBuId = saleConContractVO.getPreSaleBuId();
        if (preSaleBuId != null) {
            ConAchieveDVO view = new ConAchieveDVO();
            view.setBuId(preSaleBuId);
            view.setAchieveType(PRE_SALE); //售前
            view.setChargeResId(saleConContractVO.getPreSaleUserId());
            Integer number = new Random().nextInt(900000) + 100000;
            view.setId(System.currentTimeMillis() + number);
            result.add(view);
        }
        return result;
    }

    /**
     * init符号和deli-dib
     *
     *  第一条：业绩类别=签约，部门=签单BU，比例=100%，金额=有效销售额*比例，金额不可修改，价值角色=空，部门归属人员=空，备注=空；
     *  第二条：业绩类别=回款，部门=交付BU，比例=100%，金额=有效销售额*比例，金额不可修改，价值角色=空，部门归属人员=空，备注=空；
     *
     * @param contractId 合同id
     * @return {@link List}<{@link ConAchieveDVO}>
     */
    @Override
    public List<ConAchieveDVO> initSignAndDeliDib(Long contractId, BigDecimal obversionEffectiveAmt) {
        List<ConAchieveDVO> result = new ArrayList<>();
        SaleConContractVO saleConContractVO = saleConContractDAO.queryByKey(contractId);
        if (saleConContractVO == null) {
            return result;
        }

    //    SaleConContractPayload contractPayload = SaleConContractConvert.INSTANCE.toPayload(saleConContractVO);
      //  contractPayload.setAmt(contractPayload.getAmt());    //赋值给payload用以计算有效合同金额
     //   SaleConContractPayload saleConContractPayload = saleConContractService.subAmtCount(contractPayload);
        //合同签单金额
        BigDecimal amt = saleConContractVO.getAmt();
        if(null == obversionEffectiveAmt){
            obversionEffectiveAmt = amt;
        }
        // BigDecimal hundred = new BigDecimal("100");
        //签单BU
        Long signBuId = saleConContractVO.getSignBuId();
        if (signBuId != null) {
            ConAchieveDVO view = new ConAchieveDVO();
            view.setBuId(signBuId);
            view.setAchieveType(ConAchieveTypeEnum.SIGN.getCode()); //签约
            view.setRatio("100");
            view.setAmt(obversionEffectiveAmt);
            view.setUserRatio("100");
            view.setUserAmt(obversionEffectiveAmt);
            Integer number = new Random().nextInt(900000) + 100000;
            view.setId(System.currentTimeMillis() + number);
            result.add(view);
        }

        //主交付BU
        Long deliBuId = saleConContractVO.getDeliBuId();
        if (deliBuId != null) {
            ConAchieveDVO view = new ConAchieveDVO();
            view.setBuId(deliBuId);
            view.setRatio("100");
            view.setAmt(obversionEffectiveAmt);
            view.setUserRatio("100");
            view.setUserAmt(obversionEffectiveAmt);
            view.setAchieveType(ConAchieveTypeEnum.RETURN.getCode()); //回款
            Integer number = new Random().nextInt(900000) + 100000;
            view.setId(System.currentTimeMillis() + number);
            result.add(view);
        }
        return result;
    }
}
