package com.elitesland.tw.tw5.server.prd.system.controller;


import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemGrossMarginPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemGrossMarginQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemGrossMarginService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 阶梯毛利率设置
 *
 * @author likunpeng
 * @date 2023-04-03
 */
@Api(tags = "阶梯毛利率设置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system/prdSystemGrossMargin")
@Slf4j
public class PrdSystemGrossMarginController {

    private final PrdSystemGrossMarginService prdSystemGrossMarginService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody PrdSystemGrossMarginPayload payload){
        return TwOutputUtil.ok(prdSystemGrossMarginService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody PrdSystemGrossMarginPayload payload){
        return TwOutputUtil.ok(prdSystemGrossMarginService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(prdSystemGrossMarginService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(PrdSystemGrossMarginQuery query) {
        return TwOutputUtil.ok(prdSystemGrossMarginService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(PrdSystemGrossMarginQuery query) {
        return TwOutputUtil.ok(prdSystemGrossMarginService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        prdSystemGrossMarginService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 主键删除
     * @param key
     * @return result
     */
    @DeleteMapping("/delete/{key}")
    @ApiOperation("删除")
    public TwOutputUtil deleteByKey(@PathVariable Long key) {
        prdSystemGrossMarginService.delete(key);
        return TwOutputUtil.ok();
    }

}
