package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemBusinessObjectConfigDO;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

/**
 * @Author Lenovo
 * @Date 2023/11/14 9:48
 **/
@Repository
@RequiredArgsConstructor
public class PrdSystemBusinessObjectConfigDAO {

    private final JPAQueryFactory jpaQueryFactory;

    private final QPrdSystemBusinessObjectConfigDO qdo = QPrdSystemBusinessObjectConfigDO.prdSystemBusinessObjectConfigDO;

    /**
     * 根据业务对象主键查询 团队成员面板属性
     *
     * @param objectId
     * @return
     */
    public String getIsMemberByObjectId(Long objectId) {
        JPAQuery<String> jpaQuery = jpaQueryFactory.select(qdo.isMember).from(qdo).where(qdo.objectId.longValue().eq(objectId));
        return jpaQuery.fetchOne();
    }

}
