package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleFunctionVO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemNewFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemRoleFunctionDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author Quruiqizz
 * @Date 2023/11/8 10:40
 **/
@Repository
@RequiredArgsConstructor
public class PrdSystemRoleFunctionDAO {

    private final JPAQueryFactory jpaQueryFactory;

    private final QPrdSystemRoleFunctionDO roleFunctionDO = QPrdSystemRoleFunctionDO.prdSystemRoleFunctionDO;

    private final QPrdSystemRoleDO roleDO = QPrdSystemRoleDO.prdSystemRoleDO;

    private final QPrdSystemNewFunctionDO newFunctionDO = QPrdSystemNewFunctionDO.prdSystemNewFunctionDO;

    /**
     * 根据功能编码和角色编码集合 查询关联关系
     *
     * @param functionCode
     * @param roleCodes
     * @return
     */
    public Long listByFunctionCodeAndRoleCodes(String functionCode, List<String> roleCodes) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(roleFunctionDO.id).from(roleFunctionDO).leftJoin(roleDO).on(roleFunctionDO.roleId.longValue().eq(roleDO.id.longValue()))
                .leftJoin(newFunctionDO).on(newFunctionDO.id.longValue().eq(roleFunctionDO.functionId.longValue()))
                .where(newFunctionDO.functionCode.eq(functionCode).and(roleDO.roleCode.in(roleCodes)));

        return jpaQuery.fetchFirst();
    }

}
