package com.elitesland.tw.tw5.server.prd.task.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsTaskRouteDtlPayload;
import com.elitesland.tw.tw5.api.prd.task.query.PmsTaskRouteDtlQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.task.service.inf.PmsTaskRouteDtlService;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsTaskRouteDtlVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 任务路线图明细
 * @author wangxl
 * @date 2024/4/28
 */
@RestController
@RequestMapping("/api/pmsTaskRouteDtl")
@RequiredArgsConstructor
@Slf4j
@Api(value = "任务路线图明细", tags = {"任务路线图明细"})
public class PmsTaskRouteDtlController {

    private final PmsTaskRouteDtlService service;

    @ApiOperation("分页查询")
    @GetMapping("/page")
    public TwOutputUtil<PagingVO<PmsTaskRouteDtlVO>> page(PmsTaskRouteDtlQuery query) {
        return service.queryPage(query);
    }

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TwOutputUtil<List<PmsTaskRouteDtlVO>> list(PmsTaskRouteDtlQuery query) {
        return service.queryList(query);
    }


    @ApiOperation("关系列表查询")
    @GetMapping("/childList")
    public TwOutputUtil<PmsTaskRouteDtlVO> childList(PmsTaskRouteDtlQuery query) {
        return service.childList(query);
    }


    @ApiOperation("主键查询")
    @GetMapping("/key")
    public TwOutputUtil<PmsTaskRouteDtlVO> queryByKey(Long id) {
        return service.queryByKey(id);
    }

    @ApiOperation("新增")
    @PostMapping("/insert")
    // @DuplicateSubmissionPrevention
    public TwOutputUtil<PmsTaskRouteDtlVO> insert(@RequestBody PmsTaskRouteDtlPayload payload) {
        // 关键日志打印
        log.debug("【PmsTaskRouteDtlController.insert】入参："+payload.toString());
        return service.insert(payload);
    }

    @ApiOperation("修改")
    @PostMapping("/update")
    public TwOutputUtil<PmsTaskRouteDtlVO> update(@RequestBody PmsTaskRouteDtlPayload payload) {
        // 关键日志打印
        log.debug("【PmsTaskRouteDtlController.update】入参："+payload.toString());
        return service.update(payload);
    }

    @ApiOperation("动态修改")
    @PostMapping("/updateDynamic")
    public TwOutputUtil<PmsTaskRouteDtlVO> updateDynamic(@RequestBody PmsTaskRouteDtlPayload payload) {
        // 关键日志打印
        log.debug("【PmsTaskRouteDtlController.updateDynamic】入参："+payload.toString());
        return service.updateDynamic(payload);
    }

    @ApiOperation("删除")
    @PostMapping("/deleteSoft")
    public TwOutputUtil<Long> deleteSoft(@RequestBody List<Long> ids) {
        log.debug("【PmsTaskRouteDtlController.deleteSoft】入参："+ids);
        return service.deleteSoft(ids);
    }
}
