package com.elitesland.tw.tw5.server.prd.task.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsWbsTaskPayload;
import com.elitesland.tw.tw5.api.prd.task.query.PmsWbsTaskQuery;
import com.elitesland.tw.tw5.api.prd.task.service.PmsWbsTaskService;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsWbsTaskVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * 节点任务
 *
 * @author xxb
 * @date 2023-07-11
 */
@Api(tags = "节点任务")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsWbsTask")
@Slf4j
public class PmsWbsTaskController {

    private final PmsWbsTaskService pmsWbsTaskService;

    /**
     * 节点任务-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("节点任务-新增")
    public TwOutputUtil<PmsWbsTaskVO> insert(@RequestBody PmsWbsTaskPayload payload) {
        return TwOutputUtil.ok(pmsWbsTaskService.insert(payload));
    }

    /**
     * 节点任务-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("节点任务-更新")
    public TwOutputUtil<PmsWbsTaskVO> update(@RequestBody PmsWbsTaskPayload payload) {
        return TwOutputUtil.ok(pmsWbsTaskService.update(payload));
    }



    /**
     * 节点任务-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("节点任务-主键查询")
    public TwOutputUtil<PmsWbsTaskVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsWbsTaskService.queryByKey(key));
    }

    /**
     * 节点任务-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("节点任务-分页")
    public TwOutputUtil<PagingVO<PmsWbsTaskVO>> paging(PmsWbsTaskQuery query) {
        return TwOutputUtil.ok(pmsWbsTaskService.queryPaging(query));
    }

    /**
     * 节点任务-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("节点任务-查询列表")
    public TwOutputUtil<List<PmsWbsTaskVO>> queryList(PmsWbsTaskQuery query) {
        return TwOutputUtil.ok(pmsWbsTaskService.queryListDynamic(query));
    }

    /**
     * 节点任务-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("节点任务-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsWbsTaskService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 指派任务
     *
     * @param keys
     * @param wbsId
     * @return
     */
    @GetMapping("/appointedTask")
    @ApiOperation("指派任务")
    public TwOutputUtil appointedTask(Long[] keys,Long wbsId) {
        pmsWbsTaskService.appointedTask(Arrays.asList(keys),wbsId);
        return TwOutputUtil.ok();
    }

    /**
     *  编辑权重
     * @return
     */
    @GetMapping("/updateTaskWeight")
    @ApiOperation("编辑权重")
    public TwOutputUtil updateTaskWeight(Long wbsId,Long taskId, BigDecimal weight) {
        pmsWbsTaskService.updateTaskWeight(wbsId,taskId,weight);
        return TwOutputUtil.ok();
    }

    /**
     *  任务 暂挂、激活、已完成
     *
     * @param keys
     * @param taskStatus
     * @return
     */
    @GetMapping("/updateTaskStatus")
    @ApiOperation("任务 暂挂、激活、已完成")
    public TwOutputUtil updateTaskStatus(Long[] keys,String taskStatus) {
        pmsWbsTaskService.updateTaskStatus(Arrays.asList(keys),taskStatus);
        return TwOutputUtil.ok();
    }
}
