package com.elitesland.tw.tw5.server.prd.task.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 节点任务
 *
 * @author xxb
 * @date 2023-07-11
 */
@Entity
@Table(name = "pms_wbs_task", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_wbs_task", comment = "节点任务")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsWbsTaskDO extends BaseModel implements Serializable {
    /**
     * 项目主键
     */
    @Comment("项目主键")
    @Column()
    private Long projectId;
    /**
     * wbs主键
     */
    @Comment("wbs主键")
    @Column()
    private Long wbsId;

    /** 资源类型(labour人工、material材料、device设备) */
    @Comment("资源类型(labour人工、material材料、device设备)")
    @Column()
    private String sourceType;
    /**
     * 发包人id
     */
    @Comment("发包人id")
    @Column()
    private Long disterUserId;
    /**
     * 接包人id
     */
    @Comment("接包人id")
    @Column()
    private Long receiverUserId;
    /**
     * 任务编号
     */
    @Comment("任务编号")
    @Column()
    private String taskCode;
    /**
     * 任务名称
     */
    @Comment("任务名称")
    @Column()
    private String taskName;
    /**
     * 任务状态
     */
    @Comment("任务状态")
    @Column()
    private String taskStatus;
    /**
     * 任务开始时间
     */
    @Comment("任务开始时间")
    @Column()
    private LocalDate startDate;
    /**
     * 任务结束时间
     */
    @Comment("任务结束时间")
    @Column()
    private LocalDate endDate;
    /**
     * 派发人天
     */
    @Comment("派发人天")
    @Column()
    private BigDecimal days;
    /**
     * 角色主键
     */
    @Comment("角色主键")
    @Column()
    private Long projectRoleId;

    @Comment("进度")
    @Column()
    private BigDecimal progress;

    @Comment("权重")
    @Column()
    private BigDecimal weight;

    @Comment("任务说明")
    @Column()
    private String taskExplain;

    @Comment("交付文档")
    @Column()
    private String deliveryDocuments;

    /**
     * 权重设置方式
     */
    @FieldCreateLog(fieldName = "权重设置方式：1为手动设置  0为系统设置")
    @Comment("权重设置方式：1为手动设置  0为系统设置")
    @Column(columnDefinition = "tinyint NOT NULL DEFAULT 0")
    private Integer manualSettingWeight = 0;

    public void copy(PmsWbsTaskDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
