package com.elitesland.tw.tw5.server.prd.task.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 任务结算工时关系表
 *
 * @author carl
 * @date 2023-12-20
 */
@Entity
@Table(name = "task_settle_timesheet", indexes = {
        @Index(name = "task_index", columnList = "task_id"),
        @Index(name = "settle_index", columnList = "settle_id"),
        @Index(name = "timesheet_index", columnList = "timesheet_id"),
        @Index(name = "settle_flag_index", columnList = "settle_flag"),
})
@org.hibernate.annotations.Table(appliesTo = "task_settle_timesheet", comment = "任务结算工时关系表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TaskSettleTimesheetDO extends BaseModel implements Serializable {
    /**
     * 任务id
     */
    @Comment("任务id")
    @Column(name = "task_id")
    private Long taskId;
    /**
     * 结算id
     */
    @Comment("结算id")
    @Column(name = "settle_id")
    private Long settleId;
    /**
     * 工时id
     */
    @Comment("工时id")
    @Column(name = "timesheet_id")
    private Long timesheetId;

    @Comment("关联活动")
    @Column()
    private Long relatedActId;
    /**
     * 工时
     */
    @Comment("工时")
    @Column()
    private BigDecimal workHour;
    /**
     * 当量
     */
    @Comment("当量")
    @Column()
    private BigDecimal eqva;
    /**
     * 工作日期
     */
    @Comment("工作日期")
    @Column()
    private LocalDate workDate;
    /**
     * 工作日志
     */
    @Comment("工作日志")
    @Column()
    private String workDesc;
    /**
     * 工时任务结算流转标记（后改的，结构不好动所以命名和值定义不太合理）：-1或null已提交，0已审批，1已结算
     */
    @Comment("工时任务结算流转标记：-1或null已提交，0已审批，1已结算")
    @Column(name = "settle_flag", columnDefinition = "tinyint  DEFAULT 0")
    private Integer settleFlag;

    public void copy(TaskSettleTimesheetDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
