package com.elitesland.tw.tw5.server.prd.task.service;


import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsTaskRouteDtlPayload;
import com.elitesland.tw.tw5.api.prd.task.query.PmsTaskRouteDtlQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsTaskRouteDtlVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.task.dao.PmsTaskRouteDtlDao;
import com.elitesland.tw.tw5.server.prd.task.service.inf.PmsTaskRouteDtlService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;


/**
 * 任务路线图明细service impl
 *
 * @author wangxl
 * @date 2024/4/28
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsTaskRouteDtlServiceImpl implements PmsTaskRouteDtlService {

    private final PmsTaskRouteDtlDao dao;

    private final TaskInfoService taskInfoService;

    @Override
    public TwOutputUtil<PagingVO<PmsTaskRouteDtlVO>> queryPage(PmsTaskRouteDtlQuery query) {
        PagingVO<PmsTaskRouteDtlVO> pageVO = dao.queryPage(query);
        translate(pageVO.getRecords());
        return TwOutputUtil.ok(pageVO);
    }

    @Override
    public TwOutputUtil<List<PmsTaskRouteDtlVO>> queryList(PmsTaskRouteDtlQuery query) {
        List<PmsTaskRouteDtlVO> listVO = dao.queryList(query);
        translate(listVO);
        return TwOutputUtil.ok(listVO);
    }

    @Override
    public TwOutputUtil<Long> queryCount(PmsTaskRouteDtlQuery query) {
        return TwOutputUtil.ok(dao.queryCount(query));
    }

    @Override
    public TwOutputUtil<PmsTaskRouteDtlVO> queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsTaskRouteDtlVO vo = dao.queryByKey(id);
        Assert.notNull(vo, "查询的数据不存在");
        translate(List.of(vo));
        return TwOutputUtil.ok(vo);
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsTaskRouteDtlVO> insert(PmsTaskRouteDtlPayload payload) {

        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsTaskRouteDtlVO save = dao.save(payload);
        // 开启工作流
        // startWorkFlow(ado);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsTaskRouteDtlVO> update(PmsTaskRouteDtlPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsTaskRouteDtlVO save = dao.save(payload);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsTaskRouteDtlVO> updateDynamic(PmsTaskRouteDtlPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        dao.updateByKeyDynamic(payload);
        return queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<Long> deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw  TwException.error("","ids参数不能为空");
        }
        return TwOutputUtil.ok(dao.deleteSoft(ids));
    }

    @Override
    public TwOutputUtil<PmsTaskRouteDtlVO> childList(PmsTaskRouteDtlQuery query) {

        Assert.notNull(query.getProjectId(), "项目id不能为空");
        Assert.notNull(query.getMasId(), "masId不能为空");

        // 查询V0主集
        if (query.getParentId() == null) {
            query.setParentId(0L);
        }
        TwOutputUtil<List<PmsTaskRouteDtlVO>> listTwOutputUtil = this.queryList(query);
        PmsTaskRouteDtlVO pmsV0TaskRouteDtlVO = listTwOutputUtil.getData().get(0);
        Long v0Id = pmsV0TaskRouteDtlVO.getId();
        query.setParentId(v0Id);
        // 获取下级元素
        List<PmsTaskRouteDtlVO> pmsTaskRouteDtlVOS1 = childData(query);
        pmsV0TaskRouteDtlVO.setChildren(pmsTaskRouteDtlVOS1);

        return TwOutputUtil.ok(pmsV0TaskRouteDtlVO);
    }

    private List<PmsTaskRouteDtlVO> childData(PmsTaskRouteDtlQuery query) {

        TwOutputUtil<List<PmsTaskRouteDtlVO>> listTwOutputUtil = this.queryList(query);
        for (PmsTaskRouteDtlVO pmsTaskRouteDtlVO : listTwOutputUtil.getData()) {

            query.setParentId(pmsTaskRouteDtlVO.getId());
            List<PmsTaskRouteDtlVO> pmsTaskRouteDtlVOS = this.childData(query);
            pmsTaskRouteDtlVO.setChildren(pmsTaskRouteDtlVOS);

        }
        return listTwOutputUtil.getData();
    }


    /**
     * 发起工作流
     *
     * @param payload payload
     * @return result
     */
    private TwOutputUtil<Long> startWorkFlow(PmsTaskRouteDtlPayload payload) {
        // 发起工作流程
        HashMap<String, Object> varMaps = new HashMap<>();
//        Assert.notNull(payload.getUserId(), "userId不能为空");
//        // 变更资源审批
//        varMaps.put("Activity_111kevq", payload.getUserId());
        //发起流程审批
//        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                HrBaseEnum.BASE_BU_CHANGE.getCode(),
//                HrBaseEnum.BASE_BU_CHANGE.getDesc(),
//                res.getId().toString(), varMaps));
//        String procInstId = processInfo.getProcInstId();
//        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        String procInstId = "";
        // 回写单据的工作流信息
//        payload.setProcInstId(procInstId);
//        payload.setProcInstStatus("");
        Long update = dao.updateByKeyDynamic(payload);
        return TwOutputUtil.ok(update);
    }

    /**
     * 数据校验
     *
     * @param payload payload
     */
    private void checkData(PmsTaskRouteDtlPayload payload) {
        Assert.notNull(payload.getMasId(), "路线图id不能为空");
//        Assert.notNull(payload.getTaskId(), "任务id不能为空");

    }

    /**
     * todo
     *
     * @param vos vos
     */
    private void translate(List<PmsTaskRouteDtlVO> vos) {
        vos.forEach(vo -> {
            // 翻译vo对象
//            vo.setUserIdDesc("");
            if (null != vo.getTaskId()) {
                // 赋值任务系信息
                TaskInfoVO taskInfoVO = taskInfoService.queryByKey(vo.getTaskId(), false);
                vo.setTaskName(taskInfoVO.getTaskName());
                vo.setTaskNo(taskInfoVO.getTaskNo());
                vo.setStateFlowId(taskInfoVO.getStateFlowId());
                vo.setStateFlowName(taskInfoVO.getStateFlowName());
                vo.setPlanStartDate(taskInfoVO.getPlanStartDate());
                vo.setPlanEndDate(taskInfoVO.getPlanEndDate());
                vo.setTaskResId(taskInfoVO.getTaskResId());
                vo.setTaskRes(taskInfoVO.getTaskRes());
                vo.setTaskDes(taskInfoVO.getTaskDes());
                vo.setPriority(taskInfoVO.getPriority());

            }


        });
    }

}
