package com.elitesland.tw.tw5.server.prd.task.service;


import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsTaskRouteDtlPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsTaskRoutePayload;
import com.elitesland.tw.tw5.api.prd.task.query.PmsTaskRouteDtlQuery;
import com.elitesland.tw.tw5.api.prd.task.query.PmsTaskRouteQuery;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.task.dao.PmsTaskRouteDtlDao;
import com.elitesland.tw.tw5.server.prd.task.service.inf.PmsTaskRouteService;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsTaskRouteDtlVO;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsTaskRouteVO;
import com.elitesland.tw.tw5.server.prd.task.dao.PmsTaskRouteDao;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 任务路线图service impl
 *
 * @author wangxl
 * @date 2024/4/18
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsTaskRouteServiceImpl implements PmsTaskRouteService {

    private final PmsTaskRouteDao dao;
    private final PmsTaskRouteDtlDao pmsTaskRouteDtlDao;

    private final CacheUtil cacheUtil;

    @Override
    public TwOutputUtil<PagingVO<PmsTaskRouteVO>> queryPage(PmsTaskRouteQuery query) {
        PagingVO<PmsTaskRouteVO> pageVO = dao.queryPage(query);
        translate(pageVO.getRecords());
        return TwOutputUtil.ok(pageVO);
    }

    @Override
    public TwOutputUtil<List<PmsTaskRouteVO>> queryList(PmsTaskRouteQuery query) {
        if (null != query.getTaskId()) {
            PmsTaskRouteDtlQuery pmsTaskRouteDtlQuery = new PmsTaskRouteDtlQuery();
            pmsTaskRouteDtlQuery.setTaskId(query.getTaskId());
            List<PmsTaskRouteDtlVO> pmsTaskRouteDtlVOS = pmsTaskRouteDtlDao.queryList(pmsTaskRouteDtlQuery);
            List<Long> ids = pmsTaskRouteDtlVOS.stream().map(PmsTaskRouteDtlVO::getMasId).collect(Collectors.toList());
            if (ids.isEmpty()){
                ids.add(0L);
            }
            query.setIds(ids);
        }
        List<PmsTaskRouteVO> listVO = dao.queryList(query);
        translate(listVO);
        return TwOutputUtil.ok(listVO);
    }

    @Override
    public TwOutputUtil<Long> queryCount(PmsTaskRouteQuery query) {
        return TwOutputUtil.ok(dao.queryCount(query));
    }

    @Override
    public TwOutputUtil<PmsTaskRouteVO> queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsTaskRouteVO vo = dao.queryByKey(id);
        Assert.notNull(vo, "查询的数据不存在");
        translate(List.of(vo));
        return TwOutputUtil.ok(vo);
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsTaskRouteVO> insert(PmsTaskRoutePayload payload) {

        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsTaskRouteVO save = dao.save(payload);
        // 开启工作流
        // startWorkFlow(ado);
        // 初始化时默认增加一条明细
        PmsTaskRouteDtlPayload pmsTaskRouteDtlPayload = new PmsTaskRouteDtlPayload();
        pmsTaskRouteDtlPayload.setMasId(save.getId());
        pmsTaskRouteDtlPayload.setParentId(0L);
        pmsTaskRouteDtlPayload.setProjectId(save.getProjectId());
        pmsTaskRouteDtlDao.save(pmsTaskRouteDtlPayload);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsTaskRouteVO> update(PmsTaskRoutePayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsTaskRouteVO save = dao.save(payload);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsTaskRouteVO> updateDynamic(PmsTaskRoutePayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        dao.updateByKeyDynamic(payload);
        return queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<Long> deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw  TwException.error("","ids参数不能为空");
        }
        dao.deleteSoft(ids);
        // 明细删除
        pmsTaskRouteDtlDao.deleteByMasId(ids);

        return TwOutputUtil.ok();
    }

    @Override
    public TwOutputUtil<List<PmsTaskRouteVO>> childList(PmsTaskRouteQuery query) {

        Assert.notNull(query.getProjectId(), "项目id不能为空");

        return null;
    }


    /**
     * 发起工作流
     *
     * @param payload payload
     * @return result
     */
    private TwOutputUtil<Long> startWorkFlow(PmsTaskRoutePayload payload) {
        // 发起工作流程
        HashMap<String, Object> varMaps = new HashMap<>();
//        Assert.notNull(payload.getUserId(), "userId不能为空");
//        // 变更资源审批
//        varMaps.put("Activity_111kevq", payload.getUserId());
        //发起流程审批
//        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                HrBaseEnum.BASE_BU_CHANGE.getCode(),
//                HrBaseEnum.BASE_BU_CHANGE.getDesc(),
//                res.getId().toString(), varMaps));
//        String procInstId = processInfo.getProcInstId();
//        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        String procInstId = "";
        // 回写单据的工作流信息
//        payload.setProcInstId(procInstId);
//        payload.setProcInstStatus("");
        Long update = dao.updateByKeyDynamic(payload);
        return TwOutputUtil.ok(update);
    }

    /**
     * 数据校验
     *
     * @param payload payload
     */
    private void checkData(PmsTaskRoutePayload payload) {

        Assert.notNull(payload.getProjectId(), "projectId不能为空");
        Assert.notEmpty(payload.getName(), "名称不能为空");
    }

    /**
     * todo
     *
     * @param vos vos
     */
    private void translate(List<PmsTaskRouteVO> vos) {
        vos.forEach(vo -> {
            // 翻译vo对象
            vo.setCreator(cacheUtil.getUserName(vo.getCreateUserId()));
        });
    }

}