package com.elitesland.tw.tw5.server.prd.taskpro.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskCategoryPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskCategoryQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskCategoryVO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskCategoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 任务类别
 *
 * @author duwh
 * @date 2024-01-31
 */
@Api(tags = "任务类别")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/taskCategory")
@Slf4j
public class TaskCategoryController {

    private final TaskCategoryService taskCategoryService;


    /**
     * 任务类别-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("任务类别-新增")
    public TwOutputUtil<TaskCategoryVO> insert(@RequestBody TaskCategoryPayload payload) {
        return TwOutputUtil.ok(taskCategoryService.insert(payload));
    }

    /**
     * 任务类别-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("任务类别-更新")
    public TwOutputUtil<TaskCategoryVO> update(@RequestBody TaskCategoryPayload payload) {
        return TwOutputUtil.ok(taskCategoryService.update(payload));
    }

    /**
     * 任务类别-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("任务类别-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TaskCategoryPayload payload) {
        return TwOutputUtil.ok(taskCategoryService.updateByKeyDynamic(payload));
    }

    /**
     * 任务类别-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("任务类别-主键查询")
    public TwOutputUtil<TaskCategoryVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(taskCategoryService.queryByKey(key));
    }

    /**
     * 任务类别-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("任务类别-分页")
    public TwOutputUtil<PagingVO<TaskCategoryVO>> paging(TaskCategoryQuery query) {
        return TwOutputUtil.ok(taskCategoryService.queryPaging(query));
    }

    /**
     * 任务类别-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("任务类别-查询列表")
    public TwOutputUtil<List<TaskCategoryVO>> queryList(TaskCategoryQuery query) {
        return TwOutputUtil.ok(taskCategoryService.queryListDynamic(query));
    }

    /**
     * 任务类别-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("任务类别-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        taskCategoryService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
