package com.elitesland.tw.tw5.server.prd.taskpro.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskMemberRefVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskMemberRefPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskMemberRefQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskMemberRefService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 通用任务成员关系
 *
 * @author duwh
 * @date 2024-02-01
 */
@Api(tags = "通用任务成员关系")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/taskMemberRef")
@Slf4j
public class TaskMemberRefController {

    private final TaskMemberRefService taskMemberRefService;

    /**
     * 通用任务成员关系-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("通用任务成员关系-新增")
    public TwOutputUtil<TaskMemberRefVO> insert(@RequestBody TaskMemberRefPayload payload){
        return TwOutputUtil.ok(taskMemberRefService.insert(payload));
    }

    /**
     * 通用任务成员关系-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("通用任务成员关系-更新")
    public TwOutputUtil<TaskMemberRefVO> update(@RequestBody TaskMemberRefPayload payload){
        return TwOutputUtil.ok(taskMemberRefService.update(payload));
    }

    /**
     * 通用任务成员关系-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("通用任务成员关系-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TaskMemberRefPayload payload){
        return TwOutputUtil.ok(taskMemberRefService.updateByKeyDynamic(payload));
    }

    /**
     * 通用任务成员关系-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("通用任务成员关系-主键查询")
    public TwOutputUtil<TaskMemberRefVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(taskMemberRefService.queryByKey(key));
    }

    /**
     * 通用任务成员关系-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("通用任务成员关系-分页")
    public TwOutputUtil<PagingVO<TaskMemberRefVO>>  paging(TaskMemberRefQuery query) {
        return TwOutputUtil.ok(taskMemberRefService.queryPaging(query));
    }

    /**
     * 通用任务成员关系-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("通用任务成员关系-查询列表")
    public TwOutputUtil<List<TaskMemberRefVO>> queryList(TaskMemberRefQuery query) {
        return TwOutputUtil.ok(taskMemberRefService.queryListDynamic(query));
    }

    /**
     * 通用任务成员关系-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("通用任务成员关系-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        taskMemberRefService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
