package com.elitesland.tw.tw5.server.prd.taskpro.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskProVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskProBoardVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.taskpro.convert.TaskProConvert;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskProPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskProQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskProBoardViewGroupInfoVO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskProExcelVO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskProService;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 任务主档
 *
 * @author duwh
 * @date 2024-02-01
 */
@Api(tags = "任务主档")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/taskPro")
@Slf4j
public class TaskProController {

    private final TaskProService taskProService;
    private final UdcUtil udcUtil;

    /**
     * 任务主档-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("任务主档-新增")
    public TwOutputUtil<TaskProVO> insert(@RequestBody TaskProPayload payload) {
        return TwOutputUtil.ok(taskProService.insert(payload));
    }

    @PostMapping("createSub")
    @ApiOperation("任务主档-新增子任务")
    public TwOutputUtil<TaskProVO> createSub(@RequestBody TaskProPayload payload) {
        return TwOutputUtil.ok(taskProService.createSub(payload));
    }

    /**
     * 任务主档-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("任务主档-更新")
    public TwOutputUtil<TaskProVO> update(@RequestBody TaskProPayload payload) {
        return TwOutputUtil.ok(taskProService.update(payload));
    }

    @PostMapping("top")
    @ApiOperation("任务主档-置顶")
    public TwOutputUtil<TaskProVO> top(@RequestBody TaskProPayload payload) {
        return TwOutputUtil.ok(taskProService.top(payload));
    }

    /**
     * 任务主档-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("任务主档-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TaskProPayload payload) {
        return TwOutputUtil.ok(taskProService.updateByKeyDynamic(payload));
    }

    @PostMapping("updateBatch")
    @ApiOperation("任务主档-批量更新")
    public TwOutputUtil<Boolean> updateBatch(@RequestBody List<TaskProPayload> payloadList) {
        return TwOutputUtil.ok(taskProService.updateBatch(payloadList));
    }

    /**
     * 任务主档-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("任务主档-主键查询")
    public TwOutputUtil<TaskProVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(taskProService.queryByKey(key));
    }

    /**
     * 任务主档-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("任务主档-分页")
    public TwOutputUtil<PagingVO<TaskProVO>> paging(TaskProQuery query) {
        // 查子任务
        // if (query.getParentId() == null) {
        //     query.setParentNullFlag(true);
        // }
        return TwOutputUtil.ok(taskProService.queryPaging(query));
    }

    /**
     * 任务主档-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("任务主档-查询列表")
    public TwOutputUtil<List<TaskProVO>> queryList(TaskProQuery query) {
        // 查子任务
        // if (query.getParentId() == null) {
        //     query.setParentNullFlag(true);
        // }

        return TwOutputUtil.ok(taskProService.queryListDynamic(query));
    }

    @GetMapping("/tree")
    // @UdcNameClass
    @ApiOperation("任务主档-tree树形结构")
    public TwOutputUtil<List<TaskProVO>> tree(TaskProQuery query) {
        // 查子任务
        // if (query.getParentId() == null) {
        //     query.setParentNullFlag(true);
        // }
        return TwOutputUtil.ok(taskProService.tree(query));
    }

    @GetMapping("/excelExport")
    @ApiOperation("任务主档-excel导出")
    public void excelExport(TaskProQuery query, HttpServletResponse response) throws IOException {
        // 查子任务
        // if (query.getParentId() == null) {
        //     query.setParentNullFlag(true);
        // }
        //定义文件名称
        String sheetName = "任务列表";
        //导出顺序是反的
        // OrderItem orderItem = OrderItem.asc("createTime");
        // query.defaultOrder(orderItem);
        List<OrderItem> taskOrderItemList = new ArrayList<>();
        taskOrderItemList.add(OrderItem.asc("topFlag"));
        taskOrderItemList.add(OrderItem.asc("topModifyTime"));
        taskOrderItemList.add(OrderItem.asc("sort"));
        taskOrderItemList.add(OrderItem.asc("createTime"));
        query.setOrders(taskOrderItemList);

        //获取想要导出的数据
        List<TaskProVO> vos = taskProService.queryListDynamicForExcelExport(query);
        vos.forEach(vo -> {
            taskProService.translate(vo);
        });
        List<TaskProExcelVO> resultList = TaskProConvert.INSTANCE.voListVoExcelExport(vos);
        resultList = udcUtil.translateList(resultList);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), TaskProExcelVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        ExcelUtil.excelHelper(sheet, TaskProExcelVO.class, null);
        //写入
        sheet.doWrite(resultList);
    }

    /**
     * 任务主档-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("任务主档-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        taskProService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    @PostMapping("updatePartiesId")
    @ApiOperation("任务主档-批量修改负责人")
    public TwOutputUtil<Boolean> updatePartiesId(@RequestBody List<TaskProQuery> taskProQueryList) {
        Boolean res = taskProService.updatePartiesId(taskProQueryList);
        return TwOutputUtil.ok(res);
    }

    @PostMapping("unbindRef")
    @ApiOperation("任务主档-子任务父任务解绑")
    public TwOutputUtil<Boolean> unbindRef(Long subTaskId, Long parentTaskId) {
        Boolean res = taskProService.unbindRef(subTaskId, parentTaskId);
        return TwOutputUtil.ok(res);
    }


    @GetMapping("/boardViewGroup")
    @ApiOperation("任务主档-看板视图分组")
    public TwOutputUtil<List<TaskProBoardViewGroupInfoVO>> boardViewGroup(TaskProQuery query) {
        // 查子任务
        // if (query.getParentId() == null) {
        //     query.setParentNullFlag(true);
        // }
        /**
         *   - 个人：我创建的、我负责的、我关注的、我参与的
         *   - 全部：个人+他人创建的任务（公开）
         */
        return TwOutputUtil.ok(taskProService.boardViewGroup(query));
    }


    @GetMapping("/boardView")
    @ApiOperation("任务主档-看板视图")
    public TwOutputUtil<List<TaskProBoardVO>> boardView(TaskProQuery query) {
        // 查子任务
        // if (query.getParentId() == null) {
        //     query.setParentNullFlag(true);
        // }
        return TwOutputUtil.ok(taskProService.boardView(query));
    }


    @GetMapping("/summaryWbs")
    @ApiOperation("活动进度汇总")
    public TwOutputUtil<BigDecimal> summaryWbs(Long wbsId, String type) {

        BigDecimal bigDecimal = taskProService.summaryWbs(wbsId, type);
        return TwOutputUtil.ok(bigDecimal);
    }

}
